/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */



#ifndef _OO_STYLESWRITER_H_
#define _OO_STYLESWRITER_H_

// External includes
#include <gsf/gsf.h>


// Internal classes
class OO_StylesContainer;

// Abiword classes
class UT_UTF8String;
class PD_Document;
class PP_AttrProp;



/**
 * OO_StylesWriter: This class writes the "styles.xml" portion
 * of the .sxw file. It can also be used to convert Abi's attributes and
 * properties.
 */
class OO_StylesWriter
{
public:

    /**
     * Write the styles stream.
     */
    static bool writeStyles(PD_Document* pDoc, GsfOutfile* oo,
        OO_StylesContainer& stylesContainer);
    
    /**
     * Add <office:font-decls> section to the buffer
     */
    static void addFontDecls(UT_UTF8String & buffer,
        OO_StylesContainer & stylesContainer);
    
    /**
     * Convert attributes and properties.
     */
    static void map(const PP_AttrProp* pAP, UT_UTF8String& styleAtts,
        UT_UTF8String& propAtts, UT_UTF8String& font);

    
private:
    OO_StylesWriter ();
};




#endif //_OO_STYLESWRITER_H_
