--[[-------------------------------------------------------------------
Palm 3169WW Universal Wireless Keyboard

9600 baud, 8N1

Key down sends six bytes:  0xFF, 0xC0, KEY, KEY_N, KEY', 0xC1
Key up sends six bytes:    0xFF, 0xC0, KEY | 0x80, KEY_N & 0x7F,
                           KEY' | 0x80, 0xC0

The KEY and KEY' values appear to represent two independent key
mappings (perhaps to provide some form of backwards compatiblity
with older Palm keyboards?).

For the sake of simplicity, this driver uses the KEY' values. A
slightly more robust implementation would be possible using the
KEY value and checking it against KEY_N (its inverse) at the
expense of more complex code and additional CPU overhead.

-----------

Copyright (c) 2005, David J. Kessler <dkessler@kopsisengineering.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-------------------------------------------------------------------]]--

-- Basic information about this driver
description = "Palm 3169WW Universal Wireless Keyboard Driver"
version = "0.3"

-- Modifier key information
scancode_fn = 0x65
scancode_punc = 0
scancode_num = 0
scancode_shiftl = 0x75
scancode_shiftr = 0x3e
scancode_caps = 0x3f
has_num_lock = 0
has_punc_lock = 0
has_fn_lock = 0

map_normal = {
	-- 0x01       0x02 0x03 0x04 0x05 0x06 0x07 
	ZK_BACKSPACE, 0,   0,   0,   0,   0,   ZK_DOWN,
	-- 0x08 0x09 0x0a 0x0b 0x0c 0x0d 0x0e 0x0f
	   0,   0,   0,   0,   0,   0,   0,   0,
	-- 0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17
	   0,   0,   0,   0,   0,   0,   0,   0,
	-- 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f
	   0,   0,   0,   0,   0,   0,   0,   0,
	-- 0x20 0x21 0x22 0x23 0x24 0x25 0x26 0x27
	0, ZK_9, ZK_0, ZK_O, ZK_I, ZK_K, 0, 0,
	-- 0x28 0x29      0x2a  0x2b          0x2c  0x2d      0x2e       0x2f
	   0,   ZK_MINUS, ZK_P, ZK_SEMICOLON, ZK_L, ZK_SLASH, ZK_PERIOD, ZK_COMMA,
	-- 0x30 0x31 0x32 0x33 0x34 0x35 0x36 0x37
	0, 0, ZK_EQUAL, ZK_BRACELEFT, 0, ZK_APOSTROPHE, 0, 0,
	-- 0x38 0x39     0x3a          0x3b 0x3c           0x3d       0x3e       0x3f
	   0,   ZK_LEFT, ZK_BACKSLASH, 0,   ZK_BRACERIGHT, ZK_RETURN, ZK_SHIFTR, ZK_CAPS,
	-- 0x40 0x41 0x42 0x43 0x44 0x45 0x46 0x47   
	0, ZK_3, ZK_4, ZK_E, ZK_D, ZK_X, ZK_C, 0,
	-- 0x48      0x49  0x4a  0x4b  0x4c  0x4d  0x4e      0x4f
	   ZK_RIGHT, ZK_5, ZK_R, ZK_T, ZK_F, ZK_V, ZK_SPACE, ZK_UP,
	-- 0x50 0x51 0x52 0x53 0x54 0x55 0x56 0x57
	0, ZK_6, ZK_Y, ZK_G, ZK_H, ZK_B, ZK_N, ZK_ALTR,
	-- 0x58 0x59  0x5a  0x5b  0x5c  0x5d  0x5e       0x5f
	   0,   ZK_8, ZK_7, ZK_U, ZK_J, ZK_M, ZK_ESCAPE, 0,
	-- 0x60 0x61 0x62 0x63 0x64 0x65 0x66 0x67   
	0, ZK_GRAVE, 0,   0, 0, 0, 0, 0,
	-- 0x68 0x69 0x6a    0x6b 0x6c  0x6d       0x6e 0x6f
	   0,   0,   ZK_TAB, 0,   0,    0,         0,   0,
	 -- 0x70    0x71  0x72  0x73         0x74  0x75         0x76 0x77  
	    ZK_DEL, ZK_1, ZK_Q, ZK_CONTROLL, 0,    ZK_SHIFTL,   0,   0,
	-- 0x78 0x79  0x7a  0x7b  0x7c    0x7d    0x7e 0x7f
	   0,   ZK_2, ZK_W, ZK_A, ZK_S,   ZK_Z,   0,   0 }

map_shift = {
	   0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, ZK_PARENLEFT, ZK_PARENRIGHT, 0, 0, 0, 0, 0,
	0, ZK_UNDERSCORE, 0, ZK_COLON, 0, ZK_QUESTION, ZK_GREATER, ZK_LESS,
	0, 0, ZK_PLUS, ZK_BRACKETLEFT, 0, ZK_QUOTEDBL, 0, 0,
	0, 0, ZK_BAR, 0, ZK_BRACKETRIGHT, 0, 0, 0,
	0, ZK_NUMBERSIGN, ZK_DOLLAR, 0, 0, 0, 0, 0,
	0, ZK_PERCENT, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, ZK_ASTERISK, ZK_AMPERSAND, 0, 0, 0, 0, 0,
	0, ZK_TILDE, 0, 0, 0, 0, 0, 0,
	0, ZK_EXCLAIM, 0, 0, 0, 0, 0, 0,
	0, ZK_AT, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

map_num = {0}

map_fn = {
	   0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, ZK_SILK4, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, ZK_OK, 0, 0,
	0, 0, ZK_SILK2, 0, 0, 0, 0, 0,
	0, ZK_SILK3, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, ZK_SILK5, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

last_key = 0
last_key_down = 0
byte_count = 0

-- Function to convert a byte received from the kb to a scancode
function do_scancode ( s )
	key = 0
	key_down = 0

	-- the end of sequence (0xC1) also appears as a key up
	-- code so we need an extra bit of logic to make sure
	-- we correctly detect end of sequence
	if (s == 0xff) then
		byte_count = 0
	else
		byte_count = byte_count + 1
	end

	key = s & 0x7f;
	if (s & 0x80 == 0x80) then
		key_down = 0
	else
		key_down = 1
	end

	-- look for final sequence byte 
	if (s == 0xC1 and byte_count == 5) then
		key = last_key;
		key_down = last_key_down;
	else
		last_key = key
		last_key_down = key_down
		key = 0
		key_down = 0
	end

	return key, key_down
end

