/*
   SHARP CE-AG06 library based on OPIE camera sources
   Copyright 2005 Alexander Chukov <sash@pdaXrom.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 */
#ifndef _ZCAMERA_H_
#define _ZCAMERA_H_

enum ReadMode {
        IMAGE = 0, STATUS = 1,
        FASTER = 0, BETTER = 2,
        XNOFLIP = 0, XFLIP = 4,
        YNOFLIP = 0, YFLIP = 8,
        AUTOMATICFLIP = -1
};

int 	cam_open(void);
int 	cam_close(void);
int 	cam_read( char* buf, int len );
int 	cam_write( char* buf, int len );
void	cam_init(void);
int 	cam_isShutterPressed(void);
void 	cam_clearShutterLatch(void);
int 	cam_isFinderReversed(void);
int 	cam_isCapturing(void);
int 	cam_isAvailable(void);
int 	cam_setCaptureFrame( int width, int height, int zoom, int rot );
int 	cam_setZoom( int zoom );
void 	cam_setReadMode( int mode );
void 	cam_setFlip( int flip );
int 	cam_snapshot( unsigned char* buf );
void	cam_captureFrame( int w, int h, int zoom, unsigned char* buf );
int 	cam_keyOn(void);

#endif
