/* Originally by Jeremy Schaeffer
 * Slightly modified by Ben Lynn
 */
/*
Copyright (C) 2002 Jeremy Schaeffer <jeremy@datye.zzn.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <glib.h>
#include <gtk/gtk.h>

#include "version.h"
#include "about.h"

static GtkWidget *about_win;

void xmmspipe_about(void)
{
    GtkWidget *button, *label, *bigbox, *buttonbox;

    if (about_win) return;
    //XXX: use xmms_show_message() instead?
    about_win = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(about_win), ("About"));
    gtk_window_set_policy(GTK_WINDOW(about_win), FALSE, FALSE, FALSE);
    gtk_window_set_position(GTK_WINDOW(about_win), GTK_WIN_POS_MOUSE);

    bigbox = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(about_win), bigbox);

    label = gtk_label_new("--== " PLUGIN_NAME " ==--");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
    gtk_container_add(GTK_CONTAINER(bigbox), label);

    label = gtk_label_new("\nControl XMMS via a named pipe");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
    gtk_container_add(GTK_CONTAINER(bigbox), label);

    label = gtk_label_new("\nCreated by Ben Lynn <blynn@cs.stanford.edu>\n"
	"\nMany improvements due to Jeremy Schaeffer\n"
	"\nThanks to Andy Gimblett, Felix, Orsila Heikki,\n"
	"and others for feedback, bugfixes and features\n\n");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
    gtk_container_add(GTK_CONTAINER(bigbox), label);

    buttonbox = gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox), GTK_BUTTONBOX_DEFAULT_STYLE);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttonbox), 5);
    gtk_box_pack_start(GTK_BOX(bigbox), buttonbox, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(about_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &about_win);
    button = gtk_button_new_with_label("Ok");
    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer) about_win);
    gtk_box_pack_start(GTK_BOX ((buttonbox)), button, FALSE, TRUE, 5);
    gtk_widget_show_all(about_win);
}
