##############################################################################
# $Id: xdtv.spec.in,v 1.6 2004/10/21 18:34:40 pingus77 Exp $
##############################################################################

%define _unpackaged_files_terminate_build 0

# build with -with optimization
%define build_optimization 0
%{?_with_optimization: %{expand: %%define build_optimization 1}}

# build with -with noalsa
%define build_noalsa 0
%{?_with_noalsa: %{expand: %%define build_noalsa 1}}

# build with -with alsa
%define build_alsa 0
%{?_with_alsa: %{expand: %%define build_alsa 1}}

# build with -with nopixmaps
%define build_nopixmaps 0
%{?_with_nopixmaps: %{expand: %%define build_nopixmaps 1}}

# build with -with debug
%define build_debug 0
%{?_with_debug: %{expand: %%define build_debug 1}}

# build with -with xinerama
%define build_xinerama 0
%{?_with_xinerama: %{expand: %%define build_xinerama 1}}

# build with -with noxaw3d
%define build_noxaw3d 0
%{?_with_noxaw3d: %{expand: %%define build_noxaw3d 1}}

# build with -with noxawm
%define build_noxawm 0
%{?_with_noxawm: %{expand: %%define build_noxawm 1}}

# build with -with nonextaw
%define build_nonextaw 0
%{?_with_nonextaw: %{expand: %%define build_nonextaw 1}}

# build with -with noxaw95
%define build_noxaw95 0
%{?_with_noxaw95: %{expand: %%define build_noxaw95 1}}

%define name 			xdtv
%define Name 			XdTV
%define version 		2.0.1
%define release 		1mdk
%define summary1		%{Name} is a software to watch TV.
%define summary2		Developpement files for %{Name}.
%define summary3		Font used by %{Name} OSD function.
%define  tvtuner_launcher	%{_sysconfdir}/dynamic/launchers/tvtuner

Name: 				%{name}
Summary: 			%{summary1}
Version: 			%{version}
Release: 			%{release}
Copyright: 			GPL
Distribution: 			Mandrake Linux
Packager: 			Pingus <pingus_77@yahoo.fr>
URL:				http://xawdecode.sourceforge.net/
Source0:			%{name}-%{version}.tar.gz
Group: 				Video

Requires:			libxorg-x11
Requires:			libdivx4linux0
Requires:			libffmpeg
Requires:			liblame0
Requires:			liblirc0
Requires:			libjpeg62
Requires:			libxvid4
Requires:			xterm
Requires:			libzvbi0
%if %build_alsa
Requires:			libalsa2
%endif

BuildRequires:			libxorg-x11-devel
BuildRequires:			autoconf2.5
BuildRequires:			libdivx4linux0-devel
BuildRequires:			libffmpeg-devel
BuildRequires:			liblame0-devel
BuildRequires:			lame
BuildRequires:			liblirc0-devel
BuildRequires:			libjpeg62-devel
BuildRequires:			libxvid4-devel
BuildRequires:			libzvbi0-devel
%if %build_alsa
BuildRequires:			libalsa2-devel
%endif

BuildRoot: 			%{_tmppath}/%{name}-%{version}-buildroot

%description
%{Name} is a software that allows you to watch TV.
It interacts with AleVT for Teletext and Nxtvepg for NextView,
and uses the video4linux API. It can use deinterlacing filters
and record video files with the ffmpeg, xvid, and divx codecs.

%package devel
Summary:			%{summary2}
Group:				Development/C
Requires:			%{name} = %{version}

%description devel
Developpement files for %{name} 

%package OSD-font
Summary:			%{summary3}
Group:				Video
Requires:			%{name} = %{version}

%description OSD-font
Font used by %{Name} OSD function.

%prep
rm -rf $RPM_BUILD_ROOT
%setup -a 0

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix} \
%if !%build_optimization
	--disable-cpu-detection \
%endif
%if %build_noalsa
	--disable-alsa \
%endif
%if %build_nopixmaps
	--disable-pixmaps \
%endif
%if %build_debug
	--disable-nodebug \
%endif
%if %build_xinerama
	--enable-xinerama \
%endif
%if %build_noxaw3d
	--disable-xaw3d \
%endif
%if %build_nonextaw
	--disable-nextaw \
%endif
%if %build_noxawm
	--disable-xawm \
%endif
%if %build_noxaw95
	--disable-xaw95 \
%endif

make

%install
make ROOT="$RPM_BUILD_ROOT" prefix="$RPM_BUILD_ROOT"%{_prefix} install
strip $RPM_BUILD_ROOT/%{_bindir}/%{name}
strip $RPM_BUILD_ROOT/%{_bindir}/%{name}_v4l-conf
strip $RPM_BUILD_ROOT/%{_bindir}/%{name}_wizard
strip $RPM_BUILD_ROOT/%{_bindir}/%{name}_cmd
strip $RPM_BUILD_ROOT/%{_bindir}/%{name}_scantv
strip $RPM_BUILD_ROOT/%{_bindir}/%{name}_alevt-cap

# Dynamic v4l support
mkdir -p $RPM_BUILD_ROOT%{tvtuner_launcher}
cat > $RPM_BUILD_ROOT%{tvtuner_launcher}/%{name}.desktop << EOF

[Desktop Entry]
Name=%{Name} \$basename
Comment=%{Name} is a software to watch TV.
TryExec=%{_bindir}/%{name}
Exec=%{_bindir}/%{name}
Terminal=false
Icon=%{name}.png
Type=Application
EOF

# Cure man path
install -d -m 755 %{buildroot}%{_mandir}/man1/
install -m 644 %{name}.1 %{buildroot}%{_mandir}/man1/
install -m 644 %{name}_cmd.1 %{buildroot}%{_mandir}/man1/
install -m 644 %{name}_alevt-cap.1 %{buildroot}%{_mandir}/man1/
install -m 644 %{name}_alevt.1 %{buildroot}%{_mandir}/man1/
bzip2 %{buildroot}%{_mandir}/man1/%{name}.1
bzip2 %{buildroot}%{_mandir}/man1/%{name}_cmd.1
bzip2 %{buildroot}%{_mandir}/man1/%{name}_alevt.1
bzip2 %{buildroot}%{_mandir}/man1/%{name}_alevt-cap.1

# menu
install -D -m 644 %{name}-16.png $RPM_BUILD_ROOT%{_miconsdir}/%{name}.png
install -D -m 644 %{name}-32.png $RPM_BUILD_ROOT%{_iconsdir}/%{name}.png
install -D -m 644 %{name}-48.png $RPM_BUILD_ROOT%{_liconsdir}/%{name}.png

install -d $RPM_BUILD_ROOT%{_menudir}
cat << EOF > $RPM_BUILD_ROOT%{_menudir}/%{name}
?package(%{name}): \
	command="%{_bindir}/%{name}" \
	icon="%{name}.png" \
	needs="x11" \
	section="Multimedia/Video" \
	title="%{Name}" \
	longtitle="%{summary1}"
EOF

install -d $RPM_BUILD_ROOT%{_menudir}
cat << EOF > $RPM_BUILD_ROOT%{_menudir}/%{name}_wizard
?package(%{name}): \
	command="%{_bindir}/%{name}_wizard" \
	icon="%{name}.png" \
	needs="x11" \
	section="Multimedia/Video" \
	title="%{Name} Wizard" \
	longtitle="%{summary1}"
EOF

%clean
rm -rf $RPM_BUILD_ROOT

%post
%{update_menus}
/sbin/modprobe -r bttv
%{_sbindir}/update-alternatives --install %{tvtuner_launcher}/kde.desktop tvtuner.kde.dynamic %{tvtuner_launcher}/%{name}.desktop 100
%{_sbindir}/update-alternatives --install %{tvtuner_launcher}/gnome.desktop tvtuner.gnome.dynamic %{tvtuner_launcher}/%{name}.desktop 100
/sbin/modprobe bttv

%post OSD-font
cd %{_prefix}/X11R6/lib/X11/fonts/misc
test -x %{_prefix}/X11R6/bin/mkfontdir && mkfontdir || true
if [ -f /var/lock/subsys/xfs ]; then
	service xfs restart || true
fi
test -n "$DISPLAY" && xset fp rehash || true

%postun
%{clean_menus}
if [ $1 = 0 ]; then
  /sbin/modprobe -r bttv
  %{_sbindir}/update-alternatives --remove tvtuner.kde.dynamic %{tvtuner_launcher}/%{name}.desktop
  %{_sbindir}/update-alternatives --remove tvtuner.gnome.dynamic %{tvtuner_launcher}/%{name}.desktop
  /sbin/modprobe bttv
fi

%postun OSD-font
if [ $1 = 0 ]; then
  cd %{_prefix}/X11R6/lib/X11/fonts/misc
  test -x %{_prefix}/X11R6/bin/mkfontdir && mkfontdir || true
	if [ -f /var/lock/subsys/xfs ]; then
		service xfs restart || true
	fi
  test -n "$DISPLAY" && xset fp rehash || true
fi

%files
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING lisez-moi README INSTALL TODO
%doc FAQfr-xdtv libavc-rate-control.txt xdtvrc.sample
%doc lircrc.hauppauge.sample lircrc.miro.sample lircrc.animax.sample lircrc.WinfastTV2000.sample
%doc  README.deinterlace README.ffmpeg README.avilib README.gentoo
%doc  README.bs README.record README.lirc README.http README.bsd
%config(noreplace) %{tvtuner_launcher}/%{name}.desktop
%{_sysconfdir}/X11/app-defaults/%{Name}
%{_sysconfdir}/%{name}_wizard.conf
%{_bindir}/%{name}
%{_bindir}/%{name}_cmd
%{_bindir}/%{name}_wizard
%{_bindir}/%{name}_scantv
%{_bindir}/%{name}_alevt-cap
%{_bindir}/%{name}_v4l-conf
%{_bindir}/%{name}_scan.sh
%{_bindir}/%{name}_record.sh
%{_bindir}/%{name}_http.sh
%{_bindir}/%{name}_makedvd.sh
%{_bindir}/%{name}_fullscreen.sh
%{_mandir}/man1/*
%{_menudir}/%{name}
%{_menudir}/%{name}_wizard
%{_iconsdir}/%{name}.png
%{_miconsdir}/%{name}.png
%{_liconsdir}/%{name}.png

%files devel
%defattr(-,root,root)
%{_includedir}/*

%files OSD-font
%defattr(-,root,root)
%{_prefix}/X11R6/lib/X11/fonts/misc/*.pcf

%changelog
* Sat Jun 19 2004 Sir Pingus <pingus_77@yahoo.fr> 1.9.2-1mdk
- 1.9.2

* Tue Apr 14 2004 Sir Pingus <pingus_77@yahoo.fr> 1.9.1-1mdk
- 1.9.1
- xvid 1.0 RC4 needed
- add a lot of files (README.bsd alevt files....)

* Sun Feb 08 2004 Pingus <pingus77@ifrance.com> 1.9.0-2mdk
- 1.9.0
- add README.http, xawdecode_http.sh files
- no package alsa-utils needed any more
- modif with alsa required
- package zvbi needed
- package lame needed
- package xvid renamed by plf: so we follow that: libxvid2 needed
- add -disable-nodebug option

* Fri Nov 28 2003 Pingus <pingus77@ifrance.com> 1.8.2-1mdk
- 1.8.2
- add lircrc.WinfastTV2000.sample file.
- alsa support always used. now noalsa is proposed to compile with no alsa support.

* Sat Oct 18 2003 Pingus <pingus77@ifrance.com> 1.8.1-3mdk
- fix a problem with xosd dependences

* Sat Oct 18 2003 Pingus <pingus77@ifrance.com> 1.8.1-2mdk
- 1.8.1 : new packages for xawdecode generated.
- fix a problem with ffmpeg dependances and other repositories

* Sat Oct 04 2003 Pingus <pingus77@ifrance.com> 1.8.1-1mdk
- 1.8.1

* Sun Sep 12 2003 Pingus <pingus77@ifrance.com> 1.8.0-1mdk
- 1.8.0
- build with alsa by default
- add toggle for xosd
- small update on BuildRequires and Requires

* Sun Jul 27 2003 Pingus <pingus77@ifrance.com> 1.7.5beta-1mdk
- "Summer Release" 1.7.5beta

* Mon Jul 7 2003 Pingus <pingus77@ifrance.com> 1.7.0-1mdk
- ver 1.7.0
- plenty of modifications for this spec file

* Fri May 2 2003 Pingus <pingus77@ifrance.com> 1.6.8-1mdk
- ver 1.6.8
- plenty of modifications for this spec file

* Fri Jan 25 2003 Pingus <pingus77@ifrance.com>
- ver 1.6.7
- OSD-font sample package
- enable-nextaw

* Tue Jan 02 2003 Pingus <pingus77@ifrance.com>
- ver 1.6.6a with v4l-conf sample package
- big big errors in menu and icons

* Fri Nov 18 2002 Pingus <pingus77@ifrance.com>
- ver 1.6.6a special sourceforge release

* Mon Nov 13 2002 Pingus <pingus77@ifrance.com>
- ver 1.6.6

* Tue Oct 26 2002 Pingus <pingus77@ifrance.com>
- add lirc support
- add menus entry
- made spec file more mdk compatible (define, mandir)

* Wed Oct 18 2002 Pingus <pingus77@ifrance.com>
- ver 1.6.5
- Adaptation for Mandrake 9.0 based on Laurent Culioli <laurent@pschit.net> spec file
- include last patches from keuleu
