/*****************************************************************************
 * xdtv_cmd.c: sends commands to xdtv
 *****************************************************************************
 * $Id: xdtv_cmd.c,v 1.1 2004/09/08 21:03:50 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2003 Alain
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 *
 *  (c) Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/


#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h> 
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

int main(int nargs, char **args) {
  struct sockaddr_un addr;
  int ret,sock;
  char sockname[80];
  if(nargs!=2) {fprintf(stderr,"syntaxe %s commande\n",args[0]);exit(1);}
  sock=socket(AF_UNIX,SOCK_STREAM,0);
  if(sock<0) {perror("socket");return 1;}
  addr.sun_family=AF_UNIX;
  sprintf (sockname, "%.60s/.xdtv/socket", getenv ("HOME"));
  strcpy(addr.sun_path,sockname);
  ret=connect(sock,(struct  sockaddr*)&addr,sizeof(addr));
  if(ret<0) {perror("connect");return 1;}
  ret=write(sock,args[1],strlen(args[1]));
  if(ret!=strlen(args[1])) {perror("write");return 1;}
  close(sock);
  return 0;
}
