/*****************************************************************************
 * divx.h: DivX recording functions and other definitions
 *****************************************************************************
 * $Id: divx.h,v 1.25 2004/12/05 18:27:59 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/
#ifndef _DIVX_H_
#define _DIVX_H_

#include "colorspace.h"
#ifdef HAVE_FFMPEG
# include <ffmpeg/avcodec.h>
#endif

void divx_init(int width, int height);
void divx_encode(unsigned char *src_frame);
void divx_stop(void);
int is_divx_in_progress(void);
int is_http_in_progress(void);
int divx_display_frames(void);
inline void write_audio_to_avi(short int *buffer, int size);
void write_sub(char *s);
void divx_audio_start(void);
void divx_audio_stop(void);
void divx_restart(void);
char lastfilename[256];
char *pplayer;

enum {
  RECORD_STOP = 0,
  RECORD_START,
  RECORD_PREVIEW,  
  RECORD_SCHEDULE,    
  RECORD_VIDEO_PARAM,
  RECORD_AUDIO_PARAM,
  STREAM_SERVER_PARAM
};

enum {
#ifdef HAVE_DIVX4LINUX
DIVX4LINUX,
#endif
#ifdef HAVE_FFMPEG
FFMPEG_MPEG4,
FFMPEG_MPEG1,
#if LIBAVCODEC_BUILD >= 4734
FFMPEG_FFVHUFF,
#endif
FFMPEG_HUFFYUV,
#endif
#ifdef HAVE_XVID
XVID,
#endif
UNCOMPRESSED
};

typedef struct {
  int codec;
  int width;
  int height;
  long bitrate;
  int quality;
  int min_quantizer;
  int max_quantizer;
  int audio_buffer_size;
  int audio_fragments;
  int audio_sizefragment;
  int stereo;
  int compress_audio;
  int mp3_bitrate;
  int mp3_quality;
  int mp3_vbr;
  int mp3_vbr_quality;
  int fps;
  double maxgap;
  double delay;
  int display_frames;
  int sub;
  int chg;
  char *filename;
  int stream;
  int http_port;
} divx_t;

#define WAVE_FORMAT_MPEGLAYER3 (0x0055)
extern struct STRTAB fourccs_raw[];

#endif // _DIVX_H_
