/*****************************************************************************
 * conf.c: channel editor
 *****************************************************************************
 * $Id: conf.c,v 1.27 2004/11/23 00:49:22 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <sys/wait.h>
#include <string.h>
#include <errno.h>
#include <math.h>
#include <sys/time.h>
#include <dlfcn.h>
#include <pthread.h>

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif


#include "channel.h"
#include "channels.h"
#include "grab.h"
#include "x11.h"
#include "xdtv.h"

#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS
#include "../pixmaps/editor_RC.xpm"
#include "../pixmaps/editor_scantv.xpm"
#include "../pixmaps/editor_openmain.xpm"
#include "../pixmaps/editor_add.xpm"
#include "../pixmaps/editor_delete.xpm"
#include "../pixmaps/editor_update.xpm"
#include "../pixmaps/editor_save.xpm"
#include "../pixmaps/editor_close.xpm"
#include "../pixmaps/editor_channelnum.xpm"
#include "../pixmaps/editor_choosehotkey.xpm"
#include "../pixmaps/editor_stationname.xpm"
#endif
#endif



void pixit (void);
void set_channel (struct CHANNEL *channel);
void channel_menu (void);

extern void OptionsAction (Widget, XEvent *, String *, Cardinal *);
extern void action_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern void set_timer_title (void);
extern Widget app_shell, conf_shell;
extern Display *dpy;
extern Atom wm_protocols[2];
extern int debug;
extern void ExitCB();
extern char title[256];

Widget conf_channel, conf_name, conf_key, conf_list;
Widget c_openmain;
Widget c_rc;
Widget c_scantv;
Widget c_add;
Widget c_delete;
Widget c_update;
Widget c_save;
Widget label_channelnum;
Widget label_choosehotkey;
Widget label_stationname;

static Widget last_command, viewport;
static String *channel_list;

#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif

/*-------------------------------------------------------------------------*/

struct CALL_ACTION call_options_1 = { 0, "Options", {NULL} };

/*--------------------------------------------------------------------------*/

void waitforchild(int i)
{
        waitpid(-1, NULL, WNOHANG);
        signal(SIGCHLD, waitforchild);
}

static void
launch_it (Widget w, XtPointer client_data, XtPointer call_data)
{
fputs(client_data,popen("/bin/sh","w"));
fflush(popen("/bin/sh","w"));
}

void execute_it (Widget w, XtPointer client_data, XtPointer call_data)
{
  char *cmd = (char *)client_data;
  pthread_t thread;
  pthread_create (&thread, NULL, (void *(*)(void *)) system, cmd);
}

void editor_station_switched ();

static void
list_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  if (channel_list[0] != "empty")
  {
  	XawListReturnStruct *lr = call_data;

  	pixit ();
 	cur_sender = lr->list_index;
 	set_channel (channels[cur_sender]);
 }
}

static void
add_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  struct CHANNEL *channel;
  char *name, *key;

  XtVaGetValues (conf_name, XtNstring, &name, NULL);
  XtVaGetValues (conf_key, XtNlabel, &key, NULL);

  if (0 == strlen (name)) return;

  channel = add_channel (name);
  if (strlen (key) > 0) channel->key = strdup (key);
  channel->cname = (cur_channel != -1) ? tvtuner[cur_channel].name : "???";
  channel->channel = cur_channel;
  channel->fine = cur_fine;
  configure_channel (channel);
  if (channel_list[0] == "empty") XawListUnhighlight (conf_list);
  channel_menu ();

  }

static void
del_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  if (cur_sender == -1) return;
  XtDestroyWidget(channels[cur_sender]->button);
  del_channel (cur_sender);

    channel_menu ();
    cur_sender = -1;
  editor_station_switched ();
}

static void
modify_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  char *name, *key;

  XtVaGetValues (conf_name, XtNstring, &name, NULL);
  XtVaGetValues (conf_key, XtNlabel, &key, NULL);

  if (0 == strlen (name))
    return;

  /* no channel yet ... */
  if (-1 == cur_sender) {
      add_cb (widget, clientdata, call_data);
      return;
    }

  free (channels[cur_sender]->name);
  channels[cur_sender]->name = strdup (name);

  if (channels[cur_sender]->key)
    free (channels[cur_sender]->key);
  if (0 != strlen (key))
    channels[cur_sender]->key = strdup (key);
  else
    channels[cur_sender]->key = 0;
  hotkey_channel (channels[cur_sender]);

  channel_menu ();
  editor_station_switched ();
}

/*static*/ void
save_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  save_config ();
  sprintf (title, "Configuration Saved");  
  set_timer_title ();
}

static void
close_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  XtCallActionProc (conf_shell, "Editor", NULL, NULL, 0);
}

static void
key_eh (Widget widget, XtPointer client_data, XEvent * event, Boolean * cont)
{
  XKeyEvent *ke = (XKeyEvent *) event;
  KeySym sym;
  char *key;
  char line[64];

  sym = XKeycodeToKeysym (dpy, ke->keycode, 0);
  if (NoSymbol == sym)
    {
      fprintf (stderr, "can't translate keycode %d\n", ke->keycode);
      return;
    }
  key = XKeysymToString (sym);

  line[0] = '\0';
  if (ke->state & ShiftMask)
    strcpy (line, "Shift+");
  if (ke->state & ControlMask)
    strcpy (line, "Ctrl+");
  strcat (line, key);
  XtVaSetValues (conf_key, XtNlabel, line, NULL);
}

/*-------------------------------------------------------------------------*/

#define FIX_RIGHT_TOP       \
    XtNleft,XawChainRight,  \
    XtNright,XawChainRight, \
    XtNtop,XawChainTop,     \
    XtNbottom,XawChainTop

void
create_editorwin ()
{
  Widget form, label, command;

  conf_shell = XtVaAppCreateShell ("Editor", "XdTV",
                                   topLevelShellWidgetClass,
                                   dpy, XtNclientLeader, app_shell,
				   XtNvisual,vinfo->visual,
				   XtNcolormap,colormap, XtNdepth,vinfo->depth,
				   NULL);

  form = XtVaCreateManagedWidget ("form", formWidgetClass, conf_shell, NULL);

  /* list */
  viewport =
    XtVaCreateManagedWidget ("viewport", viewportWidgetClass, form,
                             XtNleft, XawChainLeft,
                             XtNright, XawChainRight,
                             XtNtop, XawChainTop,
                             XtNbottom, XawChainBottom, NULL);
  conf_list =
    XtVaCreateManagedWidget ("list", listWidgetClass, viewport, NULL);
  XtAddCallback (conf_list, XtNcallback, list_cb, (XtPointer) NULL);

/* ------------------------------------------------------------------------- */
  label_channelnum = label =
    XtVaCreateManagedWidget ("lchannel", labelWidgetClass, form,
                             FIX_RIGHT_TOP, XtNfromHoriz, viewport, NULL);
  conf_channel =
    XtVaCreateManagedWidget ("channel", labelWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, label, NULL);
  label_choosehotkey = label =
    XtVaCreateManagedWidget ("lkey", labelWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, conf_channel, NULL);
  conf_key =
    XtVaCreateManagedWidget ("key", labelWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, label, NULL);
label_stationname = label =
    XtVaCreateManagedWidget ("lname", labelWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, conf_key, NULL);
  conf_name =
    XtVaCreateManagedWidget ("name", asciiTextWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, label, NULL);
  XtAddEventHandler (conf_key, KeyPressMask, False, key_eh, NULL);

  /* buttons */

  c_rc = command =
    XtVaCreateManagedWidget ("editrc", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, conf_name, NULL);
  signal(SIGCHLD, waitforchild);
  XtAddCallback (command, XtNcallback, execute_it, "xterm -geometry 80x35+0+0 -title xdtvrc -e vi $HOME/.xdtv/xdtvrc");
  c_scantv = command =
    XtVaCreateManagedWidget ("scantv", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, command, NULL);
  signal(SIGCHLD, waitforchild);
  XtAddCallback (command, XtNcallback, ExitCB, NULL);
  XtAddCallback (command, XtNcallback, launch_it, "xterm -geometry 80x35+0+0 -title ScanTV -e sh xdtv_scan.sh");
  c_openmain = command =
    XtVaCreateManagedWidget ("openmain", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, command, NULL);
    XtAddCallback (command, XtNcallback, action_cb, (XtPointer) & call_options_1);   
  c_add = command =
    XtVaCreateManagedWidget ("add", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, command, NULL);
  XtAddCallback (command, XtNcallback, add_cb, (XtPointer) NULL);
  c_delete = command =
    XtVaCreateManagedWidget ("delete", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, command, NULL);
  XtAddCallback (command, XtNcallback, del_cb, (XtPointer) NULL);
  c_update = command =
    XtVaCreateManagedWidget ("modify", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, command, NULL);
  XtAddCallback (command, XtNcallback, modify_cb, (XtPointer) NULL);
  c_save = command =
    XtVaCreateManagedWidget ("save", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, command, NULL);
  XtAddCallback (command, XtNcallback, save_cb, (XtPointer) NULL);
  last_command = command =
    XtVaCreateManagedWidget ("close", commandWidgetClass, form,
                             FIX_RIGHT_TOP,
                             XtNfromHoriz, viewport,
                             XtNfromVert, command, NULL);
  XtAddCallback (command, XtNcallback, close_cb, (XtPointer) NULL);

  XtInstallAllAccelerators (conf_name, conf_shell);
#ifdef HAVE_XPM
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(conf_shell, XtNiconPixmap, icon_pixmap, NULL);
#ifdef HAVE_PIXMAPS
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_RC_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_rc, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_scantv_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_scantv, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_openmain_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_openmain, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_add_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_add, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_delete_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_delete, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_update_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_update, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_save_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_save, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_close_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(last_command, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_channelnum_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(label_channelnum, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_choosehotkey_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(label_choosehotkey, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(conf_shell),
                          RootWindowOfScreen(XtScreen(conf_shell)),
                          editor_stationname_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(label_stationname, XtNbitmap, icon_pixmap, NULL);  
#endif
#endif
}

void
EditorAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;

  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Config: wm_save_yourself\n");
          XSetCommand (XtDisplay (conf_shell), XtWindow (conf_shell), NULL,
                       0);
          return;
        }
    }

  if (mapped)
    {
      XtPopdown (conf_shell);
      mapped = 0;
    }
  else
    {
      XtPopup (conf_shell, XtGrabNone);
      mapped = 1;
      if (first)
        {
          XSetWMProtocols (XtDisplay (conf_shell), XtWindow (conf_shell),
                           wm_protocols, 2);
          first = 0;
        }
    }
}
/*-------------------------------------------------------------------------*/

void
editor_station_switched ()
{
  char line[128] = "???";

  /* channel */
  if (cur_channel != -1) {
     strcpy (line, tvtuner[cur_channel].name);
     if (cur_fine != 0)
        sprintf (line + strlen (line), " (%+d)", cur_fine);
  }
  XtVaSetValues (conf_channel, XtNlabel, line, NULL);

  if (cur_sender == -1)
    {
      XtVaSetValues (conf_key, XtNlabel, "", NULL);
      XtVaSetValues (conf_name, XtNstring, "", NULL);
      XawListUnhighlight (conf_list);
    }
  else
    {
      if (channels[cur_sender]->key)
        XtVaSetValues (conf_key, XtNlabel, channels[cur_sender]->key, NULL);
      else
        XtVaSetValues (conf_key, XtNlabel, "", NULL);
      XtVaSetValues (conf_name, XtNstring, channels[cur_sender]->name, NULL);
      XawListHighlight (conf_list, cur_sender);
    }
}

void
editor_list_update ()
{
  int i;

  if (channel_list)
    free (channel_list);

  if (cur_sender != 0)
  XawListUnhighlight (conf_list);

  if (count)
    {
      /* rebuild list */
      channel_list = malloc ((count + 1) * sizeof (String));
      for (i = 0; i < count; i++)
        channel_list[i] = channels[i]->name;
      channel_list[i] = NULL;
    }
  else
    {
      /* empty list */
      channel_list = malloc (2 * sizeof (String));
      channel_list[0] = "empty";
      channel_list[1] = NULL;
    }
  XtVaSetValues (conf_list, XtNlist, channel_list, XtNnumberStrings, 0, NULL);
}

/*-------------------------------------------------------------------------*/
