/*****************************************************************************
 * $Id: audio.h,v 1.4 2004/09/19 14:15:39 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#ifndef _XDTV_AUDIO_H_
#define _XDTV_AUDIO_H_

#define AUDIO_U8   1
#define AUDIO_S16LE 2
#define AUDIO_RO 1
#define AUDIO_WO 2
#define AUDIO_RW 3

struct AUDRIVER
{
  char *name;
  int (*check) (void);
  int (*open) (int mode, int fmtsample, int nchannels, int freq, 
	       int nfrags, int fragsize);
  int (*close) (void);
  int (*read) (void *r, int n);
  int (*write) (void *w, int n);
};
extern struct AUDRIVER *audrivers[];

void audio_init(void);
int audio_open(int mode, int fmtsample, int nchannels, int freq, int nfrags,
	       int fragsize);
int audio_close(void);
int audio_read(void *r, int n);
int audio_write(void *w, int n);
void disable_audio(char *name);
extern char *audio_dev;

#endif
