#include "qtperf.h"
#include "runperf.h"
#include "perf.h"
#include <qlistbox.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qapplication.h>
#include <qpainter.h>
#ifdef QWS
# include <qtopia/qpeapplication.h>
#endif


QtPerf::QtPerf( QWidget* parent,  const char* name, WFlags f )
    : QVBox( parent, name, f )
{
    perf_message = "";
    perf_init();
    perf_running = FALSE;
    setCaption( "QtPerf" );
#ifndef QWS
    resize( 240, 280 );
#endif
    report = new QMultiLineEdit(this);
    report->setReadOnly(TRUE);
//    perf_widget->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));
    QHBox *hb = new QHBox(this);
    QPushButton *pb = new QPushButton(tr("Start"), hb);
    connect(pb, SIGNAL(clicked()), this, SLOT(start()));
    pb = new QPushButton(tr("Setup"), hb);
    connect(pb, SIGNAL(clicked()), this, SLOT(setup()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QtPerf::~QtPerf()
{
}


extern "C" void sleep(int);

void QtPerf::setup()
{
    RunPerfDlg d(this,0,TRUE);
    d.funcList->setSelectionMode( QListBox::Multi );
    int i, n = perf_count();
    for ( i=0; i<n; i++ ) {
	d.funcList->insertItem( perf_name(i) );
	d.funcList->setSelected( i, perf_run(i) );
    }
    d.numColors->setText( QString::number(perf_numcolors) );
    QRadioButton *b = 0;
    switch ( perf_clip ) {
	case ClipNone:
	    b = d.clipNone;
	    break;
	case ClipRect:
	    b = d.clipRect;
	    break;
	case ClipRects:
	    b = d.clipRects;
	    break;
	case RawFB:
	    b = d.rawFB;
	    break;
    }
    if ( b )
	b->setChecked( TRUE );
#ifdef QWS
    QPEApplication::execDialog(&d);
#else
    d.exec();
#endif
    for ( i=0; i<n; i++ )
	perf_set_run(i,d.funcList->isSelected(i));
    n = d.numColors->text().toInt();
    if ( n > 0 && n < PERF_MAXCOLORS )
	perf_numcolors = n;
    if ( d.clipNone->isChecked() )
	perf_clip = ClipNone;
    else if ( d.clipRect->isChecked() )
	perf_clip = ClipRect;
    else if ( d.clipRects->isChecked() )
	perf_clip = ClipRects;
    else if ( d.rawFB->isChecked() )
	perf_clip = RawFB;

}

void QtPerf::start()
{
    startTimer( 50 );		// run perf test in timer event
}

void QtPerf::timerEvent( QTimerEvent * )
{
    if ( perf_running )
	return;
    perf_running = TRUE;
    perf_widget = new QWidget(0, 0, WStyle_Customize|WStyle_NoBorder|WStyle_StaysOnTop|WRepaintNoErase);
    perf_widget->setGeometry(qApp->desktop()->geometry());
    perf_width  = perf_widget->width();
    perf_height = perf_widget->height();
    perf_widget->show();
    qApp->processEvents();
    killTimers();
    QPainter painter( perf_widget );
    perf_painter = &painter;
    perf_runall();
    perf_painter = 0;
    painter.end();
    delete perf_widget;
    report->setText(perf_message);
    perf_running = FALSE;
}
