#ifndef PERF_H
#define PERF_H


extern uint qrnd_val;

inline uint qrnd( uint maxVal )
{
    qrnd_val = qrnd_val*214013 + 2531011;
    return qrnd_val % maxVal;
}

extern QRect perf_rect;
extern QWidget  *perf_widget;
extern QPainter *perf_painter;
extern int  perf_width;
extern int  perf_height;

#define PERF_MAXCOLORS 4096

extern int  perf_numcolors;

enum PerfClipping { ClipNone, ClipRect, ClipRects, RawFB };
extern PerfClipping perf_clip;


extern QString perf_message;

 
/*
  Macros and internal stuff below.
*/

typedef int (*perf_func_t)();

struct PerfEntry {
    const char  *name;
    perf_func_t	 func;
    bool	 run;
};

/*
  These macros are used to build tables of testing functions.
*/
#define PERF_BEGIN	PerfEntry perf_array[] = {
#define PERF_ENTRY(f,n)	{n,perf_##f,FALSE},
#define PERF_END	{0,0,0}};

extern PerfEntry perf_array[];
void perf_init();
int  perf_count();

const char  *perf_name(int);
perf_func_t  perf_func(int);
bool	     perf_run(int);
void	     perf_set_run(int,bool);

void	     perf_runall();



#endif // PERF_H
