/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef DEMOWIDGET_H
#define DEMOWIDGET_H

#include "attributes.h"

#include <qwidget.h>
#include <qbasictimer.h>

class DemoWidget : public QWidget
{
    Q_OBJECT
public:
    DemoWidget(QWidget *w=0);

    virtual void startAnimation();
    virtual void stopAnimation();

    virtual void resetState() { update(); }

    void setAttributes(Attributes *attr) { attributes = attr; }

    void timerEvent(QTimerEvent *e);
    QSize sizeHint() const;

    void fillBackground(QPainter *p);

    double xfunc(double t);
    double yfunc(double t);

    inline Attributes *attribs() { return attributes; }

protected:
    int timeoutRate;
    int animationStep;
    Attributes *attributes;

    double a, b, c, d;

    void showEvent(QShowEvent *);
    void hideEvent(QHideEvent *);

private:
    QBasicTimer animationTimer;
};

#endif
