/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef OBJECTINSPECTOR_H
#define OBJECTINSPECTOR_H

#include "objectinspector_global.h"
#include <abstractobjectinspector.h>
#include <QPointer>

class AbstractFormEditor;
class AbstractFormWindow;
class ObjectItem;
class TreeWidget;

class QT_OBJECTINSPECTOR_EXPORT ObjectInspector: public AbstractObjectInspector
{
    Q_OBJECT
public:
    ObjectInspector(AbstractFormEditor *core, QWidget *parent = 0);
    virtual ~ObjectInspector();

    virtual AbstractFormEditor *core() const;

    void setFormWindow(AbstractFormWindow *formWindow);

private slots:
    void slotSelectionChanged();

private:
    static bool sortEntry(const QObject *a, const QObject *b);

private:
    AbstractFormEditor *m_core;
    TreeWidget *m_treeWidget;
    QPointer<AbstractFormWindow> m_formWindow;
    ObjectItem *m_root;
    bool m_ignoreUpdate;
};


#endif // OBJECTINSPECTOR_H
