/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the core module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QRESOURCE_H
#define QRESOURCE_H

#include <qlist.h>

class QMetaResource;
class QMetaResourcePrivate;
class QResourcePrivate;

void qInitResourceIO();

class Q_CORE_EXPORT QResource {
public:
    QString name() const;

    uint size() const;
    const uchar *data() const;

    bool isContainer() const;
    QList<QResource *> children() const;
    const QResource *parent() const;

    static QResource *find(const QString &resource);
    static void addSearchPath(const QString &path);

private:
    friend struct QResourceNode;
    friend class QMetaResource;
    friend class QMetaResourcePrivate;
    QResource();
    ~QResource();

    QResourcePrivate *d_ptr;
    Q_DECLARE_PRIVATE(QResource)

};

/* Don't use this */
class Q_CORE_EXPORT QMetaResource {
private:
    QMetaResourcePrivate *d_ptr;
    Q_DECLARE_PRIVATE(QMetaResource)

public:
    QMetaResource(const uchar *resource);
    ~QMetaResource();
};

#endif // QRESOURCE_H
