/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ATTRIBUTES_H
#define ATTRIBUTES_H

#include <qpixmap.h>
#include <qcolor.h>

class Attributes
{
public:
    enum BackgroundFill { Solid, Gradient, Tiles, Pixmap };

    Attributes()
        : antialias(false),
          alpha(false),
          fillMode(Solid)
    {
        color = Qt::white;
        secondaryColor = Qt::black;
        pattern.load(":/res/bg1.jpg");
        tile.load(":/res/qtlogo.png");
    }

    bool antialias;
    bool alpha;

    BackgroundFill fillMode;

    QPixmap pattern;
    QPixmap tile;
    QColor color;
    QColor secondaryColor;
};

#endif
