#include "qpkg.h"

#ifdef DESKTOP_VERSION
#include <qapplication.h>
#include <qtabwidget.h>
#define SN_API_NOT_YET_FROZEN 1
#include <libsn/sn.h>
#else
#include <qtopia/qpeapplication.h>
#endif

int main( int argc, char **argv )
{
#ifdef DESKTOP_VERSION
    QApplication a( argc, argv );
    static SnDisplay *sn_dpy;
    SnLauncheeContext *context;

    qpkg q;

    sn_dpy = sn_display_new (QPaintDevice::x11AppDisplay(), NULL, NULL);
    context = sn_launchee_context_new_from_environment (sn_dpy, DefaultScreen (QPaintDevice::x11AppDisplay()));

    if (context != NULL) {
	sn_launchee_context_complete (context);
    }

    a.setMainWidget( &q );
    if ( QApplication::desktop()->width() > 480 )
	q.show();
    else
	q.showMaximized();
#else
    QPEApplication a( argc, argv );

    qpkg q;

    a.showMainDocumentWidget( &q);
#endif
    
    return a.exec();
}
