/*
 * Copyright (c) 2005 Kimmo Kinnunen <kimmok@iki.fi>. All rights reserved.
 */

#ifndef HttpLibsoup_h
#define HttpLibsoup_h

#include "Http.h"

#include <unistd.h>
#include <glib.h>
#include <libsoup/soup.h>

class LibsoupFactory : public HttpFactory
{
public:
	LibsoupFactory();
	~LibsoupFactory();

	HttpRequest* createRequest(HttpRequestListener* listener,
							   OSB::URLCredentialStorage* credentials,
							   const gchar * url,
							   const gchar * cookies,
							   HttpRequest::Method type);

	HttpRequest* createSynchronizedRequest(HttpRequestListener* listener,
										   OSB::URLCredentialStorage* credentials,
										   const gchar * url,
										   const gchar * cookies,
										   HttpRequest::Method type);

	void setProxy(const gchar * proto, const gchar * proxyURL);

	bool canProvide(const gchar * url) const;

	SoupSession* getSession() { return m_session; }
	SoupSession* getSyncSession() { return m_syncSession; }

private:
	// no copy semantics
	LibsoupFactory(const LibsoupFactory&);
	LibsoupFactory& operator=(const LibsoupFactory&);

private:
	/** supported protocols*/
	static const gchar* const protocols[];

	/** */
	SoupSession* m_session;
	SoupSession* m_syncSession;
};

#endif
