/* 
   xkbd - xlib based onscreen keyboard.

   Copyright (C) 2001 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2004 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXKBD, NX protocol compression and NX extensions to this software      */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/extensions/XTest.h>
#include <X11/keysym.h>
#include <X11/extensions/shape.h>
#include "../config.h"

#include "libXkbd.h"

#define DEBUG 1

#define WIN_NORMAL  1
#define WIN_OVERIDE 2

#define WIN_OVERIDE_AWAYS_TOP 0
#define WIN_OVERIDE_NOT_AWAYS_TOP 1

/*

TODO:

- internalisation problems with ALT etc *fixed?*
- show slided keys ???
*/

Display* display; /* ack globals due to sighandlers - another way ? */	
Window win;

void handle_sig(int sig)
{
   XWindowAttributes attr;
   XGetWindowAttributes(display, win, &attr);
   if (attr.map_state == IsUnmapped ||
       attr.map_state == IsUnviewable )
   {
      XMapWindow(display, win);
      XRaiseWindow(display,win);
   } else {
      XUnmapWindow(display, win);
   }
}

void version()
{
   printf("Version: %s \n", VERSION);
#ifdef USE_XFT 
   printf("  -font <font name>  Select the xft AA font for xkbd\n");
#endif
#ifdef USE_XPM 
   printf("  -font <font name>  Select the xft AA font for xkbd\n");
#endif
#ifdef DEBUG
   printf("  -font <font name>  Select the xft AA font for xkbd\n");
#endif
   
}

void usage(void)
{
   printf("Usage: xkbd <options>\n");
   printf("Options:\n");
   printf("  -display  <display>\n");
   printf("  -geometry <geometry>\n");
#ifdef USE_XFT 
   printf("  -font <font name>  Select the xft AA font for xkbd\n");
#else
   printf("  -font <font name>  Select the X11 font for xkbd\n");
#endif
   printf("     ( NOTE: The above will overide the configs font )\n");
   printf("  -k  <keybaord file> Select the keyboard definition file\n");
   printf("                      other than the usual /etc/xkbdrc    \n");
   printf("  -xid used for gtk embedding   \n");
   printf("  -v  version\n");
   printf("  -h  this help\n\n");
   printf("  Check /etc/xkbdrc for defining your own custom keyboards\n\n");
}


int main(int argc, char **argv)
{
   int screen_num;	

   char *window_name = "xkbd";

   char *icon_name = "xkbd";

   XSizeHints size_hints;
   XWMHints *wm_hints;

   char *display_name = (char *)getenv("DISPLAY");  
   
   Xkbd *kb = NULL;

   char *geometry = NULL;
   int xret=0, yret=0, wret=0, hret=0;
   char *conf_file = DEFAULTCONFIG; 
   char *font_name = NULL;
   int cmd_xft_selected = 0; /* ugly ! */
   int embed = 0;
   int nxagent = 0;
extern int nxviewer;
   int nxdesktop = 0;
   
   XEvent an_event;

   int done = 0;
   
   int i;
   char userconffile[256];
   FILE *fp;
   KeySym mode_switch_ksym;

   XSetWindowAttributes attribs;


   for (i=1; argv[i]; i++) {
      char *arg = argv[i];
      if (*arg=='-') {
	 switch (arg[1]) {
	    case 'd' : /* display */
	       display_name = argv[i+1];
	       i++;
	       break;
	    case 'g' :
	       geometry = argv[i+1];
	       i++;
	       break; 
	    case 'f':
	       font_name = argv[i+1];
#ifdef USE_XFT 
	       cmd_xft_selected = 1;
#endif
	       break;
	    case 't' :
	       fprintf( stderr, "Overide redirect support deprciated\n");
	       exit(1);
	       break;
	    case 'k' :
	       conf_file = argv[i+1];
	       i++;
	       break;
	    case 'x' :
	       embed = 1;
	       break;
	    case 'v' :
	       version();
	       exit(0);
	       break;
	    case '1' :
	       nxagent = 1;
	       break;
	    case '2' :
	       nxviewer = 1;
	       break;
	    case '3' :
	       nxdesktop = 1;
	       break;
	    default:
	       usage();
	       exit(0);
	       break;
	 }
      }	
   }

   /* fprintf( stderr, "nxagent=%d, nxviewer=%d, nxdesktop=%d \n",nxagent, nxviewer, nxdesktop); */
   display = XOpenDisplay(display_name);
   screen_num = DefaultScreen(display);

   if (display != NULL) 
   {

      Atom wm_protocols[]={ 
	 XInternAtom(display, "WM_DELETE_WINDOW",False),
	 XInternAtom(display, "WM_PROTOCOLS",False),
	 XInternAtom(display, "WM_NORMAL_HINTS", False),
      };


      Atom window_type_atom =
	 XInternAtom(display, "_NET_WM_WINDOW_TYPE" , False);
      Atom window_type_toolbar_atom =
	 XInternAtom(display, "_NET_WM_WINDOW_TYPE_TOOLBAR",False);

	/* HACK to get libvirtkeys to work without mode_switch */

      if  (XKeysymToKeycode(display, XK_Mode_switch) == 0)
	{
	  int keycode; 	
	  int min_kc, max_kc;
	
	  XDisplayKeycodes(display, &min_kc, &max_kc);
	  
	  for (keycode = min_kc; keycode <= max_kc; keycode++)
	    if (XKeycodeToKeysym (display, keycode, 0) == NoSymbol)
	      {
		mode_switch_ksym = XStringToKeysym("Mode_switch");
		XChangeKeyboardMapping(display, 
				       keycode, 1,
				       &mode_switch_ksym, 1);
	      }
      }
      XSync(display, False);
       
      win = XCreateSimpleWindow(display,
				RootWindow(display, screen_num),
				0, 0,
				300, 300,
				0, BlackPixel(display, screen_num),
				WhitePixel(display, screen_num));
       
      if (geometry != NULL)
      {
	 XParseGeometry(geometry, &xret, &yret, &wret, &hret );
      }

      /* check for NX selected keyboard conf file */
      if (1)
      {	      
	strcpy(userconffile,conf_file);      
 	if (nxviewer) strcat(userconffile,".nx-vnc");
	else strcat(userconffile,".nx");
	conf_file = userconffile;
	/* fprintf( stderr, "----------string conf file:%s\n", conf_file);  */
      }

      if (conf_file == NULL)
	{
	  strcpy(userconffile,getenv("HOME"));
	  strcat(userconffile, "/.xkbd");
   
	  if ((fp = fopen(userconffile, "r")) != NULL)
	    {
	      conf_file = (char *)malloc(sizeof(char)*512);
	      if (fgets(conf_file, 512, fp) == NULL)
		{
		  fclose(fp);
		  if ( conf_file[strlen(conf_file)-1] == '\n')
		    conf_file[strlen(conf_file)-1] = '\0';
		}
	    }
	}


      kb = xkbd_realize(display, win, conf_file, font_name, 0, 0, 
			wret, hret, cmd_xft_selected);
    
      XResizeWindow(display, win, xkbd_get_width(kb), xkbd_get_height(kb));
    
      if (xret || yret)
	 XMoveWindow(display,win,xret,yret);
    
      size_hints.flags = PPosition | PSize | PMinSize;
      size_hints.x = 0;
      size_hints.y = 0;
      size_hints.width      =  xkbd_get_width(kb);
      size_hints.height     =  xkbd_get_height(kb);
      size_hints.min_width  =  xkbd_get_width(kb);
      size_hints.min_height =  xkbd_get_height(kb);
    
      XSetStandardProperties(display, win, window_name, 
			     icon_name, 0,
			     argv, argc, &size_hints);

      // xkbd without WM
      attribs.override_redirect = True;
      XChangeWindowAttributes (display, win, CWOverrideRedirect, &attribs);
    
      wm_hints = XAllocWMHints();
      wm_hints->input = False;
      wm_hints->flags = InputHint;
      XSetWMHints(display, win, wm_hints );
    
      XSetWMProtocols(display, win, wm_protocols, sizeof(wm_protocols) / 
		      sizeof(Atom));

      XChangeProperty(display, win, window_type_atom, XA_ATOM, 32, 
		      PropModeReplace, 
		      (unsigned char *) &window_type_toolbar_atom, 1);

      if (embed)
      {
	 fprintf(stdout, "%i\n", win);
	 fclose(stdout);
      } else {
         if ( nxviewer || nxdesktop )
           XUnmapWindow(display, win);
	 else
	   XMapWindow(display, win); 
      }
    
      if (nxviewer)  signal(SIGUSR1, handle_sig); /* for extenal mapping / unmapping */
      if (nxdesktop) signal(SIGHUP, handle_sig); /* for extenal mapping / unmapping */
    
      XSelectInput(display, win, 
		   ExposureMask |
		   ButtonPressMask |
		   ButtonReleaseMask |
		   Button1MotionMask |
		   StructureNotifyMask |
		   VisibilityChangeMask);
       
      XClearArea(display, win, 0, 0, 0, 0, TRUE);

      while (!done)
      {
	 while ( XPending(display) ) 
	 {

	    XNextEvent(display, &an_event);
	    xkbd_process(kb, &an_event);
	    switch (an_event.type) {
	       case ClientMessage:
		  if ((an_event.xclient.message_type == wm_protocols[1])
		      && (an_event.xclient.data.l[0] == wm_protocols[0])) 
		     done = 1;
		  break;
	       case ConfigureNotify:
		  if ( an_event.xconfigure.width != xkbd_get_width(kb)
		       || an_event.xconfigure.height != xkbd_get_height(kb))
		  {
		     xkbd_resize(kb,
				 an_event.xconfigure.width,
				 an_event.xconfigure.height );
		  }
		  break;
	       case Expose:
		  xkbd_repaint(kb);
		  break;
	    }
	 }
	 xkbd_process_repeats(kb);
	 usleep(10000L); /* sleep for a 10th of a second */
      }
      xkbd_destroy(kb);
      XCloseDisplay(display);
       
   } else {
      fprintf(stderr, "%s: cannot connect to X server '%s'\n",
	      argv[0], display_name);
      exit(1);
   }
   exit(0);
   

}













