/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "NXpicturestr.h"
#include "NXglyphstr.h"
#include "Render.h"

#include "X.h"
#include "Xproto.h"

#include "render.h"
#include "renderproto.h"

#include "mi.h"
#include "fb.h"
#include "mipict.h"
#include "fbpict.h"
#include "Agent.h"
#include "Drawable.h"

#include "../../../../lib/Xrender/Xrenderint.h"
#include "region.h"
#include "Display.h"

#include "Pixmap.h"

#define MAX_FORMATS 255

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

int nxagentAlphaEnabled = 0;
int nxagentPicturePrivateIndex = 0;

static int picturePrivateCount = 0;
static int nxagentNumFormats = 0;
static XRenderPictFormat nxagentArrayFormats[MAX_FORMATS];

#ifdef NXAGENT_RECONNECT
Bool nxagentReCreatePictures(void*);
Bool nxagentDisconnectPictures(void);
#endif

void nxagentCreateGlyphSet(GlyphSetPtr pGly);
void nxagentQueryFormats(void);
void nxagentAddGlyphs(GlyphSetPtr glyphsSet, Glyph *gids, xGlyphInfo *gi, int nglyphs, CARD8 *images, int sizeImages);
static XRenderPictFormat *nxagentMatchingFormats(PictFormatPtr pForm);

#ifdef NX_RENDER_DEBUG
static void nxagentPrintFormat(XRenderPictFormat *pFormat);
#endif

int nxagentCreatePicture(PicturePtr pPicture, Mask mask)
{
  XRenderPictureAttributes attributes;
  unsigned long            valuemask=0;
  Picture                  pictureRet;
  XRenderPictFormat        *pForm;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentCreatePicture\n");
#endif

  if (!pPicture)
  {
    return 0;
  }

/*
  if (nxagentAlphaEnabled &&
      pPicture -> pDrawable->depth == 32 &&
      pPicture -> pFormat -> direct.alpha != 0)
  {
     if (pPicture -> pDrawable -> type == DRAWABLE_PIXMAP)
     {
       nxagentPixmapPriv((PixmapPtr) pPicture -> pDrawable) -> pPicture = pPicture;
     }
     else if (pPicture -> pDrawable -> type == DRAWABLE_WINDOW)
     {
       nxagentWindowPriv((WindowPtr) pPicture -> pDrawable) -> pPicture = pPicture;
     }
  }
*/

#ifdef NX_RENDER_DEBUG
  if (pPicture -> pDrawable -> type == DRAWABLE_PIXMAP)
  {
     fprintf (stderr, "nxagentCreatePicture:PIXMAP\n");
  }
  else
  {
     fprintf (stderr, "nxagentCreatePicture:WINDOW\n");
  }
#endif

  if (mask & CPRepeat)
  {
    attributes.repeat = (Bool)pPicture -> repeat;
    valuemask |= CPRepeat;
  }
  if (mask & CPAlphaMap)
  {
    attributes.alpha_map = nxagentPicturePriv(pPicture -> alphaMap) -> picture;
    valuemask |= CPAlphaMap;
  }
  if (mask & CPAlphaXOrigin)
  {
    attributes.alpha_x_origin = pPicture -> alphaOrigin.x;
    valuemask |= CPAlphaXOrigin;
  }
  if (mask & CPAlphaYOrigin)
  {
    attributes.alpha_y_origin = pPicture -> alphaOrigin.y;
    valuemask |= CPAlphaYOrigin;
  }
  if (mask & CPClipXOrigin)
  {
    attributes.clip_x_origin = pPicture -> clipOrigin.x;
    valuemask |= CPClipXOrigin;
  }
  if (mask & CPClipYOrigin)
  {
    attributes.clip_y_origin = pPicture -> clipOrigin.y;
    valuemask |= CPClipYOrigin;
  }
  if (mask & CPGraphicsExposure)
  {
    attributes.graphics_exposures = (Bool)pPicture -> graphicsExposures;
    valuemask |= CPGraphicsExposure;
  }
  if (mask & CPSubwindowMode)
  {
    attributes.subwindow_mode = pPicture -> subWindowMode;
    valuemask |= CPSubwindowMode;
  }
  if (mask & CPClipMask)
  {
    attributes.clip_mask = None;
    valuemask |= CPClipMask;
  }
  if (mask & CPPolyEdge)
  {
    attributes.poly_edge = pPicture -> polyEdge;
    valuemask |=CPPolyEdge;
  }
  if (mask & CPPolyMode)
  {
    attributes.poly_mode = pPicture -> polyMode;
    valuemask |= CPPolyMode;
  }
  if (mask & CPDither)
  {
    attributes.dither = pPicture -> dither;
    valuemask |= CPDither;
  }
  if (mask & CPComponentAlpha)
  {
    attributes.component_alpha = pPicture -> componentAlpha;
    valuemask |= CPComponentAlpha;
  }

  pForm = NULL;

  if (pPicture -> pFormat)
  {
    pForm = nxagentMatchingFormats(pPicture -> pFormat);

#ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
#endif
  }

  if (!pForm)
  {
    return 0;
  }

  pictureRet = XRenderCreatePicture(nxagentDisplay,
                                    nxagentDrawable(pPicture -> pDrawable),
                                    pForm,
                                    valuemask,
                                    &attributes);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif

  nxagentPicturePriv(pPicture) -> picture = pictureRet;

  if (nxagentAlphaEnabled &&
      pPicture -> pDrawable->depth == 32 &&
      pPicture -> pFormat -> direct.alpha != 0)
  {
     if (pPicture -> pDrawable -> type == DRAWABLE_PIXMAP)
     {
       nxagentPixmapPriv(nxagentRealPixmap((PixmapPtr) pPicture -> pDrawable)) -> pPicture = pPicture;
     }
     else if (pPicture -> pDrawable -> type == DRAWABLE_WINDOW)
     {
       nxagentWindowPriv((WindowPtr) pPicture -> pDrawable) -> pPicture = pPicture;
     }
  }

  return Success;
}

XRenderPictFormat *nxagentMatchingFormats(PictFormatPtr pFormat)
{
  int nf;

  for (nf = 0; nf < nxagentNumFormats; nf++)
  {
    if (pFormat -> type == nxagentArrayFormats[nf].type &&
        pFormat -> depth == nxagentArrayFormats[nf].depth &&
        pFormat -> direct.red == nxagentArrayFormats[nf].direct.red &&
        pFormat -> direct.green == nxagentArrayFormats[nf].direct.green &&
        pFormat -> direct.blue == nxagentArrayFormats[nf].direct.blue &&
        pFormat -> direct.redMask == nxagentArrayFormats[nf].direct.redMask &&
        pFormat -> direct.greenMask == nxagentArrayFormats[nf].direct.greenMask &&
        pFormat -> direct.blueMask == nxagentArrayFormats[nf].direct.blueMask &&
        pFormat -> direct.alpha == nxagentArrayFormats[nf].direct.alpha &&
        pFormat -> direct.alphaMask == nxagentArrayFormats[nf].direct.alphaMask)
    {
      return &nxagentArrayFormats[nf];
    }
  }

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentMatchingFormats: The format is not found\n");
#endif
  return NULL;
}

void nxagentDestroyPicture(PicturePtr pPicture)
{
#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentDestroyPicture\n");
#endif

  if (!pPicture)
  {
    return;
  }

  XRenderFreePicture(nxagentDisplay,
                     nxagentPicturePriv(pPicture) -> picture);
  
#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

int nxagentChangePictureClip(PicturePtr pPicture,
                             int        clipType,
                             int        nRects,
                             xRectangle *rects,
                             int        xOrigin,
                             int        yOrigin)
{
#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentChangePictureClip\n");
#endif

  if (!pPicture)
  {
    return 0;
  }

  switch (clipType)
  {
    case CT_PIXMAP:
    {
#ifdef NX_RENDER_DEBUG
      fprintf(stderr, "nxagentChangePictureClip: CT_PIXMAP:\n");
#endif      
  
      if(!nRects)
      {
        return 0;
      }

      XRenderSetPictureClipRectangles(nxagentDisplay,
                                      nxagentPicturePriv(pPicture) -> picture,
                                      xOrigin,
                                      yOrigin,
                                      (XRectangle*)rects,
                                      nRects);
#ifdef NX_RENDER_DEBUG
      XSync(nxagentDisplay, False);
#endif
      break;
    }   
    case CT_NONE:
    {
#ifdef NX_RENDER_DEBUG
      fprintf(stderr, "nxagentChangePictureClip: CT_NONE:\n");
#endif
      
      if (!nRects)
      {
        return 0;
      }

      XRenderSetPictureClipRectangles(nxagentDisplay,
                                      nxagentPicturePriv(pPicture) -> picture,
                                      xOrigin,
                                      yOrigin,
                                      (XRectangle*)rects,
                                      nRects);

#ifdef NX_RENDER_DEBUG
      XSync(nxagentDisplay, False);
#endif
      break;
    }
    case CT_REGION:
    {
      Region     reg;
      XRectangle rectangle;
      int        index;

#ifdef NX_RENDER_DEBUG
      fprintf(stderr, "nxagentChangePictureClip: CT_REGION:\n");
#endif
    
      reg = XCreateRegion();
      for (index = 0; index <= nRects; index++, rects++)
      {
        rectangle.x = rects -> x;
        rectangle.y = rects -> y;
        rectangle.width = rects -> width;
        rectangle.height = rects -> height;

        XUnionRectWithRegion(&rectangle, reg, reg);
      }

      XRenderSetPictureClipRegion(nxagentDisplay,
                                  nxagentPicturePriv(pPicture) -> picture,
                                  reg);
#ifdef NX_RENDER_DEBUG
      XSync(nxagentDisplay, False);
#endif
  
      XDestroyRegion(reg);
      break;
    }
    default:
    {
#ifdef NX_RENDER_DEBUG
      fprintf(stderr, "nxagentChangePictureClip: clipType not found\n");
#endif
      break;
    }
  }
  return Success;
}

void nxagentDestroyPictureClip(PicturePtr pPicture)
{
#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentDestroyPictureClip\n");
#endif
}

void nxagentChangePicture(PicturePtr pPicture, Mask mask)
{
  XRenderPictureAttributes  attributes;
  unsigned long             valuemask = 0;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentChangePicture\n");
#endif

  if (!pPicture)
  {
    return;
  }

  if (mask & CPRepeat)
  {
    attributes.repeat = (Bool)pPicture -> repeat;
    valuemask |= CPRepeat;
  }
  if (mask & CPAlphaMap)
  {
    attributes.alpha_map = nxagentPicturePriv(pPicture -> alphaMap) -> picture;
    valuemask |= CPAlphaMap;
  }
  if (mask & CPAlphaXOrigin)
  {
    attributes.alpha_x_origin = pPicture -> alphaOrigin.x;
    valuemask |= CPAlphaXOrigin;
  }
  if (mask & CPAlphaYOrigin)
  {
    attributes.alpha_y_origin = pPicture -> alphaOrigin.y;
    valuemask |= CPAlphaYOrigin;
  }
  if (mask & CPClipXOrigin)
  {
    attributes.clip_x_origin = pPicture -> clipOrigin.x;
    valuemask |= CPClipXOrigin;
  }
  if (mask & CPClipYOrigin)
  {
    attributes.clip_y_origin = pPicture -> clipOrigin.y;
    valuemask |= CPClipYOrigin;
  }
  if (mask & CPGraphicsExposure)
  {
    attributes.graphics_exposures = (Bool)pPicture -> graphicsExposures;
    valuemask |= CPGraphicsExposure;
  }
  if (mask & CPSubwindowMode)
  {
    attributes.subwindow_mode = pPicture -> subWindowMode;
    valuemask |= CPSubwindowMode;
  }
  if (mask & CPClipMask)
  {
    attributes.clip_mask = None;
    valuemask |= CPClipMask;
  }
  if (mask & CPPolyEdge)
  {
    attributes.poly_edge = pPicture -> polyEdge;
    valuemask |=CPPolyEdge;
  }
  if (mask & CPPolyMode)
  {
    attributes.poly_mode = pPicture -> polyMode;
    valuemask |= CPPolyMode;
  }
  if (mask & CPDither)
  {
    attributes.dither = pPicture -> dither;
    valuemask |= CPDither;
  }
  if (mask & CPComponentAlpha)
  {
    attributes.component_alpha = pPicture -> componentAlpha;
    valuemask |= CPComponentAlpha;
  }

  XRenderChangePicture(nxagentDisplay,
                       nxagentPicturePriv(pPicture) -> picture,
                       valuemask,
                       &attributes);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentValidatePicture(PicturePtr pPicture, Mask mask)
{
#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentValidatePicture\n");
#endif

  if (!pPicture)
  {
    return;
  }
}

void nxagentComposite(CARD8      op,
                      PicturePtr pSrc,
                      PicturePtr pMask,
                      PicturePtr pDst,
                      INT16      xSrc,
                      INT16      ySrc,
                      INT16      xMask,
                      INT16      yMask,
                      INT16      xDst,
                      INT16      yDst,
                      CARD16     width,
                      CARD16     height)
{
#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentComposite\n");
#endif

  if (!(pSrc && pDst))
  {
    return;
  }

  XRenderComposite(nxagentDisplay,
                   op,
                   nxagentPicturePriv(pSrc) -> picture,
                   pMask ? nxagentPicturePriv(pMask) -> picture : 0,
                   nxagentPicturePriv(pDst) -> picture,
                   xSrc,
                   ySrc,
                   xMask,
                   yMask,
                   xDst,
                   yDst,
                   width,
                   height);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentGlyphs(CARD8          op,
                   PicturePtr     pSrc,
                   PicturePtr     pDst,
                   PictFormatPtr  maskFormat,
                   INT16          xSrc,
                   INT16          ySrc,
                   int            nlists,
                   XGlyphElt8     *elts,
                   int            sizeID)
{
  XRenderPictFormat *pForm;

  #ifdef TEST
  fprintf(stderr, "nxagentGlyphs: Called with source [%p] destination [%p] and size id [%d].\n",
              (void *) pSrc, (void *) pDst, sizeID);
  #endif

  if (!pSrc || !pDst)
  {
    #ifdef WARNING
    fprintf(stderr, "nxagentGlyphs: WARNING! Invalid source [%p] or destination [%p].\n",
                (void *) pSrc, (void *) pDst);
    #endif

    return;
  }

  pForm = NULL;

  if (maskFormat)
  {
    pForm = nxagentMatchingFormats(maskFormat);
    
    #ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
    #endif
  }

  switch (sizeID)
  {
    case 1:
    {
      XRenderCompositeText8(nxagentDisplay,
                              op,
                              nxagentPicturePriv(pSrc)->picture,
                              nxagentPicturePriv(pDst)->picture,
                              pForm,
                              xSrc,
                              ySrc,
                              elts -> xOff,
                              elts -> yOff,
                              (XGlyphElt8*)elts,
                              nlists);

      break;
    }
    case 2:
    {
      XRenderCompositeText16(nxagentDisplay,
                               op,
                               nxagentPicturePriv(pSrc) -> picture,
                               nxagentPicturePriv(pDst) -> picture,
                               pForm,
                               xSrc,
                               ySrc,
                               elts -> xOff,
                               elts -> yOff,
                               (XGlyphElt16*)elts,
                               nlists);

      break;
    }
    case 4:
    {
      XRenderCompositeText32(nxagentDisplay,
                               op,
                               nxagentPicturePriv(pSrc) -> picture,
                               nxagentPicturePriv(pDst) -> picture,
                               pForm,
                               xSrc,
                               ySrc,
                               elts -> xOff,
                               elts -> yOff,
                               (XGlyphElt32*)elts,
                               nlists);

      break;
    }
    default:
    {
      #ifdef WARNING
      fprintf(stderr, "nxagentGlyphs: WARNING! Invalid size id [%d].\n",
                  sizeID);
      #endif

      break;
    }
  }
}

void nxagentCompositeRects(CARD8           op,
                           PicturePtr      pDst,
                           xRenderColor    *color,
                           int             nRect,
                           xRectangle      *rects)
{
#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentCompositeRects\n");
#endif

  if (!pDst)
  {
    return;
  }

  XRenderFillRectangles(nxagentDisplay,
                        op,
                        (Picture)nxagentPicturePriv(pDst) -> picture,
                        (XRenderColor*)color,
                        (XRectangle*)rects,
                        nRect);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentTrapezoids(CARD8         op,
                       PicturePtr    pSrc,
                       PicturePtr    pDst,
                       PictFormatPtr maskFormat,
                       INT16         xSrc,
                       INT16         ySrc,
                       int           ntrap,
                       xTrapezoid    *traps)
{
  XRenderPictFormat *pForm;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentTrapezoids\n");
#endif

  if (!(pSrc && pDst))
  {
    return;
  }

  pForm = NULL;
  if (maskFormat)
  {
    pForm = nxagentMatchingFormats(maskFormat);
    
#ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
#endif
  }

  XRenderCompositeTrapezoids(nxagentDisplay,
                             op,
                             nxagentPicturePriv(pSrc) -> picture,
                             nxagentPicturePriv(pDst) -> picture,
                             pForm,
                             xSrc,
                             ySrc,
                             (XTrapezoid*)traps,
                             ntrap);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentRasterizeTrapezoid(PicturePtr    pMask,
                               xTrapezoid    *trap,
                               int           x_off,
                               int           y_off)
{
#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentRasterizeTrapezoids\n");
#endif
}

void nxagentTriangles(CARD8         op,
                      PicturePtr    pSrc,
                      PicturePtr    pDst,
                      PictFormatPtr maskFormat,
                      INT16         xSrc,
                      INT16         ySrc,
                      int           ntri,
                      xTriangle     *tris)
{
  XRenderPictFormat *pForm;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentTriangles\n");
#endif

  if (!(pSrc && pDst))
  {
    return;
  }

  pForm = NULL;
  if (maskFormat)
  {
    pForm = nxagentMatchingFormats (maskFormat);
    
#ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
#endif
  }

  XRenderCompositeTriangles(nxagentDisplay,
                            op,
                            nxagentPicturePriv(pSrc) -> picture,
                            nxagentPicturePriv(pDst) -> picture,
                            pForm,
                            xSrc,
                            ySrc,
                            (XTriangle*)tris,
                            ntri);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentTriStrip(CARD8          op,
                     PicturePtr     pSrc,
                     PicturePtr     pDst,
                     PictFormatPtr  maskFormat,
                     INT16          xSrc,
                     INT16          ySrc,
                     int            npoint,
                     xPointFixed    *points)
{
  XRenderPictFormat *pForm;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentTriStrip\n");
#endif

  if (!(pSrc && pDst))
  {
    return;
  }

  pForm = NULL;
  if (maskFormat)
  {
    pForm = nxagentMatchingFormats(maskFormat);
    
#ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
#endif
  }

  XRenderCompositeTriStrip(nxagentDisplay,
                           op,
                           nxagentPicturePriv(pSrc) -> picture,
                           nxagentPicturePriv(pDst) -> picture,
                           pForm,
                           xSrc,
                           ySrc,
                           (XPointFixed*)points,
                           npoint);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentTriFan(CARD8           op,
                   PicturePtr      pSrc,
                   PicturePtr      pDst,
                   PictFormatPtr   maskFormat,
                   INT16           xSrc,
                   INT16           ySrc,
                   int             npoint,
                   xPointFixed    *points)
{
  XRenderPictFormat *pForm;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentTriFan\n");
#endif

  if (!(pSrc && pDst))
  {
    return;
  }

  pForm = NULL;
  if (maskFormat)
  {
    pForm = nxagentMatchingFormats(maskFormat);
    
#ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
#endif
  }

  XRenderCompositeTriFan(nxagentDisplay,
                         op,
                         nxagentPicturePriv(pSrc) -> picture,
                         nxagentPicturePriv(pDst) -> picture,
                         pForm,
                         xSrc,
                         ySrc,
                         (XPointFixed*)points,
                         npoint);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

int AllocatePicturePrivateIndex()
{
  return picturePrivateCount++;
}

Bool AllocatePicturePrivate(register ScreenPtr pScreen, int index2, unsigned amount)
{
  unsigned oldamount;
  PictureScreenPtr ps = GetPictureScreen (pScreen);

  /* Round up sizes for proper alignment */
  amount = ((amount + (sizeof(long) - 1)) / sizeof(long)) * sizeof(long);

  if (index2 >= ps -> PicturePrivateLen)
  {
    unsigned *nsizes;
    nsizes = (unsigned *)xrealloc(ps -> PicturePrivateSizes,
                                    (index2 + 1) * sizeof(unsigned));
    if (!nsizes)
    {
      return FALSE;
    }
    while (ps -> PicturePrivateLen <= index2)
    {
      nsizes[ps -> PicturePrivateLen++] = 0;
      ps -> totalPictureSize += sizeof(DevUnion);
    }
    ps -> PicturePrivateSizes = nsizes;
  }
  oldamount = ps -> PicturePrivateSizes[index2];
  if (amount > oldamount)
  {
    ps -> PicturePrivateSizes[index2] = amount;
    ps -> totalPictureSize += (amount - oldamount);
  }
  return TRUE;
}

void nxagentQueryFormats(void)
{
  XRenderInfo  *xri;
  XExtDisplayInfo  *info = NULL;
  XRenderPictFormat *pformat=NULL;
  int nf;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentQueryFormats\n");
#endif

  if (XRenderQueryFormats(nxagentDisplay))
  {
#ifdef NX_RENDER_DEBUG
    XSync(nxagentDisplay, False);
#endif
    info = XRenderFindDisplay(nxagentDisplay);
#ifdef NX_RENDER_DEBUG
    XSync(nxagentDisplay, False);
#endif
    xri = (XRenderInfo*) info -> data;
    pformat = xri -> format;

    for (nf = 0; nf < xri -> nformat; nf++)
    {
          nxagentArrayFormats[nf] = *pformat;
          pformat++;
    }
    nxagentNumFormats = nf;
  }
}

void nxagentCreateGlyphSet(GlyphSetPtr pGly)
{
  XRenderPictFormat *pForm;

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentCreateGlyphSet\n");
#endif

  pForm = NULL;
  if (pGly -> format)
  {
    pForm = nxagentMatchingFormats(pGly -> format);

#ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
#endif
  }

  pGly -> remoteID = XRenderCreateGlyphSet(nxagentDisplay,
                                           pForm);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentAddGlyphs(GlyphSetPtr glyphSet, Glyph *gids, xGlyphInfo *gi, int nglyphs, CARD8 *images, int sizeImages)
{
  extern const CARD8 glyphDepths[];
  extern int ServerOrder(void);
  extern void BitOrderInvert(unsigned char*, int);

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentAddGlyphs\n");
#endif

  if (glyphDepths[glyphSet -> fdepth] == 1 &&
          ServerOrder() != BitmapBitOrder(nxagentDisplay))
  {
    BitOrderInvert ((unsigned char *) images, sizeImages);
  }

  XRenderAddGlyphs(nxagentDisplay,
                   glyphSet -> remoteID,
                   gids,
                   (XGlyphInfo*)(gi),
                   nglyphs,
                   (char*)images,
                   sizeImages);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif
}

void nxagentReferenceGlyphSet(GlyphSetPtr glyphSet)
{
  XRenderReferenceGlyphSet (nxagentDisplay, glyphSet -> remoteID);
}

void nxagentFreeGlyphs(GlyphSetPtr glyphSet, CARD32 *gids, int nglyph)
{
/*  Glyph nx_gids[nglyph];
*/
  XRenderFreeGlyphs (nxagentDisplay, glyphSet -> remoteID, gids, nglyph);

}

void nxagentFreeGlyphSet(GlyphSetPtr glyphSet)
{
  XRenderFreeGlyphSet (nxagentDisplay, glyphSet -> remoteID);
}

void nxagentSetPictureTransform(PicturePtr pPicture, pointer transform)
{
  XRenderSetPictureTransform (nxagentDisplay,
                              nxagentPicturePriv(pPicture) -> picture,
                              (XTransform *) transform);
}

void nxagentSetPictureFilter(PicturePtr pPicture, char *filter, int name_size, pointer params, int nparams)
{
  char *szFilter = Xmalloc(name_size + 1);
  if (szFilter == NULL)
  {
    fprintf(stderr, "nxagentSetPictureFilter: error allocating memory for filter name.\n");
    return;
  }
  strncpy(szFilter, filter, name_size);
  szFilter[name_size] = 0;

  fprintf(stderr, "nxagentSetPictureFilter: going to set filter [%s].\n", szFilter);

  XRenderSetPictureFilter  (nxagentDisplay,
                            nxagentPicturePriv(pPicture) -> picture,
                            szFilter,
                            (XFixed *) params,
                            nparams);

  Xfree(szFilter);
}


Bool nxagentPictureInit(ScreenPtr pScreen, PictFormatPtr formats, int nformats)
{
#ifdef RENDER

#ifdef NX_RENDER_DEBUG
  fprintf(stderr, "nxagentPictureInit\n");
#endif

  if (!fbPictureInit(pScreen, formats, nformats))
  {
    return FALSE;
  }

  nxagentPicturePrivateIndex = AllocatePicturePrivateIndex();

  AllocatePicturePrivate(pScreen, nxagentPicturePrivateIndex, sizeof(nxagentPrivPictureRec));

  nxagentQueryFormats();

#endif

  return TRUE;
}

#ifdef NX_RENDER_DEBUG
static void nxagentPrintFormat(XRenderPictFormat *pFormat)
{
  if (pFormat == NULL)
  {
    fprintf(stderr, "nxagentPrintFormat: NULL\n");
    return;
  }

  fprintf(stderr, "nxagentPrintFormat: REMOTE SIDE \n\
                   type=%d\n\
                   depth=%d\n\
                   red=%d\n\
                   redMask=%d\n\
                   green=%d\n\
                   greenMask=%d\n\
                   blue=%d\n\
                   blueMask=%d\n\
                   alpha=%d\n\
                   alphaMask=%d\n",
                   pFormat -> type,
                   pFormat -> depth,
                   pFormat -> direct.red,
                   pFormat -> direct.redMask,
                   pFormat -> direct.green,
                   pFormat -> direct.greenMask,
                   pFormat -> direct.blue,
                   pFormat -> direct.blueMask,
                   pFormat -> direct.alpha,
                   pFormat -> direct.alphaMask);
}
#endif

#ifdef NXAGENT_RECONNECT

extern Bool nxagentFillGlyphSet(GlyphSetPtr);

void nxagentReConnectGlyphSet(void* p0, XID x1, void *p2)
{
  GlyphSetPtr pGly = (GlyphSetPtr)p0;
  XRenderPictFormat *pForm = NULL;

#ifdef NXAGENT_RECONNECT_GLYPHSET_DEBUG
  fprintf(stderr, "nxagentReConnectGlyphSet: %p\n", pGly);
#endif

  if (pGly -> format)
  {
    pForm = nxagentMatchingFormats(pGly -> format);
  }
  pGly -> remoteID = XRenderCreateGlyphSet(nxagentDisplay, pForm);

#ifdef NX_RENDER_DEBUG
  XSync(nxagentDisplay, False);
#endif

  nxagentFillGlyphSet(pGly);
}

static void nxagentReConnectPicture(void *p0, XID x1, void *p2)
{
  PicturePtr pPicture = (PicturePtr)p0;
  Bool *pBool = (Bool*)p2;
  unsigned long mask = 0;
  XRenderPictureAttributes attributes;
  XRenderPictFormat        *pForm;

#ifdef NXAGENT_RECONNECT_PICTURE_DEBUG
  fprintf(stderr, "nxagentReConnectPicture: %p\n", pPicture);
#endif

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPicture: Called with bool [%d] and picture at [%p].\n",
              *pBool, (void *) pPicture);

  fprintf(stderr, "nxagentReConnectPicture: Virtual picture is [%ld].\n",
              nxagentPicture(pPicture));
  #endif

  /*
   * Check also if the picture has been already created.
   */

  if (!*pBool || !pPicture || nxagentPicture(pPicture))
  {
    return;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPicture: 1.\n");
  #endif

  if (pPicture -> repeat)
  {
    mask |= CPRepeat;

    attributes.repeat = (Bool) pPicture -> repeat;
  }

  if (pPicture -> alphaMap)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPicture: 2.\n");
    #endif

    if (!nxagentPicture(pPicture -> alphaMap))
    {
      #ifdef TEST
      fprintf(stderr, "nxagentReConnectPicture: 3.\n");
      #endif

      nxagentReConnectPicture(pPicture -> alphaMap, 0, pBool);

      if (!*pBool || !nxagentPicture(pPicture -> alphaMap))
      {
        #ifdef TEST
        fprintf(stderr, "nxagentReConnectPicture: 4.\n");
        #endif

        return;
      }
    }

    attributes.alpha_map = nxagentPicture(pPicture -> alphaMap);
    attributes.alpha_x_origin = pPicture -> alphaOrigin.x;
    attributes.alpha_y_origin = pPicture -> alphaOrigin.y;

    mask |= (CPAlphaMap | CPAlphaXOrigin | CPAlphaYOrigin);
  }

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPicture: 5.\n");
  #endif

  if (pPicture -> graphicsExposures)
  {
    attributes.graphics_exposures = pPicture -> graphicsExposures;
    mask |= CPGraphicsExposure;
  }

  attributes.subwindow_mode = pPicture -> subWindowMode;
  mask |= CPSubwindowMode;
  attributes.poly_edge = pPicture -> polyEdge;
  mask |= CPPolyEdge;
  attributes.poly_mode = pPicture -> polyMode;
  mask |= CPPolyMode;
  attributes.dither = pPicture -> dither;
  mask |= CPDither;
  attributes.component_alpha = pPicture -> componentAlpha;
  mask |= CPComponentAlpha;

  pForm = NULL;

  if (pPicture -> pFormat)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPicture: 6.\n");
    #endif

    pForm = nxagentMatchingFormats(pPicture -> pFormat);

#ifdef NX_RENDER_DEBUG
    nxagentPrintFormat(pForm);
#endif
  }

  if (!pForm)
  {
    *pBool = False;

    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPicture: 7.\n");
    #endif

    return;
  }

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPicture: 8.\n");
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPicture: Creating picture at [%p] with drawable [%ld].\n",
              (void *) pPicture, nxagentDrawable(pPicture -> pDrawable));

  /*
   * Should print values of attributes
   * and picture format.
   */

  fprintf(stderr, "nxagentReConnectPicture: Format is at [%p] mask is [%ld] attributes are at [%p].\n",
              (void *) pForm, mask, (void *) &attributes);
  #endif

  nxagentPicture(pPicture) = XRenderCreatePicture(nxagentDisplay,
                                                  nxagentDrawable(pPicture -> pDrawable),
                                                  pForm,
                                                  mask,
                                                  &attributes);

  #ifdef TEST

  XSync(nxagentDisplay, False);

  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPicture: Reconnected picture at [%p] with value [%ld].\n",
              (void *) pPicture, nxagentPicture(pPicture));
  #endif

  if (nxagentAlphaEnabled &&
      pPicture -> pDrawable->depth == 32 &&
      pPicture -> pFormat -> direct.alpha != 0)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentReConnectPicture: 9.\n");
    #endif

    if (pPicture -> pDrawable -> type == DRAWABLE_PIXMAP)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentReConnectPicture: 10.\n");
      #endif

      nxagentPixmapPriv((PixmapPtr) pPicture -> pDrawable) -> pPicture = pPicture;
    }
    else if (pPicture -> pDrawable -> type == DRAWABLE_WINDOW)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentReConnectPicture: 11.\n");
      #endif

      nxagentWindowPriv((WindowPtr) pPicture -> pDrawable) -> pPicture = pPicture;
    }
  }

  #ifdef TEST
  fprintf(stderr, "nxagentReConnectPicture: 12.\n");
  #endif

#if 0
  XSync(nxagentDisplay, False);
  if (pPicture -> clientClip)
  {
    nxagentChangePictureClip(pPicture,
    pPicture -> clientClipType,
    pPicture -> clientClip,
    nRects,
    rect,
    pPicture -> clipOrigin.x,
    pPicture -> clipOrigin.y);
  }
#endif
}

Bool nxagentReCreatePictures(void *p)
{
  int i;
  Bool r;

  #ifdef TEST
  fprintf(stderr, "nxagentReCreatePictures: Going to recreate all pictures.\n");
  #endif

  for (i = 0, r = 1; i < MAXCLIENTS; i++)
  {
    if (clients[i])
    {
      FindClientResourcesByType(clients[i], PictureType,
                                    nxagentReConnectPicture, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentReCreatePictures: WARNING! Failed to recreate "
                    "picture for client [%d].\n", i);
      }

      #endif
    }
  }

  return True;
}

void nxagentDisconnectPicture(void *p0, XID x1, void* p2)
{
  PicturePtr pPicture = (PicturePtr) p0;

  Bool *pBool = (Bool*) p2;

  #ifdef TEST
  fprintf(stderr, "nxagentDisconnectPicture: Called with bool [%d] and picture at [%p].\n",
              *pBool, (void *) pPicture);

  fprintf(stderr, "nxagentDisconnectPicture: Virtual picture is [%ld].\n",
              nxagentPicture(pPicture));
  #endif

  if (!*pBool || !pPicture)
  {
    return;
  }

#ifdef NXAGENT_RECONNECT_PICTURE_DEBUG
  fprintf(stderr, "nxagentDisconnectPicture: %p - XID %lx\n", pPicture, nxagentPicture(pPicture));
#endif

  nxagentPicture(pPicture) = None;
}

Bool nxagentDisconnectPictures(void)
{
  int i;
  Bool r;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_PICTURE_DEBUG)
  fprintf(stderr, "nxagentDisconnectPictures\n");
#endif

  for (i = 0, r = 1; i < MAXCLIENTS; i++)
  {
    if (clients[i])
    {
      FindClientResourcesByType(clients[i], PictureType,
                                    nxagentDisconnectPicture, &r);

      #ifdef WARNING

      if (r == False)
      {
        fprintf(stderr, "nxagentDisconnectPictures: WARNING! Failed to disconnect "
                    "picture for client [%d].\n", i);
      }

      #endif

    }
  }

  return True;
}
#endif

