/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "scrnintstr.h"
#include "dix.h"
#include "mi.h"
#include "mibstore.h"
#include "Agent.h"

#include "Display.h"
#include "Visual.h"

Visual *nxagentVisual(pVisual)
     VisualPtr pVisual;
{
  int i;

  for (i = 0; i < nxagentNumVisuals; i++)
  {
    if (pVisual->class == nxagentVisuals[i].class &&
        pVisual->bitsPerRGBValue == nxagentVisuals[i].bits_per_rgb &&
        pVisual->ColormapEntries == nxagentVisuals[i].colormap_size &&
        pVisual->nplanes == nxagentVisuals[i].depth &&
        pVisual->redMask == nxagentVisuals[i].red_mask &&
        pVisual->greenMask == nxagentVisuals[i].green_mask &&
        pVisual->blueMask == nxagentVisuals[i].blue_mask)
    {
      return nxagentVisuals[i].visual;
    }
  }

  return NULL;
}

Visual *nxagentVisualFromID(pScreen, visual)
     ScreenPtr pScreen;
     VisualID visual;
{
  int i;

  for (i = 0; i < pScreen->numVisuals; i++)
  {
    if (pScreen->visuals[i].vid == visual)
    {
      return nxagentVisual(&pScreen->visuals[i]);
    }
  }

  return NULL;
}

Colormap nxagentDefaultVisualColormap(visual)
     Visual *visual;
{
  int i;

  for (i = 0; i < nxagentNumVisuals; i++)
  {
    if (nxagentVisuals[i].visual == visual)
    {
      return nxagentDefaultColormaps[i];
    }
  }

  return None;
}

/*
 * This is currently unused. It should serve
 * the scope of matching a visual whenever
 * a drawable has a different depth than the
 * real display.
 */

Visual *nxagentVisualFromDepth(pScreen, depth)
     ScreenPtr pScreen;
     int depth;
{
  int i;

  for (i = 0; i < pScreen->numVisuals; i++)
  {
    if (pScreen->visuals[i].nplanes == depth)
    {
      return nxagentVisual(&pScreen->visuals[i]);
    }
  }

  return NULL;
}

