/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __GC_H__
#define __GC_H__

/* This file uses the GC definition form Xlib.h as XlibGC. */

typedef struct {
  XlibGC gc;

  int nClipRects;
#ifdef NXAGENT_GCOPTIMIZE
  XGCValues lastServerValues;
#endif
/*
#ifdef NXAGENT_MVFB
  GCFuncs  mfb_Funcs;
  GCOps    mfb_Ops;
#endif
*/
} nxagentPrivGC;

extern int nxagentGCPrivateIndex;

#define nxagentGCPriv(pGC) \
  ((nxagentPrivGC *)((pGC)->devPrivates[nxagentGCPrivateIndex].ptr))

#define nxagentGC(pGC) (nxagentGCPriv(pGC)->gc)


#ifdef NXAGENT_GCOPTIMIZE
#define nxagentTestGC(pgc, pvalue) ((nxagentGCPriv(pGC) -> lastServerValues.pvalue == pGC -> pgc)?0:1); nxagentGCPriv(pGC) -> lastServerValues.pvalue = pGC -> pgc
#endif

Bool nxagentCreateGC();
void nxagentValidateGC();
void nxagentChangeGC();
void nxagentCopyGC();
void nxagentDestroyGC();
void nxagentChangeClip();
void nxagentDestroyClip();
void nxagentDestroyClipHelper();
void nxagentCopyClip();

#endif /* __GC_H__ */
