/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __Events_H__
#define __Events_H__

#include <X11/Xmd.h>

#define ProcessedExpose (LASTEvent + 1)
#define ProcessedNotify (LASTEvent + 2)

extern CARD32 nxagentLastEventTime;

/*
 * Manage incoming events.
 */

extern void nxagentDispatchEvents();

/*
 * Enable and disable notification of
 * remote X server events.
 */

extern void nxagentEnableKeyboardEvents();
extern void nxagentEnablePointerEvents();

extern void nxagentDisableKeyboardEvents();
extern void nxagentDisablePointerEvents();

/*
 * Bring keyboard device in known state. It needs
 * a round-trip so it only gets called if a pre-
 * vious XKB event did not implicitly initialized
 * the internal state. This is unlikely to happen.
 */

extern int nxagentInitKeyboardState();

/*
 * Update the keyboard state according
 * to focus and XKB events received
 * from the remote X server.
 */

extern int nxagentHandleKeyboardEvent(XEvent *X);

/*
 * Handle sync and karma messages and
 * other notification event coming
 * from proxy.
 */

extern int nxagentHandleProxyEvent(XEvent *X);

/*
 * Other functions providing the ad-hoc
 * handling of the remote X events.
 */

extern int nxagentHandleExposeEvent(XEvent *X);
extern int nxagentHandleGraphicsExposeEvent(XEvent *X);
extern int nxagentHandleClientMessageEvent(XEvent *X);

/*
 * Send a fake keystroke to the remote
 * X server.
 */

extern void nxagentSendFakeKey(int key);

/*
 * Called to manage grab of pointer and
 * keyboard when running in fullscreen
 * mode.
 */

extern void nxagentGrabPointerAndKeyboard(XEvent *X);
extern void nxagentUngrabPointerAndKeyboard(XEvent *X);

/*
 * Handle the selection property received
 * in the event loop.
 */

void nxagentCollectPropertyEvent(int resource);

/*
 * Handle the get image reply received in
 * the event loop.
 */

void nxagentCollectImageEvent(int resource);

#endif /* __Events_H__ */
