/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef __Options_H__
#define __Options_H__

typedef enum _BackingStoreMode
{
  BackingStoreUndefined = -1,
  BackingStoreNever,
  BackingStoreWhenRequested,
  BackingStoreForce

} BackingStoreMode;

/*
 * Set of options affecting agent operations.
 */

typedef struct _AgentOptions
{
  /*
   * True if user activated fullscreen mode.
   */

  unsigned int Fullscreen;

  /*
   * True if user activated rootless mode.
   */

  unsigned int Rootless;

  /*
   * True if user activated persistent mode.
   */

  unsigned int Persistent;

  /*
   * Geometry of the agent's window.
   */

  int X;
  int Y;
  unsigned int Width;
  unsigned int Height;
  unsigned int BorderWidth;

  /*
   * Set if agent is running nested in another
   * agent X server.
   */

  unsigned int Nested;

  /*
   * Selected backing-store mode.
   */

  BackingStoreMode BackingStore;

  /*
   * Enable agent to use the MITSHM extension in
   * path from remote proxy to the real X server.
   */

  unsigned int SharedMemory;

  /*
   * Enable agent to propagate keyboard and pointer
   * device configuration to the remote X server.
   */

  unsigned int DeviceControl;

  /*
   * Reset server when the last client disconnects.
   */

  unsigned int Reset;

} AgentOptionsRec;

typedef AgentOptionsRec *AgentOptionsPtr;

extern AgentOptionsPtr nxagentOptionsPtr;

/*
 * Macros and functions giving access to options.
 */

#define nxagentOption(option) \
    (nxagentOptionsPtr -> option)

#define nxagentChangeOption(option, value) \
    (nxagentOptionsPtr -> option = (value))

#define nxagentOptions() \
    (nxagentOptionsPtr)

/*
 * Initialize the options to the default values.
 */

extern void nxagentResetOptions();

#endif /* __Options_H__ */
