/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#ifndef __Display_H__
#define __Display_H__

#define UNDEFINED -1

#define MAXDEPTH 32
#define MAXVISUALSPERDEPTH 256

extern Display *nxagentDisplay;
extern XVisualInfo *nxagentVisuals;
extern int nxagentNumVisuals;
extern int nxagentDefaultVisualIndex;
extern Colormap *nxagentDefaultColormaps;
extern int nxagentNumDefaultClormaps;
extern int *nxagentDepths;
extern int nxagentNumDepths;
extern XPixmapFormatValues *nxagentPixmapFormats;
extern int nxagentNumPixmapFormats;
extern Pixel nxagentBlackPixel;
extern Pixel nxagentWhitePixel;
extern Drawable nxagentDefaultDrawables[MAXDEPTH + 1];
extern Pixmap nxagentScreenSaverPixmap;

/*
 * The "confine" window is used in nxagentConstrainCursor().
 * We are currently overriding the original Xnest behaviour
 * and just skip the "constrain" stuff.
 */

extern Window nxagentConfineWindow;

/*
 * Keyboard and pointer are handled as they were hardware
 * devices, that is we translate the key codes according to
 * our own transcripts. We inherit this behaviour from Xnest.
 * The following mask will contain the event mask selected
 * for the root window. All the keyboard and pointer events
 * are enqueued to the mi that translates and posts them to
 * managed clients.
 */

extern unsigned long nxagentEventMask;

void nxagentOpenDisplay();
void nxagentCloseDisplay();

/*
 * Set depths and pixmap formats and create the default
 * drawables.
 */

void nxagentSetScreenInfo();
void nxagentSetPixmapFormats();
void nxagentGetDepthsAndPixmapFormats();
void nxagentSetDefaultDrawables();

#endif /* __Display_H__ */
