/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "scrnintstr.h"
#include "servermd.h"
#include "opaque.h"

/*
 * NX specific includes and definitions.
 */

#include "Agent.h"
#include "Display.h"
#include "Args.h"
#include "Control.h"
#include "Options.h"

/*
 * From X11/ImUtil.c.
 */

extern int _XGetBitsPerPixel(Display *dpy, int depth);

/*
 * FIXME: Add comments and a comprehensive
 * organization for sparse variable herein.
 */

#ifdef NXAGENT_PACKEDIMAGES

#include NXAGENT_NXPACK_INCLUDE
#include NXAGENT_NXLIB_INCLUDE

int nxagentPackMethod     = -1; /*XXX: nxagentPostProcessArgs */
int nxagentPackQuality    = -1; /*XXX: nxagentPostProcessArgs */
int nxagentTightThreshold = -1; /*XXX: nxagentPostProcessArgs */

#endif

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  WATCH

#ifdef WATCH
#include "unistd.h"
#endif

char nxagentDisplayName[1024];
char nxagentWindowName[256];
char nxagentDialogName[256];

Bool nxagentSynchronize = False;
Bool nxagentFullGeneration = False;
int nxagentDefaultClass = TrueColor;
Bool nxagentUserDefaultClass = False;
int nxagentDefaultDepth;
Bool nxagentUserDefaultDepth = False;
Bool nxagentSoftwareScreenSaver = False;
int nxagentUserGeometry = 0;
Bool nxagentUserBorderWidth = False;
int nxagentNumScreens = 0;
Bool nxagentDoDirectColormaps = False;
Window nxagentParentWindow = 0;
Bool nxagentIpaq = False;

Bool nxagentUseNXTrans   = False;
Bool nxagentForceNXTrans = False;

int nxagentCleanGet    = 0;
int nxagentCleanAlloc  = 0;
int nxagentCleanFlush  = 0;
int nxagentCleanSend   = 0;
int nxagentCleanImages = 0;

int nxagentImageSplit  = 0;
int nxagentImageMask   = 0;
int nxagentImageFrame  = 0;

unsigned int nxagentImageSplitMethod  = 0;
unsigned int nxagentImageMaskMethod   = 0;

#ifdef NXAGENT_KEYMAP
char *nxagentKeyboard = NULL;
char *nxagentKbtype = NULL;
#endif

#ifdef NXAGENT_STOPBIGREQ
long nxagentLastImgSize;
ClientPtr nxagentLastImgClient;
#endif

#ifdef NXAGENT_EXPOSURES
Bool nxagentAutoExposures = True; /*XXX: nxagentPostProcessArgs */
#endif

#ifdef NXAGENT_FORCEBACK
Bool nxagentForceBackingStore = False;
unsigned long nxagentMaxAreaBackS = 786432;
unsigned long nxagentMinAreaBackS = 4096;
unsigned long nxbsQueueTimeout = 5000;
#endif

#ifdef NXAGENT_ONEXIT
Bool nxagentOnce = True;
#endif

#ifdef NXAGENT_SAFEMODE
Bool nxagentSafeMode = False;
#endif

#ifdef RENDER
extern Bool nxagentRenderEnable;
#endif

/*
 * When "fast mode" is not set, agent will query the
 * remote X server to get real content of drawables.
 * When fast mode is enabled, agent will save the
 * round-trip by just clearing the drawable to its
 * background.
 */

int nxagentFastCopyAreaEnable = UNDEFINED;
int nxagentFastGetImageEnable = UNDEFINED;

/*
 * Get the caption to be used for helper dialogs
 * from agent's window name passed as parameter.
 */

static int nxagentGetDialogName();

int ddxProcessArgument (argc, argv, i)
    int  argc;
    char *argv[];
    int  i;
{
  /*
   * Ensure that the options are set to their defaults.
   */

  static Bool resetOptions = True;

  if (resetOptions == True)
  {
    nxagentResetOptions();

    resetOptions = False;
  }

  /*
   * This is temporary, just to simplify testing of
   * rootless mode. Note that if rootless is selected,
   * we'll anyway disregard the geometry provided by
   * user, assuming the geometry of the real display.
   */

  if (nxagentOption(Width) == 100 &&
        nxagentOption(Height) == 100)
  {
    nxagentChangeOption(Rootless, True);
  }

  if (!strcmp(argv[i], "-display"))
  {
    if (++i < argc)
    {
      strncpy(nxagentDisplayName, argv[i], 1023);

      nxagentDisplayName[1023] = '\0';

      return 2;
    }

    return 0;
  }

  if (!strcmp(argv[i], "-full")) {
    nxagentFullGeneration = True;
    return 1;
  }

  if (!strcmp(argv[i], "-class")) {
    if (++i < argc) {
      if (!strcmp(argv[i], "StaticGray")) {
        nxagentDefaultClass = StaticGray;
        nxagentUserDefaultClass = True;
        return 2;
      }
      else if (!strcmp(argv[i], "GrayScale")) {
        nxagentDefaultClass = GrayScale;
        nxagentUserDefaultClass = True;
        return 2;
      }
      else if (!strcmp(argv[i], "StaticColor")) {
        nxagentDefaultClass = StaticColor;
        nxagentUserDefaultClass = True;
        return 2;
      }
      else if (!strcmp(argv[i], "PseudoColor")) {
        nxagentDefaultClass = PseudoColor;
        nxagentUserDefaultClass = True;
        return 2;
      }
      else if (!strcmp(argv[i], "TrueColor")) {
        nxagentDefaultClass = TrueColor;
        nxagentUserDefaultClass = True;
        return 2;
      }
      else if (!strcmp(argv[i], "DirectColor")) {
        nxagentDefaultClass = DirectColor;
        nxagentUserDefaultClass = True;
        return 2;
      }
    }
    return 0;
  }

  if (!strcmp(argv[i], "-cc")) {
    if (++i < argc && sscanf(argv[i], "%i", &nxagentDefaultClass) == 1) {
      if (nxagentDefaultClass >= 0 && nxagentDefaultClass <= 5) {
        nxagentUserDefaultClass = True;
        /* lex the OS layer process it as well, so return 0 */
      }
    }
    return 0;
  }

  if (!strcmp(argv[i], "-depth")) {
    if (++i < argc && sscanf(argv[i], "%i", &nxagentDefaultDepth) == 1) {
      if (nxagentDefaultDepth > 0) {
        nxagentUserDefaultDepth = True;
        return 2;
      }
    }
    return 0;
  }

  if (!strcmp(argv[i], "-sss")) {
    nxagentSoftwareScreenSaver = True;
    return 1;
  }

  if (!strcmp(argv[i], "-fast"))
  {
    nxagentFastCopyAreaEnable = True;
    nxagentFastGetImageEnable = True;

    return 1;
  }

  if (!strcmp(argv[i], "-slow"))
  {
    nxagentFastCopyAreaEnable = False;
    nxagentFastGetImageEnable = False;

    return 1;
  }
  
  if (!strcmp(argv[i], "-geometry"))
  {
    if (++i < argc)
    {
      if (!strcmp(argv[i],"fullscreen"))
      {
        nxagentChangeOption(Fullscreen, True);
      }
      else if (!strcmp(argv[i],"ipaq"))
      {
        nxagentChangeOption(Fullscreen, True);

        nxagentIpaq = True;
      }
      else
      {
        int X;
        int Y;
        unsigned int Width;
        unsigned int Height;

        nxagentUserGeometry = XParseGeometry(argv[i], &X, &Y, &Width, &Height);

        nxagentChangeOption(X, X);
        nxagentChangeOption(Y, Y);
        nxagentChangeOption(Width, Width);
        nxagentChangeOption(Height, Height);
      }

      if (nxagentUserGeometry || nxagentOption(Fullscreen)) return 2;
    }

    return 0;
  }

  if (!strcmp(argv[i], "-bw"))
  {
    int BorderWidth;

    if (++i < argc && sscanf(argv[i], "%i", &BorderWidth) == 1)
    {
      nxagentChangeOption(BorderWidth, BorderWidth);

      if (nxagentOption(BorderWidth) >= 0)
      {
        nxagentUserBorderWidth = True;

        return 2;
      }
    }

    return 0;
  }

  if (!strcmp(argv[i], "-name"))
  {
    if (++i < argc)
    {
      strncpy(nxagentWindowName, argv[i], 255);

      *(nxagentWindowName + 255) = '\0';

      nxagentGetDialogName();

      return 2;
    }

    return 0;
  }

  if (!strcmp(argv[i], "-scrns")) {
    if (++i < argc && sscanf(argv[i], "%i", &nxagentNumScreens) == 1) {
      if (nxagentNumScreens > 0) {
        if (nxagentNumScreens > MAXSCREENS) {
          ErrorF("Maximum number of screens is %d.\n", MAXSCREENS);
          nxagentNumScreens = MAXSCREENS;
        }
        return 2;
      }
    }
    return 0;
  }

  if (!strcmp(argv[i], "-install")) {
    nxagentDoDirectColormaps = True;
    return 1;
  }

  if (!strcmp(argv[i], "-parent")) {
    if (++i < argc) {
      nxagentParentWindow = (XID) strtol (argv[i], (char**)NULL, 0);
      return 2;
    }
  }

  if (!strcmp(argv[i], "-forcenx")) {
    nxagentForceNXTrans = True;
    return 1;
  }

  if (!strcmp(argv[i], "-strict")) {
      nxagentStrictControl = True;
      return 1;
  }

  if (!strcmp(argv[i], "-nostrict")) {
      nxagentStrictControl = False;
      return 1;
  }

#ifdef NXAGENT_EXPOSURES
  if (!strcmp(argv[i], "-noautoexpose")) {
      nxagentAutoExposures = False;
      return 1;
  }
#endif

#ifdef NXAGENT_ONEXIT
  if (!strcmp(argv[i], "-noonce"))
  {
      nxagentOnce = False;
      return 1;
  }
#endif

#ifdef NXAGENT_FORCEBACK
  if (!strcmp(argv[i], "-bs"))
  {
    if (++i < argc)
    {
      if (!strcmp(argv[i], "force"))
      {
        nxagentChangeOption(BackingStore, BackingStoreForce);

        return 2;
      }
      else if (!strcmp(argv[i], "when_requested"))
      {
        nxagentChangeOption(BackingStore, BackingStoreWhenRequested);

        return 2;
      }
      else if (!strcmp(argv[i], "never"))
      {
        nxagentChangeOption(BackingStore, BackingStoreNever);

        return 2;
      }
    }

    ErrorF("Warning: Option -bs without arguments disables backing-store.\n");
    ErrorF("Warning: Use -bs [forced|when_requested|never] to set required mode.\n");

    nxagentChangeOption(BackingStore, BackingStoreNever);

    return 1;
  }

  if (!strcmp(argv[i], "-maxbsarea")) {
      if (++i < argc && sscanf(argv[i], "%lu", &nxagentMaxAreaBackS) == 1) {
          if (nxagentMaxAreaBackS > 0) {
              return 2;
          }
      }
      return 0;
  }

  if (!strcmp(argv[i], "-minbsarea")) {
      if (++i < argc && sscanf(argv[i], "%lu", &nxagentMinAreaBackS) == 1) {
          if (nxagentMinAreaBackS > 0) {
              return 2;
          }
      }
      return 0;
  }

  if (!strcmp(argv[i], "-bstimeout")) {
      if (++i < argc && sscanf(argv[i], "%lu", &nxbsQueueTimeout) == 1) {
          if (nxbsQueueTimeout > 0) {
              return 2;
          }
      }
      return 0;
  }
#endif

#ifdef NXAGENT_SAFEMODE
  if (!strcmp(argv[i], "-safe")) {
    nxagentSafeMode = True;
    return 1;
  }
#endif

#ifdef NXAGENT_KEYMAP
  if (!strcmp(argv[i], "-keyboard")) {
    if (++i < argc)
    {
      nxagentKeyboard = argv[i];
      return 2;
    }
    return 0;
  }

  if (!strcmp(argv[i], "-kbtype")) {
    if (++i < argc)
    {
      nxagentKbtype = argv[i];
      return 2;
    }
    return 0;
  }
#endif

#ifdef NXAGENT_FOCUS_KARMA
 if (!strcmp(argv[i], "-limit")) {
    nxagentUsesFocusKarma = True;
    return 1;
  }

  if (!strcmp(argv[i], "-nolimit")) {
    nxagentUsesFocusKarma = False;
    return 1;
  }
#endif

  /*
   * FIXME: -nogetimage and -vfb are useless with
   * the internal fb. Options are left only for
   * compatibility with old versions.
   */

  if (!strcmp(argv[i], "-nogetimage"))
  {
    return 1;
  }

  if (!strcmp(argv[i], "-vfb"))
  {
     return 2;
  }

  if (!strcmp(argv[i], "-extensions"))
  {
     return 1;
  }

#ifdef RENDER
  if (!strcmp(argv[i], "-norender"))
  {
    nxagentRenderEnable = False;

    return 1;
  }
#endif

  /*
   * The original -noreset option, disabling
   * dispatchExceptionAtReset, is the default.
   * Use this option to restore the original
   * behaviour.
   */

  if (!strcmp(argv[i], "-reset"))
  {
    nxagentChangeOption(Reset, True);

    return 1;
  }

#ifdef NXAGENT_RECONNECT
  if (!strcmp(argv[i], "-persistent"))
  {
    nxagentChangeOption(Persistent, True);

    return 1;
  }
#endif

  if (!strcmp(argv[i], "-noshmem"))
  {
    nxagentChangeOption(SharedMemory, False);

    return 1;
  }

  if (!strcmp(argv[i], "-noignore"))
  {
    nxagentChangeOption(DeviceControl, True);

    return 1;
  }

  /*
   * Enable pseudo-rootless mode.
   */

  if (!strcmp(argv[i], "-rootless"))
  {
    nxagentChangeOption(Rootless, True);

    return 1;
  }

  return 0;
}

/*
 * FIXME: Transport initialization, shouldn't depend upon
 *        argv[], because we call it at every reconnection.
 */

Bool nxagentPostProcessArgs(char* name, Display* dpy, Screen* scr)
{
    Bool useNXTrans = False;

    #ifdef WATCH

    fprintf(stderr, "nxagentPostProcessArgs: Watchpoint 2.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
N/A
*/

    sleep(30);

    #endif

    /*
     * Ensure we have a valid name for both agent's
     * window and children dialogs.
     */

    if (*nxagentWindowName == '\0')
    {
      strncpy(nxagentWindowName, "NX", 255);

      *(nxagentWindowName + 255) = '\0';
    }

    if (*nxagentDialogName == '\0')
    {
      strncpy(nxagentDialogName, "NX", 255);

      *(nxagentDialogName + 255) = '\0';
    }

    /*
     * Set backing-store option according
     * to command line parameter.
     */

    switch (nxagentOption(BackingStore))
    {
      case BackingStoreNever:
      {
        enableBackingStore = False;
        nxagentForceBackingStore = False;

        break;
      }
      case BackingStoreWhenRequested:
      {
        enableBackingStore = True;
        nxagentForceBackingStore = False;

        break;
      }
      case BackingStoreForce:
      {
        enableBackingStore = True;
        nxagentForceBackingStore = True;

        break;
      }
      default:
      {
        nxagentChangeOption(BackingStore, BackingStoreWhenRequested);

        enableBackingStore = True;
        nxagentForceBackingStore = False;

        break;
      }
    }

    #ifdef TEST
    fprintf(stderr, "nxagentPostProcessArgs: Backing store mode set to [%d] with [%d] and [%d].\n",
                nxagentOption(BackingStore), enableBackingStore, nxagentForceBackingStore);
    #endif

    /*
     * Note that use of NX packed images as well as
     * render extension could be later disabled due
     * to the fact that session is running nested
     * in a nxagent server.
     */

    if (nxagentForceNXTrans)
    {
      useNXTrans = True;
    }
    else if (strncasecmp(name, "nx", 2) == 0)
    {
      useNXTrans = True;
    }

    if (useNXTrans)
    {
      int karmaSize, splitSize;
      int bitsPerPixel = 0;

      unsigned int linkType;
      unsigned int protocolMajor, protocolMinor, protocolPatch;
      unsigned int packMethod, packQuality;
      int dataLevel, streamLevel, deltaLevel;
      unsigned int loadCache, saveCache, startupCache;

      unsigned char supportedMethods[NXNumberOfPackMethods];
      unsigned int entries = NXNumberOfPackMethods;

      NXGetControlParameters(dpy, &linkType, &protocolMajor, &protocolMinor,
                                 &protocolPatch, &karmaSize, &splitSize,
                                     &packMethod, &packQuality, &dataLevel,
                                         &streamLevel, &deltaLevel, &loadCache,
                                             &saveCache, &startupCache);

      if (protocolMajor < 1 ||
              (protocolMajor == 1 &&
                   protocolMinor < 3))
      {
        nxagentChangeOption(SharedMemory, False);
      }

      /*
       * Set the flag so a dialog will be
       * showed at the time timeout is
       * elapsed.
       */

      if (loadCache == 1 && startupCache == 0)
      {
        nxagentSetNoCacheDialogTimeout(linkType);

        nxagentNoCacheDialogEnable = True;
      }

#ifdef NXAGENT_PACKEDIMAGES_DEBUG
      fprintf(stderr, "nxagentPostProcessArgs: Got preferred pack method [%d] and quality [%d] from proxy.\n",
                  packMethod, packQuality);
#endif

      if (nxagentPackMethod == -1)
      {
        nxagentPackMethod = packMethod;
      }

      if (nxagentPackQuality == -1)
      {
        nxagentPackQuality = packQuality;
      }

      if (nxagentTightThreshold == -1)
      {
        nxagentTightThreshold = splitSize;
      }

      if (NXGetUnpackParameters(dpy, &entries, supportedMethods) == 0 ||
              entries != NXNumberOfPackMethods)
      {
        fprintf(stderr, "nxagentPostProcessArgs: NXGetUnpackParameters() failed. Disabling pack of images\n");

        nxagentPackMethod = NO_PACK;
      }

      if (!supportedMethods[nxagentPackMethod] &&
              nxagentPackMethod >= PACK_PNG_JPEG_8_COLORS &&
                  nxagentPackMethod <= PACK_PNG_JPEG_16M_COLORS)
      {
        /*
         * Let's try the same JPEG method without PNG.
         * Arbitrarily assume the corresponding method
         * is at this offset.
         */

        fprintf(stderr, "nxagentPostProcessArgs: Pack method [%d] not supported by proxy.\n",
                    nxagentPackMethod);

        nxagentPackMethod = nxagentPackMethod - 21;
      }

      if (!supportedMethods[nxagentPackMethod])
      {
        fprintf(stderr, "nxagentPostProcessArgs: Pack method [%d] not supported by proxy. Disabling pack of images.\n",
                      nxagentPackMethod);

        nxagentPackMethod = NO_PACK;
      }

      bitsPerPixel = _XGetBitsPerPixel(dpy, DefaultDepth(dpy, DefaultScreen(dpy)));

      nxagentPackMethod = SelectPackMethod(nxagentPackMethod, bitsPerPixel,
                                               bitsPerPixel);

      /*
       * FIXME: There is a problem in cleanup of images when selecting
       *        a method that doesn't reduce the number of colors. This
       *        is the case of JPEG 16M on 24/32 bits. The same problem
       *        arises with JPEG 64K in case of 16 bits, but we cannot
       *        force 32K because this would degrade quality of images
       *        too much.
       */
/*
#define NXAGENT_PACKEDIMAGES_DEBUG

      if (nxagentPackMethod == PACK_JPEG_16M_COLORS &&
              (bitsPerPixel == 24 || bitsPerPixel == 32))
      {
        nxagentPackMethod = PACK_JPEG_2M_COLORS;

        #ifdef NXAGENT_PACKEDIMAGES_DEBUG
        fprintf(stderr, "nxagentPostProcessArgs: Forcing pack method [%d] with [%d] bits per pixel.\n",
                    nxagentPackMethod, bitsPerPixel);
        #endif

        fprintf(stderr, "nxagentPostProcessArgs: Cleanup of images will be applied.\n");
      }
      #ifdef NXAGENT_PACKEDIMAGES_DEBUG
      else if (nxagentPackMethod == PACK_JPEG_64K_COLORS &&
                   bitsPerPixel == 16)
      {
        fprintf(stderr, "nxagentPostProcessArgs: Using pack method [%d] with [%d] bits per pixel.\n",
                    nxagentPackMethod, bitsPerPixel);

        fprintf(stderr, "nxagentPostProcessArgs: No cleanup of images will be applied.\n");
      }
      else
      {
        fprintf(stderr, "nxagentPostProcessArgs: Using pack method [%d] with [%d] bits per pixel.\n",
                    nxagentPackMethod, bitsPerPixel);
      }
      #endif

#undef NXAGENT_PACKEDIMAGES_DEBUG
*/
      if (nxagentStopImgSz == -1)
      {
        nxagentStopImgSz = splitSize;
      }

      if (nxagentStopKarmaSz == -1)
      {
        nxagentStopKarmaSz        = karmaSize;
        nxagentStopKarmaSzDefault = karmaSize;
        nxagentStopKarmaSzCheck   = karmaSize >> 4;
      }

      if (nxagentPackMethod != -1)
      {
        /*
         * Set the unpack geometry for the 'default'
         * client.
         */

        NXSetUnpackGeometry(dpy, 0, scr, NULL);
      }

      NXGetCleanupParameters(dpy, &nxagentCleanGet, &nxagentCleanAlloc,
                                 &nxagentCleanFlush, &nxagentCleanSend, &nxagentCleanImages);

      NXGetImageParameters(dpy, &nxagentImageSplit, &nxagentImageMask, &nxagentImageFrame,
                               &nxagentImageSplitMethod, &nxagentImageMaskMethod);

      /*
       * Agent calls NXlib clean and mask functions
       * by itself, instead of relying on Xlib.
       */

      {
        /*
         * FIXME: These definitions should be
         * available in NXlib.h or NXlibint.h.
         */

        extern int _NXEnableCleanImages;
        extern int _NXEnableImageMask;

        _NXEnableCleanImages = 0;
        _NXEnableImageMask   = 0;
      }

      /*
       * In case of slower links send karma and
       * sync messages based on congestion state
       * reported by NX transport.
       */

      if (nxagentStrictControl == False)
      {
        if (linkType == LINK_TYPE_MODEM ||
                linkType == LINK_TYPE_ISDN ||
                    linkType == LINK_TYPE_ADSL)
        {
          nxagentStrictControl = False;
        }
        else
        {
          nxagentStrictControl = True;
        }
      }
      else
      {
        /*
         * If strict control is enabled reduce
         * by half the number of blocking sync
         * messages.
         */

        if (linkType == LINK_TYPE_MODEM ||
                linkType == LINK_TYPE_ISDN ||
                    linkType == LINK_TYPE_ADSL)
        {
          nxagentSyncModulo = 2;
        }
      }

      if (nxagentStrictControl == False)
      {
        fprintf(stderr, "Info: Disabling strict flow control in agent.\n");
      }

      /*
       * Adjust threshold according to the
       * current policy.
       */

      nxagentAdjustKarma();

      /*
       * Activate shared memory PutImages
       * in X server proxy.
       */

      if (nxagentOption(SharedMemory) == True)
      {
        /*
         * Shared memory on path from agent to
         * X client proxy is not implemented.
         */

        unsigned int enableClient = 0;
        unsigned int enableServer = 1;

        unsigned int clientSegment, serverSegment;

        NXGetShmemParameters(dpy, &enableClient, &enableServer,
                                 &clientSegment, &serverSegment);

        if (enableServer == False)
        {
          fprintf(stderr, "Info: Not using shared memory support in X server.\n");
        }
        else
        {
          fprintf(stderr, "Info: Using shared memory support in X server.\n");
        }
      }

      /*
       * If option -fast was not specified set
       * the current mode according to the link
       * type.
       */

      if (nxagentFastCopyAreaEnable == UNDEFINED)
      {
        if (linkType == LINK_TYPE_WAN || linkType == LINK_TYPE_LAN)
        {
          nxagentFastCopyAreaEnable = False;
        }
        else
        {
          nxagentFastCopyAreaEnable = True;
        }
      }

      if (nxagentFastGetImageEnable == UNDEFINED)
      {
        if (linkType == LINK_TYPE_WAN || linkType == LINK_TYPE_LAN)
        {
          nxagentFastGetImageEnable = False;
        }
        else
        {
          nxagentFastGetImageEnable = True;
        }
      }
    }
    else
    {
      /*
       * FIXME: Setting auto-exposures to false in
       * the case of local connections is not a good
       * idea. It makes difficult to test the agent
       * in the same conditions as when running over
       * the network with NX proxy.
       *
       * nxagentAutoExposures = False;
       */

      nxagentPackMethod = -1;
      nxagentStopImgSz = 0;
      nxagentStopKarmaSz = 0;
      nxagentStopKarmaSzDefault = 0;
      nxagentStopKarmaSzCheck = 0;
    }

    /*
     * Disable fast mode if not set selected on the
     * command line or not set according to the link.
     */
    
    if (nxagentFastCopyAreaEnable == UNDEFINED)
    {
      nxagentFastCopyAreaEnable = False;
    }

    if (nxagentFastGetImageEnable == UNDEFINED)
    {
      nxagentFastGetImageEnable = False;
    }

    if (nxagentFastCopyAreaEnable == True)
    {
      fprintf(stderr, "Info: Using fast copy area mode in agent.\n");
    }
    else
    {
      fprintf(stderr, "Info: Not using fast copy area mode in agent.\n");
    }

    if (nxagentFastGetImageEnable == True)
    {
      fprintf(stderr, "Info: Using fast get image mode in agent.\n");
    }
    else
    {
      fprintf(stderr, "Info: Not using fast get image mode in agent.\n");
    }

    /*
     * Why do we have to store this
     * in a separate flag?
     */

    if (nxagentRenderEnable == True)
    {
      extern int nxagentAlphaEnabled;

      nxagentAlphaEnabled = 1;
    }

    /*
     * We skip server reset by default. This should
     * be equivalent to passing the -noreset option
     * to a standard XFree86 server.
     */

    if (nxagentOption(Reset) == False)
    {
      extern char dispatchExceptionAtReset;

      #ifdef TEST
      fprintf(stderr, "nxagentPostProcessArgs: Disabling dispatch of exception at server reset.\n");
      #endif

      dispatchExceptionAtReset = 0;
    }

    #ifdef WATCH

    fprintf(stderr, "nxagentPostProcessArgs: Watchpoint 3.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
#16     1		256 bits (0 KB) ->	12 bits (0 KB) ->	256/1 -> 12/1	= 21.333:1
#233 A  1		256 bits (0 KB) ->	131 bits (0 KB) ->	256/1 -> 131/1	= 1.954:1
#245 A  2		512 bits (0 KB) ->	19 bits (0 KB) ->	256/1 -> 10/1	= 26.947:1
*/

    sleep(30);

    #endif

    return useNXTrans;
}

void ddxUseMsg()
{
  ErrorF("-display string        display name of the real server\n");
  ErrorF("-sync                  sinchronize with the real server\n");
  ErrorF("-full                  utilize full regeneration\n");
  ErrorF("-class string          default visual class\n");
  ErrorF("-depth int             default depth\n");
  ErrorF("-sss                   use software screen saver\n");
  ErrorF("-geometry WxH+X+Y      window size and position\n");
  ErrorF("-bw int                window border width\n");
  ErrorF("-name string           window name\n");
  ErrorF("-scrns int             number of screens to generate\n");
  ErrorF("-install               instal colormaps directly\n");

  ErrorF("The NX system adds the following arguments:\n");
  ErrorF("-forcenx               force use of NX protocol messages assuming communication through nxproxy\n");
#ifdef NXAGENT_STOPBIGREQ
  ErrorF("-imgstop int           wait for confirmation from nxproxy after any X_PutImage bigger than int\n");
#endif
#ifdef NXAGENT_GETIFOCUS
  ErrorF("-getifocus             mask X_GetInputFocus requests and wait for confirmation from nxproxy\n");
#endif
#ifdef NXAGENT_XLIBPARAMS
  ErrorF("-imgframe              let NXlib draw a tiny rectangle around images\n");
  ErrorF("-imgsplit PW,PH,BW,BH  force NXlib to split images to the given width and height\n");
#endif
#ifdef NXAGENT_FORCEBACK
  ErrorF("-backingstore          force backing-store on all windows\n");
  ErrorF("-maxbsarea int         maximum area occupied by a window candidate for backing-store\n");
  ErrorF("-bstimeout int         timeout for realizing the backing-store\n");
#endif
#ifdef RENDER
  ErrorF("-norender              disable use of the render extension\n");
#endif
#ifdef NXAGENT_RECONNECT
  ErrorF("-persistent            enable disconnection/reconnection to the X display on SIGHUP\n");
#endif
  ErrorF("-noshmem               disable use of shared memory in path from remote nxproxy to the X server\n");
  ErrorF("-noignore              don't ignore pointer and keyboard configuration changes mandated by clients\n");
}

static int nxagentGetDialogName()
{
  char *separator;

  strcpy(nxagentDialogName, "NX");

  *(nxagentWindowName + 255) = '\0';

  separator = strchr(nxagentWindowName, ':');

  /*
   * Find the colon in display.
   */

  if ((separator == NULL) || !isdigit(*(separator + 1)))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentGetDialogName: PANIC! Can't find port in window name [%s].\n",
                nxagentWindowName);
    #endif
  }
  else
  {
    /*
     * Find the end of display number.
     */

    separator = strchr(separator, ' ');

    if (separator == NULL)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentGetDialogName: PANIC! Can't find end of port in window name [%s].\n",
                  nxagentWindowName);
      #endif
    }
    else
    {
      strncpy(nxagentDialogName, nxagentWindowName,
                  separator - nxagentWindowName);

      *(nxagentDialogName + (separator - nxagentWindowName)) = '\0';

      #ifdef TEST
      fprintf(stderr, "nxagentGetDialogName: Got dialog name [%s] with base name [%s].\n",
                  nxagentDialogName, nxagentWindowName);
      #endif

      return 1;
    }
  }

  return 0;
}
