/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dion@rcom.zp.ua                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include <qlistview.h>
#include <qstring.h>
#include <qlineedit.h>
 
#include "frmconfig.h"

frmConfig::frmConfig(PhoneMan * ph, QWidget *parent, const char *name)
		: frmConfig_base(parent, name)
{
	phone=ph;
}


frmConfig::~frmConfig()
{}

void frmConfig::doactUpdateList()
{
	#define MAX_DEVICES 256
	devInfo nfo[MAX_DEVICES];
	
	int cnt;
	cnt=phone->getDevList(nfo, MAX_DEVICES);
	lstDevices->clear();
	if (!cnt) return;
	
	QListViewItem * itm;
	for (int i=0; i<cnt; i++)
	{
		itm=new QListViewItem(lstDevices, QString("%1").arg(nfo[i].vendor,0,16).rightJustify(4,'0'),
			QString("%1").arg(nfo[i].product,0,16).rightJustify(4,'0'),
			QString(nfo[i].manufacturerStr), QString(nfo[i].productStr));
	}
	
}

void frmConfig::doactSwitchToP2K()
{
	char dv[256];
	strcpy(dv, txtACMdev->text().latin1()); 
	phone->switchToP2K(dv);
}

void frmConfig::doactSetAT()
{
	QListViewItem * itm = lstDevices->selectedItem();
	if (itm == NULL) return;
	txtATvendor->setText(itm->text(0));
	txtATproduct->setText(itm->text(1));
}

void frmConfig::doactSetP2K()
{
	QListViewItem * itm = lstDevices->selectedItem();
	if (itm == NULL) return;
	txtP2Kvendor->setText(itm->text(0));
	txtP2Kproduct->setText(itm->text(1));
}
