#!/bin/bash
#
# script which runs through all the window option tests

if [ \! -x winspew ]; then
   echo "$0: 'winspew' test utility missing, compile it first!"
   exit 2 # 2 indicates mis-setup 
fi


function waitamo()
{
	if [ "$SLEEP" == "0" ]; then
	   echo "Hit a key"
	   read
	else
	   sleep $SLEEP
	fi 
}

LOG=$LOGS/winspew.log
rm -f $LOG

echo
echo "Window options tester"
echo "====================="
echo
echo "Press <enter> to start a test. Press <enter> to quit a test."
echo "In Matchbox, use Alt-p to get back to terminal (to press <enter>)"
echo "while the test is running."
echo
echo "on other window managers you might use e.g. <TAB> to change"
echo "the focus back to this terminal."
echo

count=0


if [ -z "$(matchbox -h | grep 'Message Window Support' | grep 'no')" ]; then

echo; echo "$count. 4 queued message windows from two clients at alternate sides"; waitamo
./winspew -t "Window",normal -c "Dialog",300x200 -t MSG1,message,90x60+20-20,,10 -t MSG2,message,90x60-20-20,,10 >> $LOG &
TEST1=$!
sleep 1
./winspew -t MSG1,message,300x200+20+20,,10 -t MSG2,message,300x200-20+20,,10 >> $LOG &
TEST2=$!
sleep 4
waitamo; kill $TEST1 $TEST2; wait; count=$((count+1))

echo; echo "$count. 2 queued message windows with one modal dialog"; waitamo
./winspew -t "Window",normal -c "Dialog",300x200,modal -t MSG1,message,90x60+20-20,,10 -t MSG2,message,90x60-20-20,,10 >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

else
echo "*** Not testing message windows as Matchbox binary lacks support ***"
fi


echo; echo "$count. Fullscreen window"; waitamo
./winspew -t "Window",normal,,fullscreen >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Fullscreen window with dialog"; waitamo
./winspew -t "Window",normal,,fullscreen -c "Dialog",320x200 >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Fullscreen window with modal dialog"; waitamo
./winspew -t "Window",normal,,fullscreen -c "Dialog",320x200,modal >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Fullscreen window with no-title dialog"; waitamo
./winspew -t "Window",normal,,fullscreen -c "Dialog",300x200,no_title >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window"; waitamo
./winspew -t "Window",normal >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with several dialogs"; waitamo
./winspew -t "Window",normal -c "Dialog",320x220 -c "Dialog",400x300 -c "Dialog",300x200 >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with dialog with help/accept buttons"; waitamo
./winspew -t "Window",normal -c "Dialog",320x200,accept_button:help_button >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with several modal dialogs"; waitamo
./winspew -t "Window",normal -c "Dialog",320x220,modal -c "Dialog",400x300,modal -c "Dialog",300x200,modal >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with no-title dialog"; waitamo
./winspew -t "Window",normal -c "Dialog",300x200,no_title >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

echo; echo "$count. Normal window with no-decor dialog"; waitamo
./winspew -t "Window",normal -c "Dialog",300x200,no_decor >> $LOG &
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))


if [ \! -z "$(locale -a|grep 'zh_CN.utf8')" ]; then

echo; echo "$count. Normal window and dialog with UTF8 Chinese title."; waitamo
./winspew -t zh_CN.utf8,normal -t zh_CN.utf8,dialog >> $LOG & 
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

else
echo "*** Not testing Chinese titles as C-library support is missing ***"
fi

if [ \! -z "$(pango-querymodules|grep 'pango-arabic')" ]; then

echo; echo "$count. Normal window with UTF8 Arabic title."; waitamo
./winspew -t ar_AE.utf8,normal -t ar_AE.utf8,dialog >> $LOG &  
TEST=$!; waitamo; kill $TEST; wait; count=$((count+1))

else
echo "*** Not testing Arabic titles as Pango support is missing ***"
fi


echo
echo "$count tests done!"
echo
echo "Winspew test program outputs were logged into file '$LOG'."

# test never really fails
exit 0
