/* This file is part of
 * ======================================================
 *
 *           LyX, The Document Processor
 *
 *           Copyright 1995 Matthias Ettrich
 *           Copyright 1995-2001 The LyX Team.
 *
 * ====================================================== */

#include <config.h>

#ifdef HAVE_LOCALE_H
#  include <locale.h>
#endif

#include "LString.h"

#include <boost/scoped_array.hpp>

#ifdef ENABLE_NLS

#  if HAVE_GETTEXT
#    include <libintl.h>      // use the header already in the system *EK*
#  else
#    include "../intl/libintl.h"
#  endif

char const * _(char const * str)
{
	// I'd rather have an Assert on str, we should not allow
	// null pointers here. Lgb
	// Assert(str);
	if (str && str[0])
		return gettext(str);
	else
		return "";
}


string const _(string const & str)
{
	if (!str.empty()) {
		int const s = str.length();
		boost::scoped_array<char> tmp(new char[s + 1]);
		str.copy(tmp.get(), s);
		tmp[s] = '\0';
		string const ret(gettext(tmp.get()));
		return ret;
	} else {
		return string();
	}
}


void locale_init()
{
#  ifdef HAVE_LC_MESSAGES
	setlocale(LC_MESSAGES, "");
#  endif
	setlocale(LC_CTYPE, "");
	setlocale(LC_NUMERIC, "C");
}


void gettext_init(string const & localedir)
{
	bindtextdomain(PACKAGE, localedir.c_str());
	textdomain(PACKAGE);
}


#else // ENABLE_NLS

void locale_init()
{
	setlocale(LC_NUMERIC, "C");
}


void gettext_init(string const &)
{
}
#endif
