// -*- C++ -*-
/**
 * \file GError.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Michael Koziarski
 * \author Baruch Even
 *
 * Full author contact details are available in file CREDITS
 */

#ifndef GERROR_H
#define GERROR_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlError.h"
#include "GnomeBase.h"

namespace Gtk {

class Button;
class TextView;

}

/**
 * This class implements the dialog to show error messages.
 */
class GErrorDialog : public GnomeCB<ControlError> {
public:
	///
	GErrorDialog(ControlError & c);
	///
	~GErrorDialog() {}
	///
	void apply() {}
	///
	void update();

private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const { return true; }

	///
	void CloseClicked() { CancelButton(); }

	/// generated by accessors.py
	Gtk::Button * button_close() const;
	/// generated by accessors.py
	Gtk::TextView * textarea() const;
};

#endif
