/* 
 * Copyright (C) Jim Zajkowski <jamesez@umich.edu> (package maintainer)
 * Copyright (C) Chris Lahey <clahey@umich.edu> (original author)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * This code was taken from the Winnov Videum V4L2 driver, by Bill Dirks
 * <bdirks@pacbell.net>.  His notice follows,
 */


/*	WNVWAVI.H
 *	These are all the Winnov WAVI chip registers, register bits,
 *	register fields, etc.
 */
/*	Winnov Videum
 *	Video for Linux driver
 *
 *	This program is copyright 1998
 *	by Bill Dirks
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 */

#define WAVI_BOARD0CONFIG	0x5A04
#define WAVI_BOARD1CONFIG	0x5A05

#define WAVI_REMOTEBOARD0CONFIG    0x7A04
#define WAVI_REMOTEBOARD1CONFIG    0x7A05
#define WAVI_PCICONFIG0      0x00D8
#define WAVI_PCICONFIG1      0x00D9

#define WAVI_PORTDESELECT	0x0000
#define WAVI_PORT1SELECT	0x0001
#define WAVI_PORT2SELECT	0x0002
#define WAVI_PORT3SELECT	0x0003

#define WAVI_PORT0SELECTMEDIAPLUG        0x16
#define WAVI_PORT1SELECTMEDIAPLUG        0x15
#define WAVI_PORT2SELECTMEDIAPLUG        0x14
#define WAVI_PORT3SELECTMEDIAPLUG        0x12
#define WAVI_PORT4SELECTMEDIAPLUG        0x11
#define WAVI_PORT5SELECTMEDIAPLUG        0x10

#define WAVI_ADLIB		0x0040
#define WAVI_BOARD0PORTDESELECT	0xFFFF
#define WAVI_BOARD0PORT1	0x0160
#define WAVI_BOARD0PORT2	0x0150
#define WAVI_BOARD0PORT3	0x0140
#define WAVI_BOARD1PORT1	0x0120
#define WAVI_BOARD1PORT2	0x0110
#define WAVI_BOARD1PORT3	0x0100

#if 0
#define CPB_HEADER		0
#define CPB_AUDPTR		1
#define CPB_AUDATTN		2
#define CPB_AUDGAIN		3
#define CPB_AUDMIX1		4
#define CPB_AUDMIX2		5
#define CPB_6			6
#define CPB_7			7
#define CPB_VID1PTR		8
#define CPB_VID2PTR		9
#define CPB_RLDPTR1		10
#define CPB_RLDPTR2		11
#define CPB_SPLPTR		12
#define CPB_D			13
#define CPB_E			14
#define CPB_DEFAULT		15
#endif


// Media Plug Local registers
#define WAVI_CMD		0
 #define MP_RESET_HW		0		// remote
 #define MP_END_STREAM		1
 #define MP_WRITE_REG		2
 #define MP_READ_REG		3
 #define MP_WRITE_STREAM	4
 #define MP_READ_STREAM		7
 // read
 #define MP_TIMEOUT		0x4000
 #define MP_DIRTY		0x8000
//void mpCommand(WORD wCommand);

#define WAVI_LCMD		2
 #define MP_WATCHDOG_DISABLE	1
 #define MP_REMOTE_POWER	2
 #define MP_CABLE_CLOCK         4
 #define MP_CHIP_CLOCK		8
 // read
 #define MP_CABLE_DETECT	0x80

#define WAVI_DATA		4

/*
 *	WAVI registers, index numbers passed to the register access functions
 */
#define WAVI_HST1PTR		0
#define WAVI_HST2PTR		1
#define WAVI_SPLPTR		2
#define WAVI_AUDPTR		3
#define WAVI_VID1PTR		4
#define WAVI_MXRPTR		5
#define WAVI_VID2PTR		6
#define WAVI_MXWPTR		7
#define WAVI_HST1DAT		8
#define WAVI_HST2DAT		9
#define WAVI_RLDPTR1		10
#define WAVI_RLDPTR2		11
#define WAVI_MMA		12
#define WAVI_CTL		13
#define WAVI_CTL1		13
#define WAVI_ISR		14
#define WAVI_ITR		15
#define WAVI_ATTN		16
#define WAVI_GAIN		17
#define WAVI_FREQ		18
#define WAVI_4C00		19
#define WAVI_AUDMIX1		20
#define WAVI_AUDMIX2		21
#define WAVI_5800		22
#define WAVI_5C00		23
#define WAVI_VOF		24
#define WAVI_VCT		25
#define WAVI_6800		26
#define WAVI_CTL2		26
#define WAVI_6C00		27
// #define WAVI_CTLL		28
#define WAVI_PTRB		28
#define WAVI_7400		29
#define WAVI_MBNK		29
#define WAVI_HWI2C		30
#define WAVI_TSTMODE		31

/*  Convert register number to offset, whatever	*/
#define ISAOFFSET(reg)		((reg)<<10)
#define PNPOFFSET(reg)		((reg)<<2)
#define MPOFFSET(reg)		((reg)<<3)	// in CMD reg

/*  Reload pointer register IDs	*/
#define WAVI_RP_SPLPTR		2
#define WAVI_RP_VID1PTR		4
#define WAVI_RP_VID2PTR		6

/* MMA Register	*/
#define WAVI_NWDBIT		0x8000  /* NOWS Write Disable */
#define WAVI_NRDBIT		0x4000  /* NOWS Read Disable */
#define WAVI_MMAFIELD		0x3E00  /* Memory Map Address */
#define WAVI_MMEBIT		0x0100  /* Memory Map Enable */
#define WAVI_FMFIELD		0x00C0  /* FM config, Read only */
#define WAVI_DSSFIELD		0x0030  /* Disney Sound Source config, Read Only */
#define WAVI_CVXFIELD		0x000C  /* CoVoX speech thing config, Read Only */
#define WAVI_REVFIELD		0x0003  /* WAVIA ASIC Revision, Read Only */

#define WAVI_AVGCENBIT	    0x8000  /* W97 and later: Average Chroma Enable */
#define WAVI_AUDXSEL_INT97  0x4000  /* W97: Crystal selection is internal (using IMI bit) */
#define WAVI_AUDXSEL	    0x4000  /* WIMP: Crystal selection (replaces IMI bit) */
#define WAVI_CS4218BIT	    0x2000  /* W97 and later: 4218 codec configuration */
#define WAVI_SAA7110	    0x1000  /* W97 and later: select SAA7110 or vpx! */
#define WAVI_BANKCS	    0x0800  /* W97 and later: to enable the memory chip select */
#define WAVI_DHYYY	    0x0400  /* W97 and later: Luma only Delta Huffman */
#define WAVI_DHRES	    0x0200  /* W97 and later: Delta Huffman Residual alogorithm */
#define WAVI_DHRND	    0x0100  /* W97 and later: Delta Huffman Rounding algorithm */
#define WAVI_MEDREN	    0x0080  /* W97 and later: Median Filter Return Effect */
#define WAVI_VIDVCI	    0x0040  /* W97 and later: DVCI video format */
#define WAVI_VERSIONFIELD   0x0030  /* W95 and later: Read Only Version */
#define WAVI_WAVIIDFIELD    0x000F  /* All Versions: WAVI ASIC Revision, Read Only */
#define WAVI_FULLID	    0x003F  /* completely identify the chip version...  W95 and above! */

#define WAVI_WAVI1           0x0002  /* The original Samsung */
#define WAVI_WAVI95          0x0012  /* Hundai part with line avg during Huffman*/
#define WAVI_WAVI97          0x0022
#define WAVI_WIMP            0x0003

/* CTL Register	*/
#define WAVI_VSEBIT	  	0x8000  /* Video Sampler Enable */
#define WAVI_VSTBIT	  	0x4000  /* Video Status */
#define WAVI_VSSBIT	  	0x2000  /* Video Source Select */
#define WAVI_VSCBIT	  	0x1000  /* Video Source Component(1)/Composite(0) */
#define WAVI_RGBBIT	  	0x0800  /* RGB(1)/YUV(0) Video Space */
#define WAVI_VFSFIELD	 	0x0700  /* Video Filter Select */
#define WAVI_VFS_NONE		0x0000  /* Bypass filters */
#define WAVI_VFS_MED3		0x0100  /* 3 tap median filter */
#define WAVI_VFS_FIR2		0x0200  /* 2 pix FIR filter */
#define WAVI_VFS_BOTH2		0x0300  /* Median and 2 pix FIR */
#define WAVI_VFS_FIR4		0x0400  /* 4 pix FIR filter */
#define WAVI_VFS_BOTH4		0x0500  /* Median and 4 pix FIR */
#define WAVI_VFS_FIR8		0x0600  /* 8 pix FIR filter */
#define WAVI_VFS_BOTH8		0x0700  /* Median and 8 pix FIR filter */
#define WAVI_VDFFIELD		0x00E0  /* Video Data Capture Format */
#define WAVI_VDF_DYCQ		0x0000  /* DYCQ */
#define WAVI_VDF_YCQ		0x0020  /* YCQ */
#define WAVI_VDF_YCH		0x0040  /* YCH */
#define WAVI_VDF_RGB		0x0060  /* RGB */
#define WAVI_VDF_DH4		0x0080  /* DH4 */
#define WAVI_VDF_DH5		0x00A0  /* DH5 */
#define WAVI_VDF_DH6		0x00C0  /* DH6 */
#define WAVI_VDF_DH7		0x00E0  /* DH7 */
#define WAVI_CTLBIT4		0x0010  /* not used */
#define WAVI_I2CBIT		0x0008  /* I2C Bus Clock */
#define WAVI_IMIBIT		0x0004  /* IM-Bus Identify */
#define WAVI_IMCBIT		0x0002  /* IM-Bus Clock */
#define WAVI_IMDBIT		0x0001  /* IM-Bus Data */

/* ISR/ITR	*/
#define WAVI_VIEBIT	  	0x8000  /* Video Interrupt Enable */
#define WAVI_VI2BIT	  	0x4000  /* Video Interrupt 2, Read Only */
#define WAVI_VI1BIT	  	0x2000  /* Video Interrupt 1, Read Only */
#define WAVI_AIEBIT	  	0x1000  /* Audio Interrupt Enable */
#define WAVI_AISFIELD	 	0x0C00  /* Audio Interrupt Status, Read Only	*/
#define WAVI_AISFIELD_NOINT	0x0000  /* no audio interrupt */
#define WAVI_AISFIELD_1INT	0x0400  /* one audio interrupt */
#define WAVI_AISFIELD_OVERRUN	0x0800	/* audio overrun */
#define WAVI_AISFIELD_2INT	0x0C00  /* two audio interrupts */
#define WAVI_FIEBIT		0x0200  /* FM Interrupt Enable */
#define WAVI_FMIBIT		0x0100  /* FM Interrupt, Read Only */
#define WAVI_SIEBIT		0x0080  /* SCSI Interrupt Enable */
#define WAVI_SCIBIT		0x0040  /* SCSI Controller Interrupt, Read Only */
#define WAVI_CIEBIT		0x0020  /* Control-L Interrupt Enable */
#define WAVI_CLIBIT		0x0010  /* Control-L Interrupt, Read Only */
#define WAVI_IDTBIT		0x0008  /* Interrupt Detect, Read Only */
#define WAVI_ITMBIT		WAVI_IDTBIT	/* Interrupt test mode, Write Only */
#define WAVI_ISELFIELD		0x0007  /* Interrupt Select */
#define WAVI_ISELFIELD_NONE	0x0000  /* Interrupts disconnected */
#define WAVI_ISELFIELD_IRQ2	0x0001  /* IRQ2 */
#define WAVI_ISELFIELD_IRQ5	0x0002  /* IRQ5 was reversed with 7*/
#define WAVI_ISELFIELD_IRQ7	0x0003  /* IRQ7 was reversed with 5 */
#define WAVI_ISELFIELD_IRQ10	0x0004  /* IRQ10*/
#define WAVI_ISELFIELD_IRQ11	0x0005  /* IRQ11*/
#define WAVI_ISELFIELD_IRQ12	0x0006  /* IRQ12*/
#define WAVI_ISELFIELD_IRQ15	0x0007  /* IRQ15*/

/* Audio ATTN	*/
#define ATTN_MASK_ASCO		0x0FFF  /* mask of useable bits for ASCO */
#define ATTN_MASK_4218		0x3FFF  /* 4218 mask of useable bits */
#define WAVI_ATTLFFIELD		0x0F00  /* Left Output Channel Attenuation, Write Only */
#define WAVI_ATTRTFIELD		0x00F0  /* Right Output Channel Attenuation, Write Only */
// 4218 format of the upper 12 bits:
#define WAVI_4218_ATTLFFIELD 	0x3E00  /* 4218: 5 bit Left Output Channel Attenuation */
#define WAVI_4218_ATTRTFIELD	0x01F0  /* 4218: 5 bit Right Output Channel Attenuation */

// common between 4216 and 4218
#define WAVI_ASS2FIELD		0x000C  /* Audio Source Select, Write Only */
#define WAVI_ASS2FIELD_VID1	0x0000
#define WAVI_ASS2FIELD_MIC	0x0004
#define WAVI_ASS2FIELD_VID2	0x0008
#define WAVI_ASS2FIELD_LINE	0x000C

#define WAVI_AFSBIT		0x0002  /* Audio freq select (SPAM only) 0=22.5792,1=24.576 */
#define WAVI_AXEBIT		0x0001  /* Audio expansion enable */

/* Audio GAIN	*/
#define WAVI_MUTBIT		0x0400  /* Mute, Write Only */
#define WAVI_ISLBIT		0x0200  /* Input Select Left channel, Write Only */
			    		/* 0=LIN1, 1=IN2 (ASS2) */
#define WAVI_ISRBIT		0x0100  /* Input Select Right channel, Write Only */
			    		/* 0=LIN1, 1=IN2 (ASS2) */
#define WAVI_GAINLFFIELD	0x00F0  /* Left Input Channel Gain, Write Only */
#define WAVI_GAINRTFIELD	0x000F  /* Right Input Channel Gain, Write Only */

/* Audio FREQ	*/
#define WAVI_AOVFIELD		0xFF00  /* Audio Output Volume */
#define WAVI_ACEBIT		0x0080  /* Audio Converter Enable */
#define WAVI_APEBIT		0x0040  /* Audio Phase Error */
#define WAVI_AMSBIT		0x0020  /* Audio Mode Stereo */
#define WAVI_ADDBIT		0x0010  /* Audio Digital Port Data */
#define WAVI_FREQFIELD		0x000F  /* Audio Frequency */
#define WAVI_FREQFIELD_44100	0x0001
#define WAVI_FREQFIELD_29400	0x0002
#define WAVI_FREQFIELD_22050	0x0003
#define WAVI_FREQFIELD_14700	0x0005
#define WAVI_FREQFIELD_11025	0x0007
#define WAVI_FREQFIELD_08820	0x0009
#define WAVI_FREQFIELD_07350	0x000B

/* Audio MIX 1/2	*/
#define WAVI_MIXRFIELD		0xFF00  /* Right channel output volume */
#define WAVI_MIXLFIELD		0x00FF  /* Left channel output volume */

/* Video Offset	*/
#define WAVI_VOFCRFIELD		0xF000  /* Video Offset Chroma Red */
#define WAVI_VOFCBFIELD		0x0F00  /* Video Offset Chroma Blue */
#define WAVI_VOFYFIELD		0x00F0  /* Video Offset Luma */
#define WAVI_GBCBIT		0x0008  /* Video Input Gray to Binary on Chroma */
#define WAVI_GBYBIT		0x0004  /* Video Input Gray to Binary on Luma */
#define WAVI_VSPBIT		0x0002  /* Video Input VSP Enable */
#define WAVI_VSDBIT		0x0001  /* Video Input VSD Detect, Read Only */
#define WAVI_IFMTBITS		(WAVI_GBCBIT|WAVI_GBYBIT|WAVI_VSPBIT|WAVI_VSDBIT)

/* Video Contrast Reg	*/
#define WAVI_VCTCRFIELD		0xF000  /* Cr contrast */
#define WAVI_VCTCBFIELD		0x0F00  /* Cb Contrast */
#define WAVI_VCTYFIELD		0x00F0  /* Y Contrast */
#define WAVI_VHSDFIELD		0x000F  /* Video Horizontal Synch Delay */

/* Control-L Reg	*/
#define WAVI_STRBIT		0x8000  /* Control-L Start bit */
#define WAVI_TRGBIT		0x4000  /* Control-L Trigger Send */
#define WAVI_ARMBIT		0x2000  /* Control-L Armed, Read Only */
#define WAVI_VVSBIT		0x1000  /* Video Vert Synch, Read Only */
#define WAVI_CLDBIT		0x0800  /* Control-L Direct Data */
#define WAVI_E2BIT		0x0400  /* TBD */
#define WAVI_E1BIT		0x0200  /* TBD */
#define WAVI_E0BIT		0x0100  /* TBD */
#define WAVI_CLDATA		0x00FF  /* Control L Data */

#define WAVI_AUDBUFSIZE		0x2000L	/* size of audio buffer in bytes */

/* CTL2 registers. */

#define WAVI_CCLK_EN            0x8000
#define WAVI_VCLK_INV           0x4000
#define WAVI_DPLL_EN            0x2000
#define WAVI_VCPHASE            0x1000
#define WAVI_VCLK_EN            0x0C00
#define WAVI_VCLK_EN_GND        0x0C00
#define WAVI_VCLK_EN_MOV2       0x0400
#define WAVI_VCLK_EN_VEXT       0x0800
#define WAVI_VCLK_EN_MCLK       0x0C00
#define WAVI_MCLK_EN            0x0300
#define WAVI_MCLK_EN_GND        0x0300
#define WAVI_MCLK_EN_GND2       0x0000
#define WAVI_MCLK_EN_COV2       0x0100
#define WAVI_MCLK_EN_AUD        0x0200
#define WAVI_MCLK_EN_CCLK       0x0300
#define WAVI_GPIO2_OE           0x0080
#define WAVI_GPIO1_OE           0x0040
#define WAVI_GPIO0_OE           0x0020
#define WAVI_GPIO4              0x0010
#define WAVI_GPIO3              0x0008
#define WAVI_GPIO2              0x0004
#define WAVI_GPIO1              0x0002
#define WAVI_GPIO0              0x0001

/*  CMD0647 private configuration registers	*/
#define CMD_CONFIG_CNTRL	0x51
#define CMD_CONFIG_CMDTIM	0x52
#define CMD_CONFIG_ARTTIM0	0x53
#define CMD_CONFIG_DRWTIM0	0x54
#define CMD_CONFIG_ARTTIM1	0x55
#define CMD_CONFIG_DRWTIM1	0x56
#define CMD_CONFIG_ARTTIM23	0x57
#define CMD_CONFIG_DRWTIM2	0x58
#define CMD_CONFIG_DRWTIM3	0x5B

#define UI_DECIMATE_LOWPREC(decimation,clocks)  \
        (((decimation-1)<<10)|(((clocks-1)&3)<<8)|(((clocks-1)>>2)&255))
#define UI_SKIP_LOWPREC(clocks)(UI_DECIMATE_LOWPREC(1,clocks))
#define UI_RVP1         0xF0
#define UI_RVP2         0xF1
#define UI_ITR1         0xF2
#define UI_ITR2         0xF3
#define UI_RVS          0xF4
#define UI_SVS          0xF5
#define UI_SIM          0xF6
#define UI_SVM          0xF7
#define UI_NOP          0xF8
#define UI_WTHS         0xF9
#define UI_WTVA         0xFA
#define UI_WTVB         0xFB
#define UI_WTVF1        0xFC
#define UI_WTVF2        0xFD
#define UI_WTX          0xFE
#define UI_HLT          0xFF


/*  ISA Plug-and-Play ioports */

#define READPORT(rp) ((rp << 2) | 0x03)

//defines
#define  ADDRESS_PORT  		0x279
#define  WRITE_DATA_PORT 	0xa79
#define  RD_DATA		0x00
#define  SERIAL_ISOLATION 	0x01
#define  CONFIG_CONTROL 	0x02
#define		RESET_CSN 	0x4
#define     GOTO_WAIT_FOR_KEY 	0x02
#define     RESET_TO_POWER_UP 	0x01
#define  WAKE 			0x03
#define  RESOURCE_DATA 		0x04
#define  STATUS 		0x05
#define  CSN 			0x06
#define  LOGICAL_DEVICE_NUMBER 	0x07
#define  ACTIVATE 		0x30
#define  IO_RANGE_CHECK 	0x31
#define  MEM_BASEH 		0x40
#define  MEM_BASEL 		0x41
#define  MEM_CTL 		0x42
#define  MEM_LENGTHH 		0x43
#define  MEM_LENGTHL 		0x44
#define  MEM_DESC_INCREMENT 	0x8
#define	 MEM32_BASEHH 		0x76
#define  MEM32_BASEHL 		0x77
#define  MEM32_BASELH 		0x78
#define  MEM32_BASELL 		0x79
#define  MEM32_CTL 		0x7A
#define  MEM32_LENGTHHH 	0x7B
#define  MEM32_LENGTHHL 	0x7C
#define  MEM32_LENGTHLH 	0x7D
#define  MEM32_LENGTHLL 	0x7E
#define  MEM32_DESC_INCREMENT 	0x10
#define  IO_BASEH 		0x60
#define  IO_BASEL 		0x61
#define  IO_DESC_INCREMENT 	0x2
#define  INT_LEVEL 		0x70
#define  INT_TYPE 		0x71
#define  INT_DESC_INCREMENT 	0x2
#define  DMA_SELECT_0 		0x74
#define  DMA_SELECT_1 		0x75

#define  MAX_READPORT 0xA0  // higher base address key!
#define  WINNOV_MFG_ID "WNV"    
#define  WINNOV_PNP_VIDEUM1_ID "WNV0001"
#define  WINNOV_PNP_HUMP1_ID "WNV0002"

//PNP board types!
#define PNP_BOARD_NOT_PNP 0                 
#define PNP_BOARD_PCMCIA 1 
#define PNP_BOARD_VIDEUM1 2
#define PNP_BOARD_LEG_MEDIAPLUG 3
#define PNP_BOARD_CIRRUS1 4 
#define PNP_BOARD_VIDEUM_PCI_IDE 5 
#define PNP_BOARD_MEDIAPLUG_PCI_IDE	6

#define CS7615_ADDRESS0        0x68
#define CS7615_ADDRESS1        0xA8
#define CS7665_ADDRESS         0x34
#define CS7665_VERSION_REG     0x1C


#define  PNP_MAX_BOARDS 10

/* Passed to pnp_assignresources() */
typedef struct 
{
	u16	wBasePort[8];
	u16	wLength[8];
} RES_INFO;

typedef struct 
{
	char ID[10];
	u32  dwHWIndex;                
	u32  dwDevIndex;
	u16  wStartAddress;
	u16  wEndAddress;
	u16  wLength;   
	u16  wIncrement;
	u32  fRangeCheck;
} PNP_INFO;
