#ifndef _LINUX_SWAPCTL_H
#define _LINUX_SWAPCTL_H

typedef struct pager_daemon_v1
{
	unsigned int	tries_base;
	unsigned int	tries_min;
	unsigned int	swap_cluster;
} pager_daemon_v1;
typedef pager_daemon_v1 pager_daemon_t;
extern pager_daemon_t pager_daemon;

#ifdef CONFIG_FREEPG_SIGNAL
typedef struct {
	char comm[16];          /* signal recipient process name */
	unsigned int low;       /* once under this number of pages, memory
                                 * is low */
	unsigned int mid;       /* once under this number of pages, memory
                                 * smacks of shortage */
	unsigned int high;      /* once over this number of pages, memory is
                                 * enough */
	unsigned int cur;       /* current freepages */
} freepg_signal_watermark_t;
extern freepg_signal_watermark_t freepg_sig_watermark;

typedef struct {
	int cur_level;		/* 0: normal, 1: warning, 2: critical */
	int cur_avail;		/* current available pages */
	int min_avail;		/* minimum available pages.
				 * Signal is never sent unless available
				 * memory is less than min_avail. */
	unsigned long lasttick;	/* last-sent time */
} freepg_sig_t;
extern freepg_sig_t freepg_sig;
#endif

#endif /* _LINUX_SWAPCTL_H */
