/*
 *  linux/include/asm-arm/arch-dm310/io.h
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#define __io(a)			((a) + DM310_IO_VOFFS)
#define IOW(a)			(*(volatile unsigned short *)__io(a))
#define IOB(a)			(*(volatile unsigned char *)__io(a))

/*
 * Generic virtual read/write
 */

#define __arch_getb(a)		(*(volatile unsigned char *)(a))
#define __arch_putb(v,a)	(*(volatile unsigned char *)(a) = (v))
#define __arch_getw(a)		(*(volatile unsigned short *)(a))
#define __arch_putw(v,a)	(*(volatile unsigned short *)(a) = (v))
//#define __arch_getl(a)		(*(volatile unsigned long *)(a))
//#define __arch_putl(v,a)	(*(volatile unsigned long *)(a) = (v))

#define readb(a) 		__arch_getb(a)
#define writeb(v,a) 		__arch_putb(v,a)
#define readw(a) 		__arch_getw(a)
#define writew(v,a) 		__arch_putw(v,a)
#define readl(a) 		(*(volatile unsigned long *)(a))
#define writel(v,a) 		(*(volatile unsigned long *)(a) = (v))

/*
 * Validate the pci memory address for ioremap.
 */
#define iomem_valid_addr(iomem,size)	(1)

/*
 * Convert PCI memory space to a CPU physical address
 */
#define iomem_to_phys(iomem)	(iomem)

#endif
