typedef struct _SiS310_StStruct
{
	UCHAR St_ModeID;
	USHORT St_ModeFlag;
	UCHAR St_StTableIndex;
	UCHAR St_CRT2CRTC;
	UCHAR St_ResInfo;
	UCHAR VB_StTVFlickerIndex;
	UCHAR VB_StTVEdgeIndex;
	UCHAR VB_StTVYFilterIndex;
} SiS310_StStruct;

SiS310_StStruct SiS310_SModeIDTable[]=
{
	{0x01,0x9208,0x01,0x00,0x00,0x00,0x01,0x00},
	{0x01,0x1210,0x14,0x01,0x01,0x00,0x01,0x00},
	{0x01,0x1010,0x17,0x02,0x02,0x00,0x01,0x01},
	{0x03,0x8208,0x03,0x00,0x00,0x00,0x01,0x02},
	{0x03,0x0210,0x16,0x01,0x01,0x00,0x01,0x02},
	{0x03,0x0010,0x18,0x02,0x02,0x00,0x01,0x03},
	{0x05,0x9209,0x05,0x00,0x00,0x00,0x00,0x04},
	{0x06,0x8209,0x06,0x00,0x00,0x00,0x00,0x05},
	{0x07,0x0000,0x07,0x03,0x03,0x00,0x01,0x03},
	{0x07,0x0000,0x19,0x02,0x02,0x00,0x01,0x03},
	{0x0d,0x920a,0x0d,0x00,0x00,0x00,0x00,0x04},
	{0x0e,0x820a,0x0e,0x00,0x00,0x00,0x00,0x05},
	{0x0f,0x0202,0x11,0x01,0x01,0x00,0x00,0x05},
	{0x10,0x0212,0x12,0x01,0x01,0x00,0x00,0x05},
	{0x11,0x0212,0x1a,0x04,0x04,0x00,0x00,0x05},
	{0x12,0x0212,0x1b,0x04,0x04,0x00,0x00,0x05},
	{0x13,0x021b,0x1c,0x00,0x00,0x00,0x00,0x04},
	{0x12,0x0010,0x18,0x02,0x02,0x00,0x00,0x05},
	{0x12,0x0210,0x18,0x01,0x01,0x00,0x00,0x05},
	{0xff,0x0000,0x00,0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS310_StandTableStruct
{
	UCHAR CRT_COLS;
	UCHAR ROWS;
	UCHAR CHAR_HEIGHT;
	USHORT CRT_LEN;
	UCHAR SR[4];
	UCHAR MISC;
	UCHAR CRTC[0x19];
	UCHAR ATTR[0x14];
	UCHAR GRC[9];
} SiS310_StandTableStruct;

SiS310_StandTableStruct SiS310_StandTable[]=
{
/* MD_0_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_1_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_2_200 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_3_200 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_4 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* MD_5 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* MD_6 */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x01,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xc2,
   0xff},
  {0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x01,0x00,0x01,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0x00,
   0xff}
 },
/* MD_7 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x00,0x03,0x00,0x03},
  0xa6,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0d,0x63,0xba,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* MDA_DAC */
 {
  0x00,0x00,0x00,0x0000,
  {0x00,0x00,0x00,0x15},
  0x15,
  {0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x00,0x00,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15},
  {0x15,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f}
 },
/* CGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x00},
  0x10,
  {0x04,0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x10,
   0x04},
  {0x14,0x01,0x11,0x09,0x15,0x00,0x10,0x04,
   0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,0x2e,
   0x3e,0x2b,0x3b,0x2f},
  {0x3f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* EGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x05,0x15,0x20},
  0x30,
  {0x24,0x34,0x21,0x31,0x25,0x35,0x08,0x18,
   0x0c,0x1c,0x09,0x19,0x0d,0x1d,0x28,0x38,
   0x2c,0x3c,0x29,0x39,0x2d,0x3d,0x02,0x12,
   0x06},
  {0x16,0x03,0x13,0x07,0x17,0x22,0x32,0x26,
   0x36,0x23,0x33,0x27,0x37,0x0a,0x1a,0x0e,
   0x1e,0x0b,0x1b,0x0f},
  {0x1f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* VGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x2a},
  0x3a,
  {0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x05,
   0x08,0x0b,0x0e,0x11,0x14,0x18,0x1c,0x20,
   0x24,0x28,0x2d,0x32,0x38,0x3f,0x00,0x10,
   0x1f},
  {0x2f,0x3f,0x1f,0x27,0x2f,0x37,0x3f,0x2d,
   0x31,0x36,0x3a,0x3f,0x00,0x07,0x0e,0x15,
   0x1c,0x0e,0x11,0x15},
  {0x18,0x1c,0x14,0x16,0x18,0x1a,0x1c,0x00,
   0x04}
 },
 {
  0x08,0x0c,0x10,0x0a08,
  {0x0c,0x0e,0x10,0x0b},
  0x0c,
  {0x0d,0x0f,0x10,0x10,0x01,0x08,0x00,0x00,
   0x00,0x00,0x01,0x00,0x02,0x02,0x01,0x00,
   0x04,0x04,0x01,0x00,0x05,0x02,0x05,0x00,
   0x06},
  {0x01,0x06,0x05,0x06,0x00,0x08,0x01,0x08,
   0x00,0x07,0x02,0x07,0x06,0x07,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* MD_D */
 {
  0x28,0x18,0x08,0x2000,
  {0x09,0x0f,0x00,0x06},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* MD_E */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x0f,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* ExtVGATable */
 {
  0x00,0x00,0x00,0x0000,
  {0x01,0x0f,0x00,0x0e},
  0x23,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x01,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 },
/* ROM_SAVEPTR */
 {
  0x9f,0x3b,0x00,0x00c0,
  {0x00,0x00,0x00,0x00},
  0x00,
  {0x00,0x00,0x00,0x00,0x00,0x00,0xbb,0x3f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x1a,0x00,0xac,0x3e,0x00,0xc0,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* MD_F */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa2,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x08,0x00,0x00,0x18,0x18,0x00,0x00,
   0x00,0x08,0x00,0x00,0x00,0x18,0x00,0x00,
   0x0b,0x00,0x05,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,
   0xff}
 },
/* MD_10 */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* MD_0_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_1_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_2_350 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_3_350 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_0_1_400 */
 {
  0x28,0x18,0x10,0x0800,
  {0x08,0x03,0x00,0x02},
  0x67,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_2_3_400 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x67,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* MD_7_400 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x66,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x0f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* MD_11 */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xc3,
   0xff},
  {0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,
   0xff}
 },
/* ExtEGATable */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* MD_13 */
 {
  0x28,0x18,0x08,0x2000,
  {0x01,0x0f,0x00,0x0e},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x40,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x41,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 }
};

typedef struct _SiS310_ExtStruct
{
	UCHAR Ext_ModeID;
	USHORT Ext_ModeFlag;
	USHORT Ext_ModeInfo;
	USHORT Ext_Point;
	USHORT Ext_VESAID;
	UCHAR Ext_VESAMEMSize;
	UCHAR Ext_RESINFO;
	UCHAR VB_ExtTVFlickerIndex;
	UCHAR VB_ExtTVEdgeIndex;
	UCHAR VB_ExtTVYFilterIndex;
	UCHAR REFindex;
} SiS310_ExtStruct;

SiS310_ExtStruct  SiS310_EModeIDTable[]=
{
	{0x6a,0x2212,0x0407,0x3a81,0x0102,0x08,0x07,0x00,0x00,0x07,0x00},
	{0x2e,0x0a1b,0x0306,0x3a57,0x0101,0x08,0x06,0x00,0x00,0x05,0x08},
	{0x2f,0x0a1b,0x0305,0x3a50,0x0100,0x08,0x05,0x00,0x00,0x05,0x10},
	{0x30,0x2a1b,0x0407,0x3a81,0x0103,0x08,0x07,0x00,0x00,0x07,0x00},
	{0x31,0x0a1b,0x030d,0x3b85,0x0000,0x08,0x0d,0x00,0x00,0x06,0x11},
	{0x32,0x0a1b,0x0a0e,0x3b8c,0x0000,0x08,0x0e,0x00,0x00,0x06,0x12},
	{0x33,0x0a1d,0x0a0d,0x3b85,0x0000,0x08,0x0d,0x00,0x00,0x06,0x11},
	{0x34,0x2a1d,0x0a0e,0x3b8c,0x0000,0x08,0x0e,0x00,0x00,0x06,0x12},
	{0x35,0x0a1f,0x0a0d,0x3b85,0x0000,0x08,0x0d,0x00,0x00,0x06,0x11},
	{0x36,0x2a1f,0x0a0e,0x3b8c,0x0000,0x08,0x0e,0x00,0x00,0x06,0x12},
	{0x37,0x0212,0x0508,0x3aab,0x0104,0x08,0x08,0x00,0x00,0x00,0x13},
	{0x38,0x0a1b,0x0508,0x3aab,0x0105,0x08,0x08,0x00,0x00,0x00,0x13},
	{0x3a,0x0e3b,0x0609,0x3adc,0x0107,0x08,0x09,0x00,0x00,0x00,0x1a},
	{0x3c,0x063b,0x070a,0x3af2,0x0130,0x08,0x0a,0x00,0x00,0x00,0x1e},
	{0x3d,0x067d,0x070a,0x3af2,0x0131,0x08,0x0a,0x00,0x00,0x00,0x1e},
	{0x40,0x9a1c,0x0000,0x3a34,0x010d,0x08,0x00,0x00,0x00,0x04,0x25},
	{0x41,0x9a1d,0x0000,0x3a34,0x010e,0x08,0x00,0x00,0x00,0x04,0x25},
	{0x43,0x0a1c,0x0306,0x3a57,0x0110,0x08,0x06,0x00,0x00,0x05,0x08},
	{0x44,0x0a1d,0x0306,0x3a57,0x0111,0x08,0x06,0x00,0x00,0x05,0x08},
	{0x46,0x2a1c,0x0407,0x3a81,0x0113,0x08,0x07,0x00,0x00,0x07,0x00},
	{0x47,0x2a1d,0x0407,0x3a81,0x0114,0x08,0x07,0x00,0x00,0x07,0x00},
	{0x49,0x0a3c,0x0508,0x3aab,0x0116,0x08,0x08,0x00,0x00,0x00,0x13},
	{0x4a,0x0a3d,0x0508,0x3aab,0x0117,0x08,0x08,0x00,0x00,0x00,0x13},
	{0x4c,0x0e7c,0x0609,0x3adc,0x0119,0x08,0x09,0x00,0x00,0x00,0x1a},
	{0x4d,0x0e7d,0x0609,0x3adc,0x011a,0x08,0x09,0x00,0x00,0x00,0x1a},
	{0x50,0x9a1b,0x0001,0x3a3b,0x0132,0x08,0x01,0x00,0x00,0x04,0x26},
	{0x51,0xba1b,0x0103,0x3a42,0x0133,0x08,0x03,0x00,0x00,0x07,0x27},
	{0x52,0x9a1b,0x0204,0x3a49,0x0134,0x08,0x04,0x00,0x00,0x00,0x28},
	{0x56,0x9a1d,0x0001,0x3a3b,0x0135,0x08,0x01,0x00,0x00,0x04,0x26},
	{0x57,0xba1d,0x0103,0x3a42,0x0136,0x08,0x03,0x00,0x00,0x07,0x27},
	{0x58,0x9a1d,0x0204,0x3a49,0x0137,0x08,0x04,0x00,0x00,0x00,0x28},
	{0x59,0x9a1b,0x0000,0x3a34,0x0138,0x08,0x00,0x00,0x00,0x04,0x25},
	{0x5A,0x021b,0x0014,0x3b83,0x0138,0x08,0x01,0x00,0x00,0x04,0x3f}, /*fstn add new mode*/
	{0x5B,0x0a1d,0x0014,0x3b83,0x0135,0x08,0x01,0x00,0x00,0x04,0x3f}, /*fstn add new mode*/
	{0x5d,0x0a1d,0x0305,0x3a50,0x0139,0x08,0x05,0x00,0x00,0x07,0x10},
	{0x62,0x0a3f,0x0306,0x3a57,0x013a,0x08,0x06,0x00,0x00,0x05,0x08},
	{0x63,0x2a3f,0x0407,0x3a81,0x013b,0x08,0x07,0x00,0x00,0x07,0x00},
	{0x64,0x0a7f,0x0508,0x3aab,0x013c,0x08,0x08,0x00,0x00,0x00,0x13},
	{0x65,0x0eff,0x0609,0x3adc,0x013d,0x08,0x09,0x00,0x00,0x00,0x1a},
	{0x66,0x06ff,0x070a,0x3af2,0x013e,0x08,0x0a,0x00,0x00,0x00,0x1e},
	{0x68,0x067b,0x080b,0x3b17,0x013f,0x08,0x0b,0x00,0x00,0x00,0x29},
	{0x69,0x06fd,0x080b,0x3b17,0x0140,0x08,0x0b,0x00,0x00,0x00,0x29},
	{0x6b,0x07ff,0x080b,0x3b17,0x0141,0x10,0x0b,0x00,0x00,0x00,0x29},
	{0x6c,0x067b,0x090c,0x3b37,0x0000,0x08,0x0c,0x00,0x00,0x00,0x2f},
	{0x6d,0x06fd,0x090c,0x3b37,0x0000,0x10,0x0c,0x00,0x00,0x00,0x2f},
	{0x6e,0x07ff,0x090c,0x3b37,0x0000,0x10,0x0c,0x00,0x00,0x00,0x2f},
	{0x70,0x2a1b,0x0410,0x3b52,0x0000,0x08,0x10,0x00,0x00,0x07,0x34},
	{0x71,0x0a1b,0x0511,0x3b63,0x0000,0x08,0x11,0x00,0x00,0x00,0x37},
	{0x74,0x0a1d,0x0511,0x3b63,0x0000,0x08,0x11,0x00,0x00,0x00,0x37},
	{0x75,0x0a3d,0x0612,0x3b74,0x0000,0x08,0x12,0x00,0x00,0x00,0x3a},
	{0x76,0x2a1f,0x0410,0x3b52,0x0000,0x08,0x10,0x00,0x00,0x07,0x34},
	{0x77,0x0a1f,0x0511,0x3b63,0x0000,0x08,0x11,0x00,0x00,0x00,0x37},
	{0x78,0x0a3f,0x0612,0x3b74,0x0000,0x08,0x12,0x00,0x00,0x00,0x3a},
	{0x79,0x0a3b,0x0612,0x3b74,0x0000,0x08,0x12,0x00,0x00,0x00,0x3a},
	{0x7a,0x2a1d,0x0410,0x3b52,0x0000,0x08,0x10,0x00,0x00,0x07,0x34},
	{0x7b,0x0e3b,0x060f,0x3ad0,0x0000,0x08,0x0f,0x00,0x00,0x00,0x3d},
	{0x7c,0x0e7d,0x060f,0x3ad0,0x0000,0x08,0x0f,0x00,0x00,0x00,0x3d},
	{0x7d,0x0eff,0x060f,0x3ad0,0x0000,0x08,0x0f,0x00,0x00,0x00,0x3d},
	{0xff,0x0000,0x0000,0x0000,0x0000,0x00,0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS310_Ext2Struct
{
	USHORT Ext_InfoFlag;
	UCHAR Ext_CRT1CRTC;
	UCHAR Ext_CRTVCLK;
	UCHAR Ext_CRT2CRTC;
	UCHAR  ModeID;
	USHORT XRes;
	USHORT YRes;
	USHORT ROM_OFFSET;
} SiS310_Ext2Struct;

SiS310_Ext2Struct SiS310_RefIndex[]=
{
	{0x005f,0x0d,0x03,0x05,0x6a, 800, 600,0x3a81}, /* 0x0 */
	{0x0467,0x0e,0x04,0x05,0x6a, 800, 600,0x3a86}, /* 0x1 */
	{0x0067,0x0f,0x08,0x48,0x6a, 800, 600,0x3a8b}, /* 0x2 */
	{0x0067,0x10,0x07,0x8b,0x6a, 800, 600,0x3a90}, /* 0x3 */
	{0x0147,0x11,0x0a,0x00,0x6a, 800, 600,0x3a95}, /* 0x4 */
	{0x4147,0x12,0x0d,0x00,0x6a, 800, 600,0x3a9a}, /* 0x5 */
	{0x4047,0x13,0x13,0x00,0x6a, 800, 600,0x3a9f}, /* 0x6 */
	{0x4047,0x14,0x1c,0x00,0x6a, 800, 600,0x3aa4}, /* 0x7 */
	{0xc05f,0x05,0x00,0x04,0x2e, 640, 480,0x3a57}, /* 0x8 */
	{0xc067,0x06,0x02,0x04,0x2e, 640, 480,0x3a5c}, /* 0x9 */
	{0xc067,0x07,0x02,0x47,0x2e, 640, 480,0x3a61}, /* 0xa */
	{0xc067,0x08,0x03,0x8a,0x2e, 640, 480,0x3a66}, /* 0xb */
	{0x4047,0x09,0x05,0x00,0x2e, 640, 480,0x3a6b}, /* 0xc */
	{0x4047,0x0a,0x09,0x00,0x2e, 640, 480,0x3a70}, /* 0xd */
	{0x4047,0x0b,0x0e,0x00,0x2e, 640, 480,0x3a75}, /* 0xe */
	{0xc047,0x0c,0x15,0x00,0x2e, 640, 480,0x3a7a}, /* 0xf */
	{0x407f,0x04,0x00,0x00,0x2f, 640, 400,0x3a50}, /* 0x10 */
	{0xc00f,0x3c,0x01,0x06,0x31, 720, 480,0x3b85}, /* 0x11 */
	{0x000f,0x3d,0x03,0x06,0x32, 720, 576,0x3b8c}, /* 0x12 */
	{0x0187,0x15,0x06,0x00,0x37,1024, 768,0x3aab}, /* 0x13 */
	{0xc877,0x16,0x0b,0x06,0x37,1024, 768,0x3ab0}, /* 0x14 301b TV1024x768*/
	{0xc067,0x17,0x0f,0x49,0x37,1024, 768,0x3ab5}, /* 0x15 */
	{0x0267,0x18,0x11,0x00,0x37,1024, 768,0x3aba}, /* 0x16 */
	{0x0047,0x19,0x16,0x8c,0x37,1024, 768,0x3abf}, /* 0x17 */
	{0x4047,0x1a,0x1b,0x00,0x37,1024, 768,0x3ac4}, /* 0x18 */
	{0x4047,0x1b,0x1f,0x00,0x37,1024, 768,0x3ac9}, /* 0x19 */
	{0x0387,0x1c,0x11,0x00,0x3a,1280,1024,0x3adc}, /* 0x1a */
	{0x0077,0x1d,0x19,0x07,0x3a,1280,1024,0x3ae1}, /* 0x1b */
	{0x0047,0x1e,0x1e,0x00,0x3a,1280,1024,0x3ae6}, /* 0x1c */
	{0x0007,0x1f,0x20,0x00,0x3a,1280,1024,0x3aeb}, /* 0x1d */
	{0x0007,0x20,0x21,0x00,0x3c,1600,1200,0x3af2}, /* 0x1e */
	{0x0007,0x21,0x22,0x00,0x3c,1600,1200,0x3af7}, /* 0x1f */
	{0x0007,0x22,0x23,0x00,0x3c,1600,1200,0x3afc}, /* 0x20 */
	{0x0007,0x23,0x25,0x00,0x3c,1600,1200,0x3b01}, /* 0x21 */
	{0x0007,0x24,0x26,0x00,0x3c,1600,1200,0x3b06}, /* 0x22 */
	{0x0007,0x25,0x2c,0x00,0x3c,1600,1200,0x3b0b}, /* 0x23 */
	{0x0007,0x26,0x34,0x00,0x3c,1600,1200,0x3b10}, /* 0x24 */
	{0x407f,0x00,0x00,0x00,0x40, 320, 200,0x3a34}, /* 0x25 */
	{0xc07f,0x01,0x00,0x04,0x50, 320, 240,0x3a3b}, /* 0x26 */
	{0x007f,0x02,0x04,0x05,0x51, 400, 300,0x3a42}, /* 0x27 */
	{0xc077,0x03,0x0b,0x06,0x52, 512, 384,0x3a49}, /* 0x28 */
	{0x8007,0x27,0x27,0x00,0x68,1920,1440,0x3b17}, /* 0x29 */
	{0x4007,0x28,0x29,0x00,0x68,1920,1440,0x3b1c}, /* 0x2a */
	{0x4007,0x29,0x2e,0x00,0x68,1920,1440,0x3b21}, /* 0x2b */
	{0x4007,0x2a,0x30,0x00,0x68,1920,1440,0x3b26}, /* 0x2c */
	{0x4007,0x2b,0x35,0x00,0x68,1920,1440,0x3b2b}, /* 0x2d */
	{0x4005,0x2c,0x39,0x00,0x68,1920,1440,0x3b30}, /* 0x2e */
	{0x4007,0x2d,0x2b,0x00,0x6c,2048,1536,0x3b37}, /* 0x2f */
	{0x4007,0x2e,0x31,0x00,0x6c,2048,1536,0x3b3c}, /* 0x30 */
	{0x4007,0x2f,0x33,0x00,0x6c,2048,1536,0x3b41}, /* 0x31 */
	{0x4007,0x30,0x37,0x00,0x6c,2048,1536,0x3b46}, /* 0x32 */
	{0x4005,0x31,0x38,0x00,0x6c,2048,1536,0x3b4b}, /* 0x33 */
	{0x0057,0x32,0x40,0x08,0x70, 800, 480,0x3b52}, /* 0x34 */
	{0x0047,0x33,0x07,0x08,0x70, 800, 480,0x3b57}, /* 0x35 */
	{0x0047,0x34,0x0a,0x08,0x70, 800, 480,0x3b5c}, /* 0x36 */
	{0x0057,0x35,0x0b,0x09,0x71,1024, 576,0x3b63}, /* 0x37 */
	{0x0047,0x36,0x11,0x09,0x71,1024, 576,0x3b68}, /* 0x38 */
	{0x0047,0x37,0x16,0x09,0x71,1024, 576,0x3b6d}, /* 0x39 */
	{0x0057,0x38,0x19,0x0a,0x75,1280, 720,0x3b74}, /* 0x3a */
	{0x0047,0x39,0x1e,0x0a,0x75,1280, 720,0x3b79}, /* 0x3b */
	{0x0047,0x3a,0x20,0x0a,0x75,1280, 720,0x3b7e}, /* 0x3c */
	{0x0027,0x3b,0x19,0x08,0x7b,1280, 960,0x3ad0}, /* 0x3d */
	{0x0027,0x3b,0x19,0x08,0x7b,1280, 960,0x3ad5}, /* 0x3e */
	{0xc07f,0x01,0x00,0x06,0x5a, 320, 480,0x3b83}, /* 0x3f */    /*fstn add new mode */
	{0xffff,0x00,0x00,0x00,0x00,0000,0000,0x0000}
};

typedef struct _SiS310_CRT1TableStruct
{
 	UCHAR CR[17];
} SiS310_CRT1TableStruct;
SiS310_CRT1TableStruct SiS310_CRT1Table[]=
{
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x00,
  0x00}}, /* 0x0 */
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,
  0x00}}, /* 0x1 */
 {{0x3d,0x31,0x31,0x81,0x37,0x1f,0x72,0xf0,
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x05,
  0x01}}, /* 0x2 */
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
  0x01}}, /* 0x3 */
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x05,
  0x00}}, /* 0x4 */
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}}, /* 0x5 */
 {{0x63,0x4f,0x50,0x86,0x56,0x9b,0x06,0x3e,
  0xe8,0x8b,0xdf,0xe7,0xff,0x10,0x00,0x01,
  0x00}}, /* 0x6 */
 {{0x64,0x4f,0x4f,0x88,0x55,0x9d,0xf2,0x1f,
  0xe0,0x83,0xdf,0xdf,0xf3,0x10,0x00,0x01,
  0x00}}, /* 0x7 */
 {{0x63,0x4f,0x4f,0x87,0x5a,0x81,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,
  0x00}}, /* 0x8 */
 {{0x65,0x4f,0x4f,0x89,0x58,0x80,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x00,0x00,0x05,
  0x61}}, /* 0x9 */
 {{0x65,0x4f,0x4f,0x89,0x58,0x80,0x01,0x3e,
  0xe0,0x83,0xdf,0xdf,0x02,0x00,0x00,0x05,
  0x61}}, /* 0xa */
 {{0x67,0x4f,0x4f,0x8b,0x58,0x81,0x0d,0x3e,
  0xe0,0x83,0xdf,0xdf,0x0e,0x10,0x00,0x05,
  0x61}}, /* 0xb */
 {{0x65,0x4f,0x4f,0x89,0x57,0x9f,0xfb,0x1f,
  0xe6,0x8a,0xe5,0xe5,0xfc,0x00,0x00,0x01,
  0x00}}, /* 0xc */
 {{0x7b,0x63,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
  0x58,0x8a,0x57,0x57,0x70,0x20,0x00,0x05,
  0x01}}, /* 0xd */
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xf0,
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x06,
  0x01}}, /* 0xe */
 {{0x7d,0x63,0x63,0x81,0x6e,0x1d,0x98,0xf0,
  0x7c,0x82,0x57,0x57,0x99,0x00,0x00,0x06,
  0x01}}, /* 0xf */
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xf0,
  0x58,0x8b,0x57,0x57,0x70,0x20,0x00,0x06,
  0x01}}, /* 0x10 */
 {{0x7e,0x63,0x63,0x82,0x6b,0x13,0x75,0xf0,
  0x58,0x8b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}}, /* 0x11 */
 {{0x81,0x63,0x63,0x85,0x6d,0x18,0x7a,0xf0,
  0x58,0x8b,0x57,0x57,0x7b,0x20,0x00,0x06,
  0x61}}, /* 0x12 */
 {{0x83,0x63,0x63,0x87,0x6e,0x19,0x81,0xf0,
  0x58,0x8b,0x57,0x57,0x82,0x20,0x00,0x06,
  0x61}}, /* 0x13 */
 {{0x85,0x63,0x63,0x89,0x6f,0x1a,0x91,0xf0,
  0x58,0x8b,0x57,0x57,0x92,0x20,0x00,0x06,
  0x61}}, /* 0x14 */
 {{0x99,0x7f,0x7f,0x9d,0x84,0x1a,0x96,0x1f,
  0x7f,0x83,0x7f,0x7f,0x97,0x10,0x00,0x02,
  0x00}}, /* 0x15 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}}, /* 0x16 */
 {{0xa1,0x7f,0x7f,0x85,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}}, /* 0x17 */
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf5,
  0x00,0x83,0xff,0xff,0x1f,0x10,0x00,0x02,
  0x01}}, /* 0x18 */
 {{0xa7,0x7f,0x7f,0x8b,0x89,0x95,0x26,0xf5,
  0x00,0x83,0xff,0xff,0x27,0x10,0x00,0x02,
  0x01}}, /* 0x19 */
 {{0xa9,0x7f,0x7f,0x8d,0x8c,0x9a,0x2c,0xf5,
  0x00,0x83,0xff,0xff,0x2d,0x14,0x00,0x02,
  0x62}}, /* 0x1a */
 {{0xab,0x7f,0x7f,0x8f,0x8d,0x9b,0x35,0xf5,
  0x00,0x83,0xff,0xff,0x36,0x14,0x00,0x02,
  0x62}}, /* 0x1b */
 {{0xcf,0x9f,0x9f,0x93,0xb2,0x01,0x14,0xba,
  0x00,0x83,0xff,0xff,0x15,0x00,0x00,0x03,
  0x00}}, /* 0x1c */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0x5a,
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}}, /* 0x1d */
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0x5a,
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}}, /* 0x1e */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0x5a,
  0x00,0x83,0xff,0xff,0x2f,0x09,0x00,0x07,
  0x01}}, /* 0x1f */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}}, /* 0x20 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}}, /* 0x21 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}}, /* 0x22 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}}, /* 0x23 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}}, /* 0x24 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}}, /* 0x25 */
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}}, /* 0x26 */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
  0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
  0x00}}, /* 0x27 */
 {{0x43,0xef,0xef,0x87,0x06,0x00,0xd4,0x1f,
  0xa0,0x83,0x9f,0x9f,0xd5,0x1f,0x41,0x05,
  0x63}}, /* 0x28 */
 {{0x45,0xef,0xef,0x89,0x07,0x01,0xd9,0x1f,
  0xa0,0x83,0x9f,0x9f,0xda,0x1f,0x41,0x05,
  0x63}}, /* 0x29 */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
  0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
  0x00}}, /* 0x2a */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
  0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
  0x00}}, /* 0x2b */
 {{0x40,0xef,0xef,0x84,0x03,0x1d,0xda,0x1f,
  0xa0,0x83,0x9f,0x9f,0xdb,0x1f,0x41,0x01,
  0x00}}, /* 0x2c */
 {{0x59,0xff,0xff,0x9d,0x17,0x13,0x33,0xba,
  0x00,0x83,0xff,0xff,0x34,0x0f,0x41,0x05,
  0x44}}, /* 0x2d */
 {{0x5b,0xff,0xff,0x9f,0x18,0x14,0x38,0xba,
  0x00,0x83,0xff,0xff,0x39,0x0f,0x41,0x05,
  0x44}}, /* 0x2e */
 {{0x5b,0xff,0xff,0x9f,0x18,0x14,0x3d,0xba,
  0x00,0x83,0xff,0xff,0x3e,0x0f,0x41,0x05,
  0x44}}, /* 0x2f */
 {{0x5d,0xff,0xff,0x81,0x19,0x95,0x41,0xba,
  0x00,0x84,0xff,0xff,0x42,0x0f,0x41,0x05,
  0x44}}, /* 0x30 */
 {{0x55,0xff,0xff,0x99,0x0d,0x0c,0x3e,0xba,
  0x00,0x84,0xff,0xff,0x3f,0x0f,0x41,0x05,
  0x00}}, /* 0x31 */
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xba,
  0x27,0x8b,0xdf,0xdf,0x73,0x00,0x00,0x06,
  0x01}}, /* 0x32 */
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xba,
  0x26,0x89,0xdf,0xdf,0x6f,0x00,0x00,0x06,
  0x01}}, /* 0x33 */
 {{0x7f,0x63,0x63,0x82,0x6b,0x13,0x75,0xba,
  0x29,0x8c,0xdf,0xdf,0x75,0x00,0x00,0x06,
  0x01}}, /* 0x34 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf1,
  0xaf,0x85,0x3f,0x3f,0x25,0x30,0x00,0x02,
  0x01}}, /* 0x35 */
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf1,
  0xad,0x81,0x3f,0x3f,0x1f,0x30,0x00,0x02,
  0x01}}, /* 0x36 */
 {{0xa7,0x7f,0x7f,0x88,0x89,0x15,0x26,0xf1,
  0xb1,0x85,0x3f,0x3f,0x27,0x30,0x00,0x02,
  0x01}}, /* 0x37 */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0xc4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}}, /* 0x38 */
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0xd4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}}, /* 0x39 */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0xd4,
  0x7d,0x81,0xcf,0xcf,0x2f,0x21,0x00,0x07,
  0x01}}, /* 0x3a */
 {{0xdc,0x9f,0x9f,0x00,0xab,0x19,0xe6,0xef,
  0xc0,0xc3,0xbf,0xbf,0xe7,0x10,0x00,0x07,
  0x01}}, /* 0x3b */
 {{0x6b,0x59,0x59,0x8f,0x5e,0x8c,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}}, /* 0x3c */
 {{0x7b,0x59,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
  0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
  0x01}}, /* 0x3d */
 {{0x86,0x6a,0x6a,0x8a,0x74,0x06,0x8c,0x15,
  0x4f,0x83,0xef,0xef,0x8d,0x30,0x00,0x02,
  0x00}},/*3e*/
  {{0x81,0x6a,0x6a,0x85,0x70,0x00,0x0f,0x3e,
  0xeb,0x8e,0xdf,0xdf,0x10,0x00,0x00,0x02,
  0x00}} ,/*3f*/
  {{0x2d,0x27,0x28,0x90,0x2c,0x80,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,
  0x00}}/*40*/ 
};

typedef struct _SiS310_MCLKDataStruct
{
	UCHAR SR28,SR29,SR2A;
	USHORT CLOCK;
} SiS310_MCLKDataStruct;

SiS310_MCLKDataStruct SiS310_MCLKData[]=
{
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166}
};

typedef struct _SiS310_ECLKDataStruct
{
 	UCHAR SR2E,SR2F,SR30;
 	USHORT CLOCK;
} SiS310_ECLKDataStruct;
SiS310_ECLKDataStruct SiS310_ECLKData[]=
{
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166},
	{ 0x5c,0x23,0x01,166}
};

typedef struct _SiS310_VCLKDataStruct
{
	UCHAR SR2B,SR2C;
	USHORT CLOCK;
} SiS310_VCLKDataStruct;

SiS310_VCLKDataStruct SiS310_VCLKData[]=
{
	{ 0x1b,0xe1, 25}, /* 0x0 */
	{ 0x4e,0xe4, 28}, /* 0x1 */
	{ 0x57,0xe4, 31}, /* 0x2 */
	{ 0xc3,0xc8, 36}, /* 0x3 */
	{ 0x42,0xe2, 40}, /* 0x4 */
	{ 0xfe,0xcd, 43}, /* 0x5 */
	{ 0x5d,0xc4, 44}, /* 0x6 */
	{ 0x52,0xe2, 49}, /* 0x7 */
	{ 0x53,0xe2, 50}, /* 0x8 */
	{ 0x74,0x67, 52}, /* 0x9 */
	{ 0x6d,0x66, 56}, /* 0xa */
	{ 0x6c,0xc3, 65}, /* 0xb */
	{ 0x46,0x44, 67}, /* 0xc */
	{ 0xb1,0x46, 68}, /* 0xd */
	{ 0xd3,0x4a, 72}, /* 0xe */
	{ 0x29,0x61, 75}, /* 0xf */
	{ 0x6e,0x46, 76}, /* 0x10 */
	{ 0x2b,0x61, 78}, /* 0x11 */
	{ 0x31,0x42, 79}, /* 0x12 */
	{ 0xab,0x44, 83}, /* 0x13 */
	{ 0x46,0x25, 84}, /* 0x14 */
	{ 0x78,0x29, 86}, /* 0x15 */
	{ 0x62,0x44, 94}, /* 0x16 */
	{ 0x2b,0x41,104}, /* 0x17 */
	{ 0x3a,0x23,105}, /* 0x18 */
	{ 0x70,0x44,108}, /* 0x19 */
	{ 0x3c,0x23,109}, /* 0x1a */
	{ 0x5e,0x43,113}, /* 0x1b */
	{ 0xbc,0x44,116}, /* 0x1c */
	{ 0xe0,0x46,132}, /* 0x1d */
	{ 0x54,0x42,135}, /* 0x1e */
	{ 0xea,0x2a,139}, /* 0x1f */
	{ 0x41,0x22,157}, /* 0x20 */
	{ 0x70,0x24,162}, /* 0x21 */
	{ 0x30,0x21,175}, /* 0x22 */
	{ 0x4e,0x22,189}, /* 0x23 */
	{ 0xde,0x26,194}, /* 0x24 */
	{ 0x62,0x06,202}, /* 0x25 */
	{ 0x3f,0x03,229}, /* 0x26 */
	{ 0xb8,0x06,234}, /* 0x27 */
	{ 0x34,0x02,253}, /* 0x28 */
	{ 0x58,0x04,255}, /* 0x29 */
	{ 0x24,0x01,265}, /* 0x2a */
	{ 0x9b,0x02,267}, /* 0x2b */
	{ 0x70,0x05,270}, /* 0x2c */
	{ 0x25,0x01,272}, /* 0x2d */
	{ 0x9c,0x02,277}, /* 0x2e */
	{ 0x27,0x01,286}, /* 0x2f */
	{ 0x3c,0x02,291}, /* 0x30 */
	{ 0xef,0x0a,292}, /* 0x31 */
	{ 0xf6,0x0a,310}, /* 0x32 */
	{ 0x95,0x01,315}, /* 0x33 */
	{ 0xf0,0x09,324}, /* 0x34 */
	{ 0xfe,0x0a,331}, /* 0x35 */
	{ 0xf3,0x09,332}, /* 0x36 */
	{ 0xea,0x08,340}, /* 0x37 */
	{ 0xe8,0x07,376}, /* 0x38 */
	{ 0xde,0x06,389}, /* 0x39 */
	{ 0x52,0x2a, 54}, /* 0x3a */
	{ 0x52,0x6a, 27}, /* 0x3b */
	{ 0x62,0x24, 70}, /* 0x3c */
	{ 0x62,0x64, 70}, /* 0x3d */
	{ 0xa8,0x4c, 30}, /* 0x3e */
	{ 0x20,0x26, 33}, /* 0x3f */
	{ 0x31,0xc2, 39}  /* 0x40 */
};

typedef struct _SiS310_VBVCLKDataStruct
{
	UCHAR Part4_A,Part4_B;
	USHORT CLOCK;
} SiS310_VBVCLKDataStruct;

SiS310_VBVCLKDataStruct SiS310_VBVCLKData[]=
{
	{ 0x1b,0xe1, 25}, /* 0x0 */
	{ 0x4e,0xe4, 28}, /* 0x1 */
	{ 0x57,0xe4, 31}, /* 0x2 */
	{ 0xc3,0xc8, 36}, /* 0x3 */
	{ 0x42,0x47, 40}, /* 0x4 */
	{ 0xfe,0xcd, 43}, /* 0x5 */
	{ 0x5d,0xc4, 44}, /* 0x6 */
	{ 0x52,0x47, 49}, /* 0x7 */
	{ 0x53,0x47, 50}, /* 0x8 */
	{ 0x74,0x67, 52}, /* 0x9 */
	{ 0x6d,0x66, 56}, /* 0xa */
	{ 0x5a,0x64, 65}, /* 0xb */
	{ 0x46,0x44, 67}, /* 0xc */
	{ 0xb1,0x46, 68}, /* 0xd */
	{ 0xd3,0x4a, 72}, /* 0xe */
	{ 0x29,0x61, 75}, /* 0xf */
	{ 0x6d,0x46, 75}, /* 0x10 */
	{ 0x41,0x43, 78}, /* 0x11 */
	{ 0x31,0x42, 79}, /* 0x12 */
	{ 0xab,0x44, 83}, /* 0x13 */
	{ 0x46,0x25, 84}, /* 0x14 */
	{ 0x78,0x29, 86}, /* 0x15 */
	{ 0x62,0x44, 94}, /* 0x16 */
	{ 0x2b,0x22,104}, /* 0x17 */
	{ 0x49,0x24,105}, /* 0x18 */
	{ 0xf8,0x2f,108}, /* 0x19 */
	{ 0x3c,0x23,109}, /* 0x1a */
	{ 0x5e,0x43,113}, /* 0x1b */
	{ 0xbc,0x44,116}, /* 0x1c */
	{ 0xe0,0x46,132}, /* 0x1d */
	{ 0xd4,0x28,135}, /* 0x1e */
	{ 0xea,0x2a,139}, /* 0x1f */
	{ 0x41,0x22,157}, /* 0x20 */
	{ 0x70,0x24,162}, /* 0x21 */
	{ 0x30,0x21,175}, /* 0x22 */
	{ 0x4e,0x22,189}, /* 0x23 */
	{ 0xde,0x26,194}, /* 0x24 */
	{ 0x70,0x07,202}, /* 0x25 */
	{ 0x3f,0x03,229}, /* 0x26 */
	{ 0xb8,0x06,234}, /* 0x27 */
	{ 0x34,0x02,253}, /* 0x28 */
	{ 0x58,0x04,255}, /* 0x29 */
	{ 0x24,0x01,265}, /* 0x2a */
	{ 0x9b,0x02,267}, /* 0x2b */
	{ 0x70,0x05,270}, /* 0x2c */
	{ 0x25,0x01,272}, /* 0x2d */
	{ 0x9c,0x02,277}, /* 0x2e */
	{ 0x27,0x01,286}, /* 0x2f */
	{ 0x3c,0x02,291}, /* 0x30 */
	{ 0xef,0x0a,292}, /* 0x31 */
	{ 0xf6,0x0a,310}, /* 0x32 */
	{ 0x95,0x01,315}, /* 0x33 */
	{ 0xf0,0x09,324}, /* 0x34 */
	{ 0xfe,0x0a,331}, /* 0x35 */
	{ 0xf3,0x09,332}, /* 0x36 */
	{ 0xea,0x08,340}, /* 0x37 */
	{ 0xe8,0x07,376}, /* 0x38 */
	{ 0xde,0x06,389}, /* 0x39 */
	{ 0x52,0x2a, 54}, /* 0x3a */
	{ 0x52,0x6a, 27}, /* 0x3b */
	{ 0x62,0x24, 70}, /* 0x3c */
	{ 0x62,0x64, 70}, /* 0x3d */
	{ 0xa8,0x4c, 30}, /* 0x3e */
	{ 0x20,0x26, 33}, /* 0x3f */
	{ 0x31,0xc2, 39}  /* 0x40 */
};

UCHAR SiS310_ScreenOffset[]= { 0x14,0x19,0x20,0x28,0x32,0x40,
                               0x50,0x64,0x78,0x80,0x2d,0x35};

typedef struct _SiS310_StResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
} SiS310_StResInfoStruct;

SiS310_StResInfoStruct SiS310_StResInfo[]=
{
	{ 640,400},
	{ 640,350},
	{ 720,400},
	{ 720,350},
	{ 640,480}
};

typedef struct _SiS310_ModeResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
	UCHAR  XChar;
	UCHAR  YChar;
} SiS310_ModeResInfoStruct;

SiS310_ModeResInfoStruct SiS310_ModeResInfo[]=
{
	{  320, 200, 8, 8},
	{  320, 240, 8, 8},
	{  320, 400, 8, 8},
	{  400, 300, 8, 8},
	{  512, 384, 8, 8},
	{  640, 400, 8,16},
	{  640, 480, 8,16},
	{  800, 600, 8,16},
	{ 1024, 768, 8,16},
	{ 1280,1024, 8,16},
	{ 1600,1200, 8,16},
	{ 1920,1440, 8,16},
	{ 2048,1536, 8,16},
	{  720, 480, 8,16},
	{  720, 576, 8,16},
	{ 1280, 960, 8,16},
	{  800, 480, 8,16},
	{ 1024, 576, 8,16},
	{ 1280, 720, 8,16}
};

UCHAR SiS310_OutputSelect =0x40;

UCHAR SiS310_SoftSetting = 30;

UCHAR SiS310_SR07=0x18;

UCHAR SiS310_SR15[8][4]={
	{0x00,0x04,0x60,0x60},
	{0x0f,0x0f,0x0f,0x0f},
	{0xba,0xba,0xba,0xba},
	{0xa9,0xa9,0xac,0xac},
	{0xa0,0xa0,0xa0,0xa8},
	{0x00,0x00,0x02,0x02},
	{0x30,0x30,0x40,0x40},
	{0x00,0xa5,0xfb,0xf6}
};

UCHAR SiS310_CR40[5][4]={
	{0x77,0x77,0x33,0x33},
	{0x77,0x77,0x33,0x33},
	{0x00,0x00,0x00,0x00},
	{0x5b,0x5b,0x03,0x03},
	{0x00,0x00,0xf0,0xf8}
};

UCHAR SiS310_CR49[]={0xaa,0x88};
UCHAR SiS310_SR1F=0x0;
UCHAR SiS310_SR21=0xa5;
UCHAR SiS310_SR22=0xfb;
UCHAR SiS310_SR23=0xf6;
UCHAR SiS310_SR24=0xd;
UCHAR SiS310_SR25[]={0x33,0x3};
UCHAR SiS310_SR31=0x0;
UCHAR SiS310_SR32=0x11;
UCHAR SiS310_SR33=0x0;
UCHAR SiS310_CRT2Data_1_2 = 0x0;
UCHAR SiS310_CRT2Data_4_D = 0x0;
UCHAR SiS310_CRT2Data_4_E = 0x0;
UCHAR SiS310_CRT2Data_4_10 = 0x80;
USHORT SiS310_RGBSenseData = 0xd1;
USHORT SiS310_VideoSenseData = 0xb9;
USHORT SiS310_YCSenseData = 0xb3;
USHORT SiS310_RGBSenseData2 = 0x0190;     /*301b*/
USHORT SiS310_VideoSenseData2 = 0x0174;
USHORT SiS310_YCSenseData2 = 0x016b;
UCHAR SiS310_NTSCPhase[] = {0x21,0xed,0x8a,0x8};
UCHAR SiS310_PALPhase[] = {0x2a,0x5,0xd3,0x0};
UCHAR SiS310_NTSCPhase2[] = {0x21,0xF0,0x7B,0xD6};/*301b*/
UCHAR SiS310_PALPhase2[] = {0x2a,0x09,0x86,0xe9};
UCHAR SiS310_PALMPhase[] = {0x21,0xE4,0x2E,0x9B};   /*palmn*/
UCHAR SiS310_PALNPhase[] = {0x21,0xF4,0x3E,0xBA};

typedef struct _SiS310_LCDDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS310_LCDDataStruct;

SiS310_LCDDataStruct  SiS310_StLCD1024x768Data[]=
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

SiS310_LCDDataStruct  SiS310_ExtLCD1024x768Data[]=
{
	{   12,   5, 896, 512,1344, 806},
	{   12,   5, 896, 510,1344, 806},
	{   32,  15,1008, 505,1344, 806},
	{   32,  15,1008, 514,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

SiS310_LCDDataStruct  SiS310_St2LCD1024x768Data[]=
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

SiS310_LCDDataStruct  SiS310_StLCD1280x1024Data[]=
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

SiS310_LCDDataStruct  SiS310_ExtLCD1280x1024Data[]=
{
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 500,1688,1066},
	{  211,  75,1024, 625,1688,1066},
	{  211, 120,1280, 798,1688,1066},
	{    1,   1,1688,1066,1688,1066}
};

SiS310_LCDDataStruct  SiS310_St2LCD1280x1024Data[]=
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

SiS310_LCDDataStruct  SiS310_NoScaleData[]=
{
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 800, 525, 800, 525},
	{    1,   1,1056, 628,1056, 628},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1688,1066,1688,1066}
};

SiS310_LCDDataStruct  SiS310_LCD1280x960Data[]=
{
	{    9,   2, 800, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{   30,  11,1056, 625,1800,1000},
	{    5,   3,1350, 800,1800,1000},
	{    1,   1,1576,1050,1576,1050},
	{    1,   1,1800,1000,1800,1000}
};

typedef struct _SiS310_TVDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT TVHDE;
	USHORT TVVDE;
	USHORT RVBHRS;
	UCHAR FlickerMode;
	USHORT HALFRVBHRS;
	UCHAR RY1COE;
	UCHAR RY2COE;
	UCHAR RY3COE;
	UCHAR RY4COE;
} SiS310_TVDataStruct;

SiS310_TVDataStruct  SiS310_StPALData[]=
{
 {    1,   1, 864, 525,1270, 400, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 350, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 864, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 864, 525,1270, 480,  50,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 600,  50,   0,   0,0xf4,0xff,0x1c,0x22}
};

SiS310_TVDataStruct  SiS310_ExtPALData[]=
{
 {   27,  10, 848, 448,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
 {  108,  35, 848, 398,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
 {   12,   5, 954, 448,1270, 530,  50,   0,  50,0xf1,0x04,0x1f,0x18},
 {    9,   4, 960, 463,1644, 438,  50,   0,  50,0xf4,0x0b,0x1c,0x0a},
 {    9,   4, 848, 528,1270, 530,   0,   0,  50,0xf5,0xfb,0x1b,0x2a},
 {   36,  25,1060, 648,1316, 530, 438,   0, 438,0xeb,0x05,0x25,0x16},
 {    3,   2,1080, 619,1270, 540, 438,   0, 438,0xf3,0x00,0x1d,0x20},
 {    1,   1,1170, 821,1270, 520, 686,   0, 686,0xF3,0x00,0x1D,0x20}     /*301b*/
};

SiS310_TVDataStruct  SiS310_StNTSCData[]=
{
 {    1,   1, 858, 525,1270, 400,  50,   0, 760,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,  50,   0, 640,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 858, 525,1270, 480,   0,   0, 760,0xf1,0x04,0x1f,0x18}
};

SiS310_TVDataStruct  SiS310_ExtNTSCData[]=
{
 {  143,  65, 858, 443,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {   88,  35, 858, 393,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 443,1270, 440,  92,   0,  92,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 393,1270, 440,  92,   0,  92,0xf4,0x0b,0x1c,0x0a},
 {  143,  76, 836, 523,1270, 440, 224,   0,   0,0xf1,0x05,0x1f,0x16},
 {  143, 120,1056, 643,1270, 440,   0, 128,   0,0xf4,0x10,0x1c,0x00},
 {    2,   1, 858, 503,1270, 480,   0, 128,   0,0xee,0x0c,0x22,0x08},
 {   65,  64,1056, 791,1270, 480, 638,   0,   0,0xEE,0x0C,0x22,0x08} /*301b*/     
};

SiS310_TVDataStruct  SiS310_St1HiTVData[]=
{
	{0x00}
};

SiS310_TVDataStruct  SiS310_St2HiTVData[]=
{
	{0x00}
};

SiS310_TVDataStruct  SiS310_ExtHiTVData[]=
{
	{0x00}
};

UCHAR SiS310_NTSCTiming[] = {
	0x17,0x1d,0x03,0x09,0x05,0x06,0x0c,0x0c,
	0x94,0x49,0x01,0x0a,0x06,0x0d,0x04,0x0a,
	0x06,0x14,0x0d,0x04,0x0a,0x00,0x85,0x1b,
	0x0c,0x50,0x00,0x97,0x00,0xda,0x4a,0x17,
	0x7d,0x05,0x4b,0x00,0x00,0xe2,0x00,0x02,
	0x03,0x0a,0x65,0x9d,0x08,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x50,
	0x00,0x40,0x44,0x00,0xdb,0x02,0x3b,0x00
};

UCHAR SiS310_PALTiming[] = {
	0x19,0x52,0x35,0x6e,0x04,0x38,0x3d,0x70,
	0x94,0x49,0x01,0x12,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0x45,0x2b,
	0x70,0x50,0x00,0x9b,0x00,0xd9,0x5d,0x17,
	0x7d,0x05,0x45,0x00,0x00,0xe8,0x00,0x02,
	0x0d,0x00,0x68,0xb0,0x0b,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x63,
	0x00,0x40,0x3e,0x00,0xe1,0x02,0x28,0x00
};

UCHAR SiS310_HiTVExtTiming[] = {0x00};

UCHAR SiS310_HiTVSt1Timing[] = {0x00};

UCHAR SiS310_HiTVSt2Timing[] = {0x00};

UCHAR SiS310_HiTVTextTiming[] = {0x00};

UCHAR SiS310_HiTVGroup3Data[] = {0x00};

UCHAR SiS310_HiTVGroup3Simu[] = {0x00};

UCHAR SiS310_HiTVGroup3Text[] = {0x00};

typedef struct _SiS310_PanelDelayTblStruct
{
 	UCHAR timer[2];
} SiS310_PanelDelayTblStruct;

SiS310_PanelDelayTblStruct SiS310_PanelDelayTbl[]=
{
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}},
	{{0x00,0x00}}
};

typedef struct _SiS310_LVDSDataStruct
{
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS310_LVDSDataStruct;

SiS310_LVDSDataStruct  SiS310_LVDS320x480Data_1[]=
{
	{848, 433,400,525},
	{848, 389,400,525},
	{848, 433,400,525},
	{848, 389,400,525},
	{848, 518,400, 525},
	{1056, 628,400,525},
	{400, 525,400,525},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};
SiS310_LVDSDataStruct  SiS310_LVDS800x600Data_1[]=
{
	{848, 433,1060, 629},
	{848, 389,1060, 629},
	{848, 433,1060, 629},
	{848, 389,1060, 629},
	{848, 518,1060, 629},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};

SiS310_LVDSDataStruct  SiS310_LVDS800x600Data_2[]=
{
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};

SiS310_LVDSDataStruct  SiS310_LVDS1024x768Data_1[]=
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS310_LVDSDataStruct  SiS310_LVDS1024x768Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS310_LVDSDataStruct  SiS310_LVDS1280x1024Data_1[]=
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS310_LVDSDataStruct  SiS310_LVDS1280x1024Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

SiS310_LVDSDataStruct  SiS310_LVDS640x480Data_1[]=
{
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 525, 800, 525},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628}
};

SiS310_LVDSDataStruct  SiS310_CHTVUNTSCData[]=
{
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{784, 600, 784, 600},
	{1064, 750,1064, 750}
};

SiS310_LVDSDataStruct  SiS310_CHTVONTSCData[]=
{
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{784, 525, 784, 525},
	{1040, 700,1040, 700}
};

SiS310_LVDSDataStruct  SiS310_CHTVUPALData[]=
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{840, 750, 840, 750},
	{936, 836, 936, 836}
};

SiS310_LVDSDataStruct  SiS310_CHTVOPALData[]=
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{840, 625, 840, 625},
	{960, 750, 960, 750}
};

typedef struct _SiS310_LVDSDesStruct
{
	USHORT LCDHDES;
	USHORT LCDVDES;
} SiS310_LVDSDesStruct;

SiS310_LVDSDesStruct  SiS310_PanelType00_1[]=
{
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType01_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType02_1[]=
{
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{ 0, 627},
	{ 8, 523},
	{ 0,   0},
	{ 0,   0}
};


SiS310_LVDSDesStruct  SiS310_PanelType03_1[]=
{
	{ 8, 436},
	{ 8, 440},
	{ 8, 436},
	{ 8, 440},
	{ 8, 512},
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794}
};

SiS310_LVDSDesStruct  SiS310_PanelType04_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType05_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType06_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType07_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType08_1[]=
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType09_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0a_1[]=
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0b_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0c_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0d_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0e_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0f_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType00_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType01_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType02_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType03_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{1152, 622},
	{1152, 597}
};

SiS310_LVDSDesStruct  SiS310_PanelType04_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType05_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType06_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType07_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType08_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType09_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
 	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0a_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0b_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0c_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0d_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0e_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_PanelType0f_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};
/*301b*/
SiS310_LVDSDesStruct SiS310_PanelType1076_1[]=
{
	{0x00,0x00}
};
SiS310_LVDSDesStruct SiS310_PanelType1210_1[]=
{
	{0x00,0x00}
};
SiS310_LVDSDesStruct SiS310_PanelType1296_1[]=
{
	{0x00,0x00}
};
SiS310_LVDSDesStruct SiS310_PanelType1076_2[]=
{
	{0x00,0x00}
};
SiS310_LVDSDesStruct SiS310_PanelType1210_2[]=
{
	{0x00,0x00}
};
SiS310_LVDSDesStruct SiS310_PanelType1296_2[]=
{
	{0x00,0x00}
};
/*end 301b*/

SiS310_LVDSDesStruct  SiS310_CHTVUNTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_CHTVONTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_CHTVUPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0}
};

SiS310_LVDSDesStruct  SiS310_CHTVOPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0}
};

/*add for LCDA*/
typedef struct _SiS310_LCDACRT1DataStruct
{
 	UCHAR CR[17];
}SiS310_LCDACRT1DataStruct;

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_1[]=
{
{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00}},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_1[]=
{
{{0x73,0x4f,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x4f,0x97,0x55,0x86,0x04,0x3e,
   0xE2,0x89,0xDf,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x87,0x63,0x63,0x8B,0x69,0x1A,0x7c,0xf0,
   0x5A,0x8F,0x57,0x57,0x7D,0x20,0x00,0x26,
   0x01}},
 {{0xA3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xFf,0xFf,0x25,0x10,0x00,0x02,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_1[]=
{
{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00}},
 {{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
   0x00}},
 {{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00}},
 {{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
   0x00}},
 {{0x63,0x4f,0x87,0x54,0x9f,0x04,0x3e,
   0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
   0x00}},
 {{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
   0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_1_H[]=
{
{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
   0x00}},
 {{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
   0x00}},
 {{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
   0x00}},
 {{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
   0x00}},
 {{0x30,0x27,0x94,0x2c,0x92,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x04,
   0x00}},
 {{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_1_H[]=
{
{{0x37,0x27,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x37,0x27,0x27,0x9B,0x2b,0x94,0x97,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x37,0x27,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
   0x92,0x89,0x8f,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x37,0x27,0x27,0x9B,0x2b,0x94,0x97,0x1f,
   0x60,0x87,0x5D,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x37,0x27,0x27,0x9B,0x2b,0x94,0x04,0x3e,
   0xE2,0x89,0xDf,0xDf,0x05,0x00,0x00,0x44,
   0x00}},
 {{0x41,0x31,0x31,0x85,0x35,0x1d,0x7c,0xf0,
   0x5A,0x8F,0x57,0x57,0x7D,0x20,0x00,0x55,
   0x01}},
 {{0x4f,0x3F,0x3F,0x93,0x45,0x0D,0x24,0xf5,
   0x02,0x88,0xFf,0xFf,0x25,0x10,0x00,0x01,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_1_H[]=
{
{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
   0x00}},
{{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
   0x00}},
 {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
   0xe2,0x89,0xdf,0x05,0x00,0x00,0x04,
   0x00}},
 {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
   0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
   0x01}},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_2[]=
{ 
{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
   0x00}},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
   0x00}},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
   0x00}},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
   0x00}},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0xba,
   0x1c,0x80,0xdf,0x73,0x00,0x00,0x06,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_2[]=
{ 
{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_2[]=
{
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
   0x00}},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT1800x600_2_H[]=
{ 
{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
   0x00}},
 {{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
   0x00}},
 {{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
   0x00}},
 {{0x3d,0x27,0x81,0x3a,0x1a,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
   0x00}},
 {{0x3d,0x27,0x81,0x32,0x1a,0x72,0xba,
   0x1c,0x80,0xdf,0x73,0x00,0x00,0x05,
   0x00}},
 {{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
   0x01}}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11024x768_2_H[]=
{ 
{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x01,
   0x01 }},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01 }}
};

SiS310_LCDACRT1DataStruct  SiS310_LCDACRT11280x1024_2_H[]=
{ 
{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x31,0x93,0x3e,0x86,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x01,
   0x01 }},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01 }}
};

typedef struct _SiS310_LVDSCRT1DataStruct
{
 	UCHAR CR[15];
} SiS310_LVDSCRT1DataStruct;

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1320x480_1[]=
{
{{0x65,0x4f,0x89,0x56,0x83,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }},
{{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00 }}
};
SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_1[]=
{
{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_1[]=
{
{{0x73,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x55,0x86,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x55,0x86,0x97,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x05,
   0x00}},
 {{0x73,0x4f,0x97,0x55,0x86,0x04,0x3e,
   0xE2,0x89,0xDf,0x05,0x00,0x00,0x05,
   0x00}},
 {{0x87,0x63,0x8B,0x69,0x1A,0x7c,0xf0,
   0x5A,0x8F,0x57,0x7D,0x20,0x00,0x26,
   0x01}},
 {{0xA3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xFf,0x25,0x10,0x00,0x02,
   0x01}}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_1[]=
{
{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00 }},
 {{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
   0x00 }},
 {{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00 }},
 {{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
   0x00 }},
 {{0x63,0x4f,0x87,0x54,0x9f,0x04,0x3e,
   0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
   0x00 }},
 {{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
   0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
   0x01 }},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_1_H[]=
{
{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
   0x00 }},
 {{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
   0x00 }},
 {{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
   0x00 }},
 {{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
   0x00 }},
 {{0x30,0x27,0x94,0x2c,0x92,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x04,
   0x00 }},
 {{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_1_H[]=
{
{{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
   0x00 }},
 {{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
   0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
   0x00}},
 {{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
   0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
   0x00}},
 {{0x37,0x27,0x9B,0x2b,0x94,0x04,0x3e,
   0xE2,0x89,0xDf,0x05,0x00,0x00,0x44,
   0x00}},
 {{0x41,0x31,0x85,0x35,0x1d,0x7c,0xf0,
   0x5A,0x8F,0x57,0x7D,0x20,0x00,0x55,
   0x01}},
 {{0x4f,0x3F,0x93,0x45,0x0D,0x24,0xf5,
   0x02,0x88,0xFf,0x25,0x10,0x00,0x01,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_1_H[]=
{
{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
   0x00 }},
 {{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
   0x00 }},
 {{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
   0x00 }},
 {{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
   0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
   0x00 }},
 {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
   0xe2,0x89,0xdf,0x05,0x00,0x00,0x04,
   0x00 }},
 {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
   0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
   0x01 }},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_2[]=
{ 
{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
   0x00 }},
 {{0x7f,0x4f,0x83,0x62,0x12,0x72,0xba,
   0x1c,0x80,0xdf,0x73,0x00,0x00,0x06,
   0x00 }},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_2[]=
{ 
{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x02,
   0x01 }},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_2[]=
{ 
{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
   0x00 }},
 {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x02,
   0x01 }},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT1800x600_2_H[]=
{ 
{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
   0x00 }},
 {{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
   0x00 }},
 {{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
   0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
   0x00 }},
 {{0x3d,0x27,0x81,0x3a,0x1a,0x72,0x3e,
   0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
   0x00 }},
 {{0x3d,0x27,0x81,0x32,0x1a,0x72,0xba,
   0x1c,0x80,0xdf,0x73,0x00,0x00,0x05,
   0x00 }},
 {{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11024x768_2_H[]=
{ 
{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x01,
   0x01 }},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_LVDSCRT11280x1024_2_H[]=
{ 
{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
   0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
   0x00 }},
 {{0x4f,0x31,0x93,0x3e,0x86,0x24,0xf1,
   0xae,0x84,0x57,0x25,0x30,0x00,0x01,
   0x01 }},
 {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1UNTSC[]=
{ 
{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
   0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
   0x00 }},
 {{0x5d,0x4f,0x81,0x53,0x9c,0x56,0xba,
   0x18,0x84,0xdf,0x57,0x00,0x00,0x01,
   0x00 }},
 {{0x80,0x63,0x84,0x6c,0x17,0xec,0xf0,
   0x90,0x8c,0x57,0xed,0x20,0x00,0x06,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1ONTSC[]=
{ 
{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
   0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
   0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
   0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
   0x00 }},
 {{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
   0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
   0x00 }},
 {{0x5d,0x4f,0x81,0x56,0x9c,0x0b,0x3e,
   0xe8,0x84,0xdf,0x0c,0x00,0x00,0x01,
   0x00 }},
 {{0x7d,0x63,0x81,0x6a,0x16,0xba,0xf0,
   0x7f,0x86,0x57,0xbb,0x00,0x00,0x06,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1UPAL[]=
{ 
{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x64,0x4f,0x88,0x55,0x80,0xec,0xba,
   0x50,0x84,0xdf,0xed,0x00,0x00,0x05,
   0x00 }},
 {{0x70,0x63,0x94,0x68,0x8d,0x42,0xf1,
   0xc8,0x8c,0x57,0xe9,0x20,0x00,0x05,
   0x01 }}
};

SiS310_LVDSCRT1DataStruct  SiS310_CHTVCRT1OPAL[]=
{ 
{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
   0x00 }},
 {{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
   0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x64,0x4f,0x88,0x55,0x80,0x6f,0xba,
   0x20,0x83,0xdf,0x70,0x00,0x00,0x05,
   0x00 }},
 {{0x73,0x63,0x97,0x69,0x8e,0xec,0xf0,
   0x90,0x8c,0x57,0xed,0x20,0x00,0x05,
   0x01 }}
};

typedef struct _SiS310_CHTVRegDataStruct
{
 	UCHAR Reg[5];
} SiS310_CHTVRegDataStruct;

SiS310_CHTVRegDataStruct SiS310_CHTVReg_UNTSC[] = {
	{{0x00}}
 };

SiS310_CHTVRegDataStruct SiS310_CHTVReg_ONTSC[] = {
	{{0x00}}
 };

SiS310_CHTVRegDataStruct SiS310_CHTVReg_UPAL[] = {
	{{0x00}}
 };

SiS310_CHTVRegDataStruct SiS310_CHTVReg_OPAL[] = {
	{{0x00}}
 };

UCHAR SiS310_CHTVVCLKUNTSC[]={0x00 };

UCHAR SiS310_CHTVVCLKONTSC[]={0x00 };

UCHAR SiS310_CHTVVCLKUPAL[]={0x00 };

UCHAR SiS310_CHTVVCLKOPAL[]={0x00 };

