/*
 * S
 *
 * Copyright 2002 Hewlitt-Packard Company
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * HEWLITT-PACKARD COMONAY MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Andrew Christian
 *
 */

#ifndef _INCLUDE_H3600_PCMCIA_H_
#define _INCLUDE_H3600_PCMCIA_H_

struct pcmcia_init;
struct pcmcia_state_array;
struct pcmcia_irq_info;
struct pcmcia_low_level;

extern int  h3600_common_pcmcia_init( struct pcmcia_init *init );
extern int  h3600_common_pcmcia_shutdown( void );
extern int  h3600_common_pcmcia_socket_state( struct pcmcia_state_array *state_array );
extern int  h3600_common_pcmcia_get_irq_info( struct pcmcia_irq_info *info );
extern int  h3600_common_pcmcia_socket_init(int sock);
extern int  h3600_common_pcmcia_socket_suspend(int sock);
extern int  h3600_common_pcmcia_mecr_timing(unsigned int sock, unsigned int cpu_speed, 
					    unsigned int cmd_time );


extern void h3600_pcmcia_change_sleeves(struct pcmcia_low_level *ops);
extern void h3600_pcmcia_remove_sleeve( void );
extern void h3600_pcmcia_suspend_sockets( void );
extern void h3600_pcmcia_resume_sockets( void );

#endif
