/*
 * L3 S3C2410 algorithm/adapter module.
 *
 * COPYRIGHT (C) 2002 SAMSUNG ELECTRONICS 
 * 	SW.LEE <hitchcar@sec.samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/module.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/errno.h>
#include <linux/l3/l3.h>

#include <asm/hardware.h>
#include <asm/semaphore.h>
#include <asm/mach-types.h>

/*
 * l3 low level write function could be gotten from 24tes BIOS
 * Visit at www.samsungsemi.com  -32 bit RISC CPU, Mobile 
 *                             
 */

#define L3C (1<<4)		/* GPB4 = L3CLOCK */
#define L3D (1<<3)		/* GPB3 = L3DATA */
#define L3M (1<<2)		/* GPB2 = L3MODE */

#ifdef SWL_DEBUG
#define swldebug(x...)   printk( ##x )
#else
#define swldebug(x...)
#endif


static inline unsigned char l3_s3c2410_recv_byte(unsigned char addr)
{
	return addr;
}

static void l3_s3c2410_recv_msg(struct l3_msg *msg)
{
	return;
}

#define L3_DELAY 10

static void _WrL3Addr(unsigned char data)
{	
    unsigned int  i,j;

    rGPBDAT = (rGPBDAT&~(L3D|L3M|L3C)) | L3C; //L3D=L/L3M=L(in address mode)/L3C=L

    for(j=0;j<L3_DELAY;j++);   //tsu(L3) > 190ns

                                //PD[8:6]=L3D:L3C:L3M
    for(i=0;i<8;i++)	        //LSB first
    {
	if(data&0x1)	        //if data's LSB is 'H'
	{
	    rGPBDAT &= ~L3C;	//L3C=L
	    rGPBDAT |= L3D;	//L3D=H		    
	    for(j=0;j<L3_DELAY;j++);	//tcy(L3) > 500ns
	    rGPBDAT |= L3C;	//L3C=H
	    rGPBDAT |= L3D;	//L3D=H
	    for(j=0;j<L3_DELAY;j++);	//tcy(L3) > 500ns
	}
	else		        //if data's LSB is 'L'
	{
	    rGPBDAT &= ~L3C;	//L3C=L
	    rGPBDAT &= ~L3D;	//L3D=L
	    for(j=0;j<L3_DELAY;j++);	//tcy(L3) > 500ns
	    rGPBDAT |= L3C;	//L3C=H
	    rGPBDAT &= ~L3D;	//L3D=L
	    for(j=0;j<L3_DELAY;j++);	//tcy(L3) > 500ns
	}
	data >>=1;
    }
    rGPBDAT= (rGPBDAT&~(L3C|L3M|L3D)) | (L3C|L3M);	//L3M=H,L3C=H
}


void _WrL3Data(unsigned char data,int halt)
{
    unsigned int  i,j;

    if(halt)
    {
        rGPBDAT = (rGPBDAT&~(L3D|L3M|L3C))|L3C;	
	                            //L3C=H(while tstp, L3 interface halt condition)
        for(j=0;j<L3_DELAY;j++);    //tstp(L3) > 190ns
    }

    rGPBDAT = (rGPBDAT&~(L3D|L3M))| (L3C|L3M);
                    	            //L3M=H(in data transfer mode)	
    for(j=0;j<L3_DELAY;j++);	    //tsu(L3)D > 190ns

                                    //PD[8:6]=L3D:L3C:L3M
    for(i=0;i<8;i++)
    {
        if(data&0x1)	            //if data's LSB is 'H'
        {
	    rGPBDAT &= ~L3C;	    //L3C=L
            rGPBDAT |= L3D;	    //L3D=H
            for(j=0;j<L3_DELAY;j++);//tcy(L3) > 500ns
            rGPBDAT |= (L3C|L3D);   //L3C=H,L3D=H
            for(j=0;j<L3_DELAY;j++);//tcy(L3) > 500ns
        }
        else		            //if data's LSB is 'L'
        {
	    rGPBDAT &= ~L3C;	    //L3C=L
	    rGPBDAT &= ~L3D;	    //L3D=L
            for(j=0;j<L3_DELAY;j++);	
	                            //tcy(L3) > 500ns
            rGPBDAT |= L3C;	    //L3C=H
	    rGPBDAT &= ~L3D;	    //L3D=L
            for(j=0;j<L3_DELAY;j++);//tcy(L3) > 500ns
        }
        data>>=1;	            //for check next bit
    }
    rGPBDAT= (rGPBDAT&~(L3D|L3M|L3C))|(L3C|L3M);	
                                    //L3M=H,L3C=H
}


/**
 * SWL_TEST_ME  block is unnessary and
 * sound deivce driver can be done well without that block 
 * and L3 Interface initial value will be override by Application Programs. 
 *
 */

static int Init1341(char mode )
{
        int i;
        rGPBDAT = (rGPBDAT&~(L3M|L3C|L3D))|(L3M|L3C);	/* start condition */
                                /*  rCLKCON default value */
        rGPBUP  = (rGPBUP&~(0x7<<2))   | (0x7<<2);	/* pull-up disable */
	rGPBCON = (rGPBCON&~(0x3f<<4)) | (0x15<<4);

	/*
	 * Interrupt Level setting / Signal Line 
	 * look up  include/asm/arch/uncompress.h 
	 */

    /****** L3 Interface ******/
#if (AUDIO_CODEC_CLOCK == 256)		// test value
	_WrL3Addr(0x14+2); //STATUS (000101xx+10)
	for(i=0;i < 10; i++);
	_WrL3Data(0x60,0); //0,1,10,000,0	: reset,256fs,no DCfilter,iis
	for(i=0;i < 10; i++);

	_WrL3Addr(0x14+2); //STATUS (000101xx+10)
	for(i=0;i < 10; i++);
	_WrL3Data(0x20,0); //0,0,10,000,0	: no reset,256fs,no DCfilter,iis
	for(i=0;i < 10; i++);
    
	_WrL3Addr(0x14+2); //STATUS (000101xx+10)
	for(i=0;i < 10; i++);
	_WrL3Data(0x81,0); //1,0,0,0,0,0,01	: OGS=0,IGS=0,ADC_NI,DAC_NI,sngl speed,AoffDon
	for(i=0;i < 10; i++);
#else
	_WrL3Addr(0x14+2); //STATUS (000101xx+10)
	for(i=0;i < 10; i++);
	_WrL3Data(0x50,0); //0,1,01,000,0	: reset,384fs,no DCfilter,iis
	for(i=0;i < 10; i++);

	_WrL3Addr(0x14+2); //STATUS (000101xx+10)
	for(i=0;i < 10; i++);
	_WrL3Data(0x10,0); //0,0,01,000,0	: no reset,384fs,no DCfilter,iis
	for(i=0;i < 10; i++);
    
	_WrL3Addr(0x14+2); //STATUS (000101xx+10)
	for(i=0;i < 10; i++);
	_WrL3Data(0x81,0); //1,0,0,0,0,0,01	: OGS=0,IGS=0,ADC_NI,DAC_NI,sngl speed,AoffDon
	for(i=0;i < 10; i++);
#endif
	//record
	if(mode)  {
	    _WrL3Addr(0x14+2); //STATUS (000101xx+10)
	    for(i=0;i < 10; i++);
	    _WrL3Data(0xa2,0); //1,0,1,0,0,0,10	: OGS=0,IGS=1,ADC_NI,DAC_NI,sngl speed,AonDoff
	    for(i=0;i < 10; i++);

	    _WrL3Addr(0x14+0); //DATA0 (000101xx+00)
	    for(i=0;i < 10; i++);
	    //ch1
	    _WrL3Data(0x4d,0); //010,011,01	: MS=9dB, Ch1=on Ch2=off, 
	    for(i=0;i < 10; i++);
	}
	//record
}


static inline void l3_s3c2410_send_byte(unsigned char addr, unsigned char dat)
{
 
  swldebug(KERN_INFO " l3_s3c2410_send_byte add %x \n",addr);
        _WrL3Addr(addr);
  swldebug(KERN_INFO " l3_s3c2410_send_byte data %x \n",dat);
        _WrL3Data(dat , 0);
 
}

/* l3_s3c2410_send_msg must send one byte each times */
static void l3_s3c2410_send_msg(struct l3_msg *msg)
{
	int len = msg->len;
	char *p = msg->buf;
			/* S3C2410 don't supports L3MB as like StrongARM
			   Because the S3C2410 is SoftARM */
	swldebug(" l3_s3c2410_send_msg start \n");
	if (len > 1) {
	  while((len--)>1)
	    l3_s3c2410_send_byte(msg->addr,*p++);
 	}
	l3_s3c2410_send_byte(msg->addr, *p);
}

static int l3_s3c2410_xfer(struct l3_adapter *adap, struct l3_msg msgs[], int num)
{
	int i;

	for (i = 0; i < num; i++) {
  	         struct l3_msg *pmsg = &msgs[i]; 

/********
 * Iam sorry for Recording not supported but If you ask me to do so personally,I ..
 		if (pmsg->flags & L3_M_RD)
			l3_s3c2410_recv_msg(pmsg);
			else 
 ***/
		 l3_s3c2410_send_msg(pmsg);
	}

	return num;
}

static struct l3_algorithm l3_s3c2410_algo = {
	name:		"L3 S3C2410 algorithm",
	xfer:		l3_s3c2410_xfer,
};

static DECLARE_MUTEX(s3c2410_lock);

static struct l3_adapter l3_s3c2410_adapter = {
	owner:		THIS_MODULE,
	name:		"l3-s3c2410",
	algo:		&l3_s3c2410_algo,
	lock:		&s3c2410_lock,
};


void IIS_PortSetting(void)
{
#ifdef DUPLICATED_init1342
//----------------------------------------------------------
//   PORT B GROUP
//Ports  :   GPB4    GPB3   GPB2  
//Signal :  L3CLOCK L3DATA L3MODE
//Setting:   OUTPUT OUTPUT OUTPUT 
//           [9:8]   [7:6}  [5:4]
//Binary :     01  ,   01    01 
//----------------------------------------------------------    
    rGPBUP  = (rGPBUP  & ~(0x7<<2) ) | (0x7<<2);   
//The pull up function is disabled GPB[4:2] 1 1100    
   rGPBCON = (rGPBCON & ~(0x3f<<4)) | (0x15<<4); 
//GPB[4:2]=Output(L3CLOCK):Output(L3DATA):Output(L3MODE)
#endif

//----------------------------------------------------------
//   PORT E GROUP
//Ports  :  GPE4    GPE3   GPE2  GPE1    GPE0 
//Signal : I2SSDO  I2SSDI CDCLK I2SSCLK I2SLRCK 
//Binary :   10  ,   10     10 ,  10      10    
//----------------------------------------------------------
    rGPEUP  = (rGPEUP  & ~(0x1f))  | 0x1f;    
//The pull up function is disabled GPE[4:0] 1 1111
    rGPECON = (rGPECON & ~(0x3ff)) | 0x2aa;   
//GPE[4:0]=I2SSDO:I2SSDI:CDCLK:I2SSCLK:I2SLRCK


}

static int __init l3_s3c2410_init(void)
{
	int ret = -ENODEV;
	IIS_PortSetting();


	/* ------- NOTICE----------------- 
         *  Init1341(0) should be moved to 
	 *  drivers/sound/s3c2410-uda1341.c 
	 *
	 */
//	Init1341(0);		/* O : PLAY , 1 : RECORD */

	printk(KERN_INFO "l3 S3C2410 Adapter Initialized \n");
	ret = l3_add_adapter(&l3_s3c2410_adapter);
	return ret;
}

static void __exit l3_s3c2410_exit(void)
{
	l3_del_adapter(&l3_s3c2410_adapter);
}

module_init(l3_s3c2410_init);
module_exit(l3_s3c2410_exit);
