/*
 *  linux/drivers/bootldr/labcopyfs.c
 *
 *  Copyright (C) 2003 Joshua Wise
 *  Bootloader port to Linux Kernel, May 09, 2003
 *
 *  fs module for LAB "copy" command.
 */

#include <linux/bootldr/copy.h>
#include <linux/stat.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/vmalloc.h>

static int getcheck(char* filename)
{
	struct stat sstat;
	
	if (sys_newstat(filename, &sstat) < 0)
		return 0;
	return 1;
};

static int putcheck(char* filename)
{
	return 1;
};

static unsigned char* get(int* count, char* filename)
{
	unsigned char* ptr;
	struct stat sstat;
	int fd;
	
	if (sys_newstat(filename, &sstat) < 0)
		return 0;
	
	*count = sstat.st_size;
//	printk("lab: About to allocate 0x%08x bytes for %s.\n", sstat.st_size, filename);
	
	ptr = vmalloc(sstat.st_size+32);
	if (!ptr)
	{
		printk("lab: AIIIIIIIIIIIIIIIIIGHHH!! out of memory!!\n");
		printk("lab: I guess we just can't allocate 0x%08x bytes???\n", sstat.st_size+32);
		return 0;
 	};
	
//	printk("lab: Success!\n");
	
	if ((fd=sys_open(filename,O_RDONLY,0)) < 0)
	{
		printk("lab: uh. couldn't open the file.\n");
		vfree(ptr);
		return 0;
	};
	
	if (sys_read(fd,ptr,*count) < *count)
	{
		printk("lab: uh. couldn't read from the file.\n");
		sys_close(fd);
		vfree(ptr);
		return 0;
	};
	
	sys_close(fd);
//	printk("lab: read all of %s from fs, backing into labcopy.\n", filename);
	return ptr;
};

static int put(int count, char* data, char* filename)
{
	int fd;
	
	if ((fd=sys_open(filename,O_WRONLY|O_CREAT,S_IRWXU)) < 0)
		return 0;
	
	if (sys_write(fd,data,count) < count)
	{
		sys_close(fd);
		return 0;
	};
	
	sys_close(fd);
	return 1;
};

int labcopyfs_init(void)
{
	lab_copy_addsrc("fs",getcheck,get);
	lab_copy_adddest("fs",putcheck,put);
};

void labcopyfs_cleanup(void)
{	
};

MODULE_AUTHOR("Joshua Wise");
MODULE_DESCRIPTION("LAB copy fs module");
MODULE_LICENSE("GPL");
module_init(labcopyfs_init);
module_exit(labcopyfs_cleanup);
