#include <qlistview.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include "kabc/addresseedialog.h"
#include "select_addressee_base.h"

using namespace KABC;

Addressee AddresseeDialog::getAddressee( QWidget *parent ) {
 
    Addressee result;
    if (!getInterface()) {
        QMessageBox::warning(parent,"Plugin missing", "Plugins for DTM/old Qtopia/Opie\naddressbook missing.\nPlease install\nlibqtopiakabc.so/libopiekabc.so/libdtmkabc.so\nunder $QPEDIR/plugins/korganizer.\nQtopia-plugin needs libqpepim.\nSL7x0 and 5x00 with ROM 3.1\nneed DTM plugin.", 0L );
    } else {

        // qDebug("Start: AddresseeDialog::getAddressee");

        Addressee::List list = getAddresseesFromPlugin();

        SelectAddressee *selAddressee = new SelectAddressee(parent,"SelectAddressee", true);
        QListView *contactList = selAddressee->contactList;
        contactList->setSelectionMode(QListView::Single);
        if (!contactList) {
            Addressee emptyAddressee;
            return emptyAddressee;
        }

        for (uint i=0; i < list.count(); i++) {
            Addressee a = list[i];
            QString fullName = a.formattedName();
            QString defaultEmail = a.preferredEmail();
            //qDebug("Adding " + fullName);
            QListViewItem *item = new QListViewItem(contactList, fullName, defaultEmail);
        } 
        if ( QApplication::desktop()->width() < 480 ) {
            selAddressee->setMinimumWidth( 220 ); 
        } else {
            selAddressee->setMinimumWidth( 440 ); 
        }
        if (selAddressee->exec()) {
            QListViewItem *selectedItem = contactList->selectedItem();
            if (selectedItem) {
                uint i=0;
                for (i=0; i < list.count(); i++) {
                if (list[i].formattedName() == selectedItem->text(0) &&
                    list[i].preferredEmail() == selectedItem->text(1)) { 
                    result = list[i];
                    //qDebug("result %s ", result.uid().latin1());
                    break;
                }
                }
            }
        }
        delete selAddressee;
        //qDebug("End: AddresseeDialog::getAddressee");
    }  
    return result;

}

Addressee::List AddresseeDialog::getAddressees( QWidget *parent ) {
      Addressee::List result;
    if (!getInterface()) {
        QMessageBox::warning(parent,"Plugin missing", "Plugins for DTM/old Qtopia/Opie\naddressbook missing.\nPlease install\nlibqtopiakabc.so/libopiekabc.so/libdtmkabc.so\nunder $QPEDIR/plugins/korganizer.\nQtopia-plugin needs libqpepim.\nSL7x0 and 5x00 with ROM 3.1\nneed DTM plugin.", 0L );
    } else {

        // qDebug("Start: AddresseeDialog::getAddressee");

        Addressee::List list = getAddresseesFromPlugin();

        SelectAddressee *selAddressee = new SelectAddressee(parent,"SelectAddressee", true);
        QListView *contactList = selAddressee->contactList;
        contactList->setSelectionMode(QListView::Multi);
        if (!contactList) {
            return result;
        }

        for (uint i=0; i < list.count(); i++) {
            Addressee a = list[i];
            QString fullName = a.formattedName();
            QString defaultEmail = a.preferredEmail();
            //qDebug("Adding " + fullName);
            QListViewItem *item = new QListViewItem(contactList, fullName, defaultEmail);
        } 
        if ( QApplication::desktop()->width() < 480 ) {
            selAddressee->setMinimumWidth( 220 ); 
        } else {
            selAddressee->setMinimumWidth( 440 ); 
        }
        if (selAddressee->exec()) { 
            QListViewItem *item  = contactList->firstChild ();
            while ( item ) {
                if ( item->isSelected() ) { 
                    uint i=0;
                    for (i=0; i < list.count(); i++) {
                        if (list[i].formattedName() == item->text(0) &&
                            list[i].preferredEmail() == item->text(1)) { 
                            result.append( list[i] );
                            break;
                            
                        }
                    }
                }
                item = item->nextSibling();
            }
           
        }
        delete selAddressee;
        //qDebug("End: AddresseeDialog::getAddressee");
    }  
    return result;
}
