/*
    This file is part of KOrganizer.
    Copyright (c) 1998 Preston Brown
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include <qlayout.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <kmessagebox.h>

#include <libkdepim/kdateedit.h>

#include "koglobals.h"
#include "koprefs.h"

#include "calendarview.h"
#include "koviewmanager.h"
#include "searchdialog.h"
#include "searchdialog.moc"

SearchDialog::SearchDialog(Calendar *calendar,CalendarView *parent)
    : KDialogBase(Plain,i18n("KO/Pi Find "),User1|Close,User1,parent,0,false,false,
                  i18n("&Find"))
{
    mCalendar = calendar;
    QFrame *topFrame = plainPage();
    QVBoxLayout *layout = new QVBoxLayout(topFrame,0,spacingHint());

    // Search expression
    QHBoxLayout *subLayout = new QHBoxLayout();
    layout->addLayout(subLayout);

    searchLabel = new QLabel(topFrame);
    searchLabel->setText(i18n("Search for:"));
    subLayout->addWidget(searchLabel);

    searchEdit = new QLineEdit(topFrame);
    subLayout->addWidget(searchEdit);
    searchEdit->setText("*"); // Find all events by default
    searchEdit->setFocus();
    connect(searchEdit, SIGNAL(textChanged ( const QString & )),this,SLOT(searchTextChanged( const QString & )));
    connect(searchEdit, SIGNAL( returnPressed () ),this,SLOT(doSearch()));
    // Subjects to search
    // QGroupBox *subjectGroup = new QGroupBox(1,Vertical,i18n("Search In"),
    //                                        topFrame);



    QHBox *incidenceGroup = new QHBox( topFrame );
    layout->addWidget(incidenceGroup);

    mSearchEvent = new QCheckBox(i18n("Events"),incidenceGroup);
    mSearchEvent->setChecked(true);
    mSearchTodo = new QCheckBox(i18n("Todos"),incidenceGroup);
    mSearchJournal = new QCheckBox(i18n("Journals"),incidenceGroup);

    QHBox *subjectGroup = new QHBox( topFrame );
    layout->addWidget(subjectGroup);

    mSummaryCheck = new QCheckBox(i18n("Summaries"),subjectGroup);
    mSummaryCheck->setChecked(true);
    mDescriptionCheck = new QCheckBox(i18n("Descriptions"),subjectGroup);
    mCategoryCheck = new QCheckBox(i18n("Categories"),subjectGroup);


    // Date range
    // QGroupBox *rangeGroup = new QGroupBox(1,Horizontal,i18n("Date Range"),
    //                                    topFrame);
    // layout->addWidget(rangeGroup);

    QWidget *rangeWidget = new QWidget(topFrame);
    QHBoxLayout *rangeLayout = new QHBoxLayout(rangeWidget,0,spacingHint());

    rangeLayout->addWidget(new QLabel(i18n("From:"),rangeWidget));
    mStartDate = new KDateEdit(rangeWidget);
    rangeLayout->addWidget(mStartDate);
    rangeLayout->addWidget(new QLabel(i18n("To:"),rangeWidget));
    mEndDate = new KDateEdit(rangeWidget);
    mEndDate->setDate(QDate::currentDate().addDays(365));
    rangeLayout->addWidget(mEndDate);

    // mInclusiveCheck = new QCheckBox(i18n("Events have to be completely included"), topFrame);
    //mInclusiveCheck->setChecked(false);
    layout->addWidget(rangeWidget);
    //layout->addWidget(mInclusiveCheck);
    // Subjects to search
 

    // Results list view
    listView = new KOListView(mCalendar,topFrame);
    //listView->showDates();


    layout->addWidget(listView);

    //   if ( KOPrefs::instance()->mCompactDialogs ) {
    //     KOGlobals::fitDialogToScreen( this, true );
    //   }

    listView->readSettings(KOGlobals::config(),"SearchListView Layout");
    connect(this,SIGNAL(user1Clicked()),SLOT(doSearch()));
    QPushButton *CloseButton = findButton(  Close  );
    //connect(CloseButton,SIGNAL(clicked()),listView, SLOT(clear()));

}

SearchDialog::~SearchDialog()
{
  
}
void SearchDialog::accept()
{
    doSearch();
}
void SearchDialog::updateList()
{
    //listView->updateList();
    if ( isVisible() ) {
        updateView();
        //qDebug("SearchDialog::updated ");
    }
    else {
        listView->clear();
        //qDebug("SearchDialog::cleared ");

    }
}
void SearchDialog::searchTextChanged( const QString &_text )
{
    enableButton( KDialogBase::User1, !_text.isEmpty() );
}

void SearchDialog::doSearch()
{
    QRegExp re;

    re.setWildcard(true); // most people understand these better.
    re.setCaseSensitive(false);
    re.setPattern(searchEdit->text());
    if (!re.isValid() ) {
        KMessageBox::sorry(this,
                           i18n("Invalid search expression,\ncannot perform "
                                "the search.\nPlease enter a search expression\n"
                                "using the wildcard characters\n '*' and '?'"
                                "where needed."));
        return;
    }

    search(re);

    listView->setStartDate( mStartDate->date() );
    listView->showEvents(mMatchedEvents);
    listView->addTodos(mMatchedTodos);
    listView->addJournals(mMatchedJournals);

    if (mMatchedEvents.count() + mMatchedJournals.count() + mMatchedTodos.count() == 0) {
        KMessageBox::information(this,
                                 i18n("No event/todo were found matching\nyour search expression.\nUse the wildcard characters\n ' * ' and ' ? ' where needed."));
        setCaption(i18n("KO/Pi Find "));
    } else {
        QString mess; 
        mess = mess.sprintf( i18n("%d item(s) found."), mMatchedEvents.count()+ mMatchedJournals.count() + mMatchedTodos.count() );
        setCaption( i18n("KO/Pi Find: ") + mess);

    }
}
void SearchDialog::updateConfig()
{
    listView->updateConfig();
}
void SearchDialog::updateView()
{
 
    QRegExp re;
    re.setWildcard(true); // most people understand these better.
    re.setCaseSensitive(false);
    re.setPattern(searchEdit->text());
    if (re.isValid()) {
        search(re);
    } else {
        mMatchedEvents.clear();
        mMatchedTodos.clear();
        mMatchedJournals.clear();
    }
    listView->setStartDate( mStartDate->date() );
    listView->showEvents(mMatchedEvents);
    listView->addTodos(mMatchedTodos);
    listView->addJournals(mMatchedJournals);
}

void SearchDialog::search(const QRegExp &re)
{
    QPtrList<Event> events = mCalendar->events( mStartDate->date(),
                                                mEndDate->date(),
                                                false /*mInclusiveCheck->isChecked()*/ );

    mMatchedEvents.clear();
    if ( mSearchEvent->isChecked() ) {
        Event *ev;
        for(ev=events.first();ev;ev=events.next()) {
            if (mSummaryCheck->isChecked()) {
#if QT_VERSION >= 300
                if (re.search(ev->summary()) != -1) 
#else
                    if (re.match(ev->summary()) != -1) 
#endif
                        {
                            mMatchedEvents.append(ev);
                            continue;
                        }
            }
            if (mDescriptionCheck->isChecked()) {
#if QT_VERSION >= 300
                if (re.search(ev->description()) != -1) 
#else
                    if (re.match(ev->description()) != -1) 
#endif
                        {    
                            mMatchedEvents.append(ev);
                            continue;
                        }
            }
            if (mCategoryCheck->isChecked()) {
#if QT_VERSION >= 300
                if (re.search(ev->categoriesStr()) != -1) 
#else
                    if (re.match(ev->categoriesStr()) != -1) 
#endif
                        {
                            mMatchedEvents.append(ev);
                            continue;
                        }
            }
        }
    }
    QPtrList<Todo> todos = mCalendar->todos( );
    mMatchedTodos.clear();
    if ( mSearchTodo->isChecked() ) {
        Todo *tod;
        for(tod=todos.first();tod;tod=todos.next()) {
            if (mSummaryCheck->isChecked()) {
#if QT_VERSION >= 300
                if (re.search(tod->summary()) != -1) 
#else
                    if (re.match(tod->summary()) != -1) 
#endif
                        {
                            mMatchedTodos.append(tod);
                            continue;
                        }
            }
            if (mDescriptionCheck->isChecked()) {
#if QT_VERSION >= 300
                if (re.search(tod->description()) != -1) 
#else
                    if (re.match(tod->description()) != -1) 
#endif
                        {
                            mMatchedTodos.append(tod);
                            continue;
                        }
            }
            if (mCategoryCheck->isChecked()) {
#if QT_VERSION >= 300
                if (re.search(tod->categoriesStr()) != -1) 
#else
                    if (re.match(tod->categoriesStr()) != -1) 
#endif
                        {                                 
                            mMatchedTodos.append(tod);
                            continue;
                        }
            }
        }
    }
    mMatchedJournals.clear();
    if (mSearchJournal->isChecked() ) {
        QPtrList<Journal> journals = mCalendar->journals( );
        Journal* journ;
        
        for(journ=journals.first();journ;journ=journals.next()) {
            if ( journ->dtStart().date() <= mEndDate->date() 
                 &&journ->dtStart().date() >= mStartDate->date()) {
#if QT_VERSION >= 300
                if (re.search(journ->description()) != -1) 
#else
                    if (re.match(journ->description()) != -1) 
#endif
                        {
                            mMatchedJournals.append(journ);
                            continue;
                        }
            }
        }
    }

}
void SearchDialog::keyPressEvent ( QKeyEvent *e) 
{
 
    e->ignore();
 
}
//mMatchedJournals;
