/*  This file is part of the KDE project
    Copyright (C) 2000-2001 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __dcopobject_h__
#define __dcopobject_h__

#include <qcstring.h>
#include <qlist.h>
#include <qobject.h>
#include <qvaluelist.h>

// Makros for DCOP interfaces

typedef QValueList<QCString> QCStringList;

#define K_DCOP \
public:        \
  virtual bool process(const QCString &fun, const QByteArray &data, QCString& replyType, QByteArray &replyData); \
  QCStringList functions(); \
  QCStringList interfaces(); \
private:

#define k_dcop public
#define ASYNC void


class DCOPClient;

class DCOPObject : public QObject
{
    Q_OBJECT
public:
    DCOPObject();
    DCOPObject( const QCString &name );
    virtual ~DCOPObject();

    virtual bool process( const QCString &fun, const QByteArray &data,
                          QCString &replyType, QByteArray &replyData );

    virtual QCStringList functions();
    virtual QCStringList interfaces();

    void setObjId( const QCString &name );
    QCString objId() const { return m_objId; }

    // Needed by kdelibs 3.1 
    DCOPClient *callingDcopClient() const { return NULL; }
private:
    QCString m_objId;
};

#endif
