/*
    This file is part of the KDE alarm daemon.
    Copyright (c) 2000 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

// $Id: alarmdialog.cpp,v 1.2 2004/06/29 12:52:18 zautrix Exp $

#include <qhbox.h>
#include <qvbox.h>
#include <qapp.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qfile.h>
#include <qtimer.h>
#include <qsound.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <stdlib.h>
#ifndef _WIN32_
#include <unistd.h>
#include <sys/ioctl.h>
#endif
#include <stdio.h>
#include <fcntl.h>

#ifndef DESKTOP_VERSION
#include <qtopia/alarmserver.h>
#include <qpe/resource.h>
#include <qtopia/sound.h>
#endif     

#include "alarmdialog.h"


AlarmDialog::AlarmDialog(QWidget *parent,const char *name)
    : QDialog (parent, name, true, Qt::WStyle_StaysOnTop ) 
{
    setCaption( "KO/Pi Alarm!" );
    QVBoxLayout* layout = new QVBoxLayout( this);
  QLabel* l = new QLabel("The following event triggered alarm:",this);
  layout->addWidget ( l );
  l->setAlignment( AlignCenter);
  mMessage = new QLabel ( " ", this );
  int fs = 18;
  int fs2 = 12;
  if ( QApplication::desktop()->width() < 480 ) {
      setMaximumSize(220, 260);
      fs2 = 10;
  }
  else {
      setMaximumSize(440, 440);
  }
  layout->setSpacing( 3 );
  layout->setMargin( 3 );

  l->setFont( QFont("helvetica",fs2, QFont::Bold) );
  mMessage->setFont( QFont("helvetica",fs, QFont::Bold) );
  mMessage->setAlignment( AlignCenter);
  l = new QLabel("Missed Alarms:",this);
  l->setAlignment( AlignCenter);
  layout->addWidget ( mMessage );
  layout->addWidget ( l );
  mMissedAlarms= new QLabel ( "", this );
  mMissedAlarms->setAlignment( AlignCenter);

  playSoundTimer = new QTimer( this );
  connect ( playSoundTimer, SIGNAL( timeout()  ), this, SLOT (playSound() ) );

  playSoundTimer->stop();
  
  layout->addWidget ( mMissedAlarms );
  QHBox *suspendBox = new QHBox( this );
  suspendBox->setSpacing(3);
  layout->addWidget ( suspendBox );
  (void)new QLabel("Suspend duration (minutes):",suspendBox);
  mSuspendSpin = new QSpinBox(1,1440,1,suspendBox);
  mSuspendSpin->setValue(7);  // default suspend duration
  QHBox * bbox  = new QHBox ( this );
  layout->addWidget ( bbox );
  bbox->layout()->setSpacing( 5 );
  QPushButton* suspend = new QPushButton( "Suspend", bbox);
  QPushButton* silen = new QPushButton( " Stop sound ", bbox);
  QPushButton* okbut = new QPushButton( "Ok", bbox); 
  connect (silen , SIGNAL( clicked() ), this, SLOT (silent() ) ); 
  connect (suspend , SIGNAL( clicked() ), this, SLOT (slotSuspend() ) );
  connect (okbut , SIGNAL( clicked() ), this, SLOT (slotOk() ) );
#ifndef _WIN32_
  if ( QFile::exists ( "/dev/sharp_led" ) )
      fd_led = open ( "/dev/sharp_led", O_RDWR|O_NONBLOCK );
  else
#endif
      fd_led = 0;
  statusLED.which = SHARP_LED_SALARM;
  mSilent = false;
  mSuspendCounter = 0;
  setServerNotification( true );
}
void AlarmDialog::reject () 
{
    QTimer::singleShot ( 3000, this, SLOT (suspend())  );
    slotSuspend();
}
AlarmDialog::~AlarmDialog()
{
}
void AlarmDialog::silent () 
{
    mSilent = true;
}
void AlarmDialog::accept()
{
    slotOk();
}

void AlarmDialog::suspend()
{
#ifdef DESKTOP_VERSION

#else
    Sound::soundAlarm ();
#endif
}
void AlarmDialog::slotOk()
{
    mStopAlarm = true;
    mMissedAlarms->setText("");
    mMessage->setText("");
#ifndef _WIN32_
    if (  fd_led > 0 ) {
        statusLED.status =  LED_SALARM_OFF ;
        ioctl (fd_led, SHARP_LED_SETSTATUS, &statusLED);
    }
#endif
    QDialog::accept();
}

void AlarmDialog::slotSuspend() 
{
    //qDebug("AlarmDialog::suspend() ");  // emit suspendSignal(mSuspendSpin->value());
   mStopAlarm = true;
   QDateTime nextA = QDateTime::currentDateTime().addSecs( mSuspendSpin->value() * 60 );
   QString mess = "suspend_alarm" +mFileName+"+++" ;
   if ( mMessage->text().left( 10 ) !="Suspended:" )
       mess += "Suspended:\n";
   mess +=mMessage->text();
#ifndef DESKTOP_VERSION
   if ( mServerNotification )
       AlarmServer::addAlarm ( nextA,"koalarm",mess.latin1());
#endif 
    emit addAlarm( nextA , mess  );  
   slotOk();
}

void AlarmDialog::setServerNotification( bool b )
{
    mServerNotification = b;
}
int  AlarmDialog::getSuspendTime( )
{
    return mSuspendSpin->value();

}
void AlarmDialog::setSuspendTime( int val )
{
    mSuspendSpin->setValue( val );
}
bool AlarmDialog::eventNotification( QString mess, int replay ,  QString fn, bool playwav, int pause , int suspendtimes)
{
    if ( mess.left( 9) != "Suspended" )
        mSuspendCounter = suspendtimes;
    mPauseCount = pause;
    mFileName = fn;
    mPlayWav = playwav;
    if ( !QFile::exists( fn ) )
        mFileName = "";
    alarmCounter = 0 ;
    maxAlarmReplay = replay ;
    mStopAlarm = false;
    mSilent = false;
    if ( mMissedAlarms->text() == "" )
        mMissedAlarms->setText( mMessage->text());
    else
        mMissedAlarms->setText( mMessage->text()+ "\n" + mMissedAlarms->text() );
    if ( mMissedAlarms->text().length() > 180 )
        mMissedAlarms->setText(mMissedAlarms->text().left ( 180 ));
    mMessage->setText(mess);
    int w =sizeHint().width() ;
    int h = sizeHint().height() ;
    int dw = QApplication::desktop()->width();
    int dh = QApplication::desktop()->height();
    setGeometry( (dw-w)/2, (dh - h )/2 ,w,h );
    show();
    raise();
    qApp->processEvents();
    repaint();
    qApp->processEvents();

#ifndef _WIN32_
    if (  fd_led > 0 ) {
        statusLED.status =  LED_SALARM_ON ;
        ioctl (fd_led, SHARP_LED_SETSTATUS, &statusLED);
    }
#endif
    playSoundTimer->start( 1000, true );
    return true;
 
}


void  AlarmDialog::playSound ()
{
    if (mStopAlarm )
        return;
    showNormal();
    setActiveWindow();
    setFocus();
    raise();
    
    qApp->processEvents();
    if (  alarmCounter < maxAlarmReplay && ! mSilent) {
        ++alarmCounter;
        if ( !mPlayWav || mFileName.length() < 2 ) {

#ifndef DESKTOP_VERSION
            Sound::soundAlarm ();
#endif
        } else {
            QSound::play ( mFileName );
            //qDebug("BEEP!");
        }
    } else {
        if ( ! mSilent && mSuspendCounter > 0 ) {
            --mSuspendCounter;
            reject (); 
            hide();
            return;
        } 
    }
    playSoundTimer->start( mPauseCount * 1000, true );
}
