#include <gtk/gtk.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <string.h>
#include <libgnomevfs/gnome-vfs.h>
#include "main.h"

/* the connection to the xml file */
GTodoClient *cl = NULL;
void parse_command (int argc, char **argv);
gint xsize=-1, ysize=-1, xpos=-1, ypos=-1;
void backend_changed();
/* settings struct */
sets settings;
GConfClient* client;    

void configuration_restore_size(GConfClient *client);
void configuration_restore_place(GConfClient *client);

GConfEngine* gconf_engine_get_default (void); 

int main(int argc, char **argv){

	bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);
	setlocale(LC_ALL,"");

	parse_command (argc, argv);

	gtk_init(&argc, &argv);
	gconf_init(argc, argv, NULL);
	gnome_vfs_init();

	client = gconf_client_get_default();
	gconf_client_add_dir(client,
			"/apps/gtodo/prefs",
			GCONF_CLIENT_PRELOAD_NONE,
			NULL);
	gconf_client_add_dir(client,
			"/apps/gtodo/view",
			GCONF_CLIENT_PRELOAD_NONE,
			NULL);


	/* Enable tray by default..  user won't know if he/she doesnt have tray */
	/* this is just for people who don't want it in there tray */
	settings.place = gconf_client_get_bool(client, "/apps/gtodo/prefs/restore-position",NULL);;
	settings.size =  gconf_client_get_bool(client, "/apps/gtodo/prefs/restore-size",NULL);;
	settings.ask_delete_category 	=  gconf_client_get_bool(client, "/apps/gtodo/prefs/ask-delete-category",NULL);
	settings.show_date_column 	= gconf_client_get_bool(client, "/apps/gtodo/prefs/show-due-column",NULL);
	/* this is kinda (thanks gtk :-/) buggy.. gtk need fix first */
	settings.list_tooltip		= gconf_client_get_bool(client, "/apps/gtodo/prefs/show-tooltip",NULL);
	/* auto purge is default on.. */
	settings.auto_purge		= gconf_client_get_bool(client, "/apps/gtodo/prefs/auto-purge",NULL);
	/* set default auto purge to a week */	
	settings.purge_days		= gconf_client_get_int(client, "/apps/gtodo/prefs/auto-purge-days",NULL);
	settings.due_color 		= g_strdup(gconf_client_get_string(client, "/apps/gtodo/prefs/due-color",NULL));
	settings.due_today_color 	= g_strdup(gconf_client_get_string(client, "/apps/gtodo/prefs/due-today-color",NULL));
	settings.due_in_days_color 	= g_strdup(gconf_client_get_string(client, "/apps/gtodo/prefs/due-in-days-color",NULL));
	settings.due_days 		= gconf_client_get_int(client, "/apps/gtodo/prefs/due-days",NULL);
	settings.sorttype 		= gconf_client_get_int(client, "/apps/gtodo/prefs/sort-type",NULL);	
	settings.sortorder 		= gconf_client_get_int(client, "/apps/gtodo/prefs/sort-order",NULL);	
	/* treeview hide preferences.. */
	settings.hide_done 		= gconf_client_get_bool(client, "/apps/gtodo/prefs/hide-done",NULL);
	settings.hide_due 		= gconf_client_get_bool(client, "/apps/gtodo/prefs/hide-due",NULL);
	settings.hide_nodate 		=  gconf_client_get_bool(client, "/apps/gtodo/prefs/hide-nodate",NULL);
	settings.hl_indays		= gconf_client_get_bool(client,"/apps/gtodo/prefs/hl-indays",NULL);
	settings.hl_due			= gconf_client_get_bool(client,"/apps/gtodo/prefs/hl-due",NULL);
	settings.hl_today		= gconf_client_get_bool(client,"/apps/gtodo/prefs/hl-today",NULL);
	pref_gconf_set_notifications(client);
	/* load the config file settings .. */
	cl = gtodo_client_new_default(NULL);
	if(cl == NULL)
	{
		g_error("Failed to open, or create the default gtodo client.\n");
		return 1;
	}
	/* create the main window */
	gui_create_main_window();


	if(settings.auto_purge) get_all_past_purge();

	if(gconf_client_get_int(client, "/apps/gtodo/prefs/size-x",NULL) != -1 &&  gconf_client_get_int(client, "/apps/gtodo/prefs/size-x",NULL) != -1 && settings.size) gtk_window_resize(GTK_WINDOW(mw.window),  gconf_client_get_int(client, "/apps/gtodo/prefs/size-x",NULL),  gconf_client_get_int(client, "/apps/gtodo/prefs/size-y",NULL));
	if(gconf_client_get_int(client, "/apps/gtodo/prefs/pos-x",NULL) != -1 && gconf_client_get_int(client, "/apps/gtodo/prefs/pos-y",NULL) != -1 && settings.place)     gtk_window_move(GTK_WINDOW(mw.window), gconf_client_get_int(client, "/apps/gtodo/prefs/pos-x",NULL), gconf_client_get_int(client, "/apps/gtodo/prefs/pos-y",NULL));
	/* read the categorys */
	{
		int i =  gconf_client_get_int(client, "/apps/gtodo/view/last-category",NULL);
		read_categorys();
		gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option),i);
	}
	/* nasty thing to fix the tooltip in the list */
	if(settings.list_tooltip) gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(mw.treeview), FALSE);			


	gtk_widget_show_all(mw.window);
	gtodo_client_set_changed_callback(cl,(void *)backend_changed ,NULL);
	g_timeout_add(300000, (GSourceFunc)check_for_notification_event, NULL);
	check_for_notification_event();

	gtk_main();
	return 0;
}


/************************
  save the xml file and quit
  saving xml isnt needed anymore, this is done on the fly
 ************************/
void quit_program()
{
	if(mw.window)windows_moved(mw.window);
	gtk_main_quit();
}
void startup_new_item()
{
	g_print("add\n");
	gui_add_todo_item(NULL,GINT_TO_POINTER(0), 0);
}
void startup_view_item(guint32 buf)
{
	gui_add_todo_item(NULL, GINT_TO_POINTER(-1), buf);
}

void parse_command (int argc, char **argv) 
{
	int i;
	if(argc < 2) return;
	for(i=1; i< argc; i++) 
	{
		if(!strncmp(argv[i], "-?", 2) || !strncmp(argv[i], "--help", 6) || !strncmp(argv[i], _("--help"), strlen(_("--help"))))
		{
			printf(_("gtodo v%s\ngtodo has to following commandline options:\n-s	--show	Shows an todo item by there id.\n only usefull for programs calling gtodo\n-?	--help	This Message.\n"), VERSION);
			exit(1);
		}
		else if (!strncmp(argv[i], "-s", 2) || !strncmp(argv[i], "--show", 6) || !strncmp(argv[i], _("--show"), strlen(_("--show"))))
		{
			if(argc < 1 || argv[i+1]  == NULL)
			{
				g_print(_("The --show command an todo item ID as argument\n"));
				exit(1);
			}
			i++;
			gtk_init_add((GtkFunction)startup_view_item,(gpointer)(gint)g_ascii_strtoull(argv[i], NULL, 0));
		}
		else if (!strncmp(argv[i], "-n", 2) || !strncmp(argv[i], "--new", 6) || !strncmp(argv[i], _("--new"), strlen(_("--new"))))
		{
			i++;
			gtk_init_add((GtkFunction)startup_new_item,NULL);
		}

		else{
			printf(_("gtodo v%s\nRun with -? or --help to see the availible commandline options\n"), VERSION);
			exit(1);
		}
	}
}

void backend_changed()
{
	category_changed();    
}

