.\" $XFree86: xc/programs/Xserver/hw/xfree86/XF86Config.man,v 1.30 2005/03/03 03:30:41 dawes Exp $
.\"
.\" Copyright (c) 1994-2005 by The XFree86 Project, Inc.
.\" All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject
.\" to the following conditions:
.\"
.\"   1.  Redistributions of source code must retain the above copyright
.\"       notice, this list of conditions, and the following disclaimer.
.\"
.\"   2.  Redistributions in binary form must reproduce the above copyright
.\"       notice, this list of conditions and the following disclaimer
.\"       in the documentation and/or other materials provided with the
.\"       distribution, and in the same place and form as other copyright,
.\"       license and disclaimer information.
.\"
.\"   3.  The end-user documentation included with the redistribution,
.\"       if any, must include the following acknowledgment: "This product
.\"       includes software developed by The XFree86 Project, Inc
.\"       (http://www.xfree86.org/) and its contributors", in the same
.\"       place and form as other third-party acknowledgments.  Alternately,
.\"       this acknowledgment may appear in the software itself, in the
.\"       same form and location as other such third-party acknowledgments.
.\"
.\"   4.  Except as contained in this notice, the name of The XFree86
.\"       Project, Inc shall not be used in advertising or otherwise to
.\"       promote the sale, use or other dealings in this Software without
.\"       prior written authorization from The XFree86 Project, Inc.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
.\" WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
.\" IN NO EVENT SHALL THE XFREE86 PROJECT, INC OR ITS CONTRIBUTORS BE
.\" LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
.\" OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
.\" OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
.\" BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
.\" WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
.\" OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
.\" EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.\" Copyright  2003, 2004, 2005 David H. Dawes.
.\" Copyright  2003, 2004, 2005 X-Oz Technologies.
.\" All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\" 
.\"  1. Redistributions of source code must retain the above copyright
.\"     notice, this list of conditions, and the following disclaimer.
.\"
.\"  2. Redistributions in binary form must reproduce the above
.\"     copyright notice, this list of conditions and the following
.\"     disclaimer in the documentation and/or other materials provided
.\"     with the distribution.
.\" 
.\"  3. The end-user documentation included with the redistribution,
.\"     if any, must include the following acknowledgment: "This product
.\"     includes software developed by X-Oz Technologies
.\"     (http://www.x-oz.com/)."  Alternately, this acknowledgment may
.\"     appear in the software itself, if and wherever such third-party
.\"     acknowledgments normally appear.
.\"
.\"  4. Except as contained in this notice, the name of X-Oz
.\"     Technologies shall not be used in advertising or otherwise to
.\"     promote the sale, use or other dealings in this Software without
.\"     prior written authorization from X-Oz Technologies.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
.\" IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL X-OZ TECHNOLOGIES OR ITS CONTRIBUTORS
.\" BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
.\" OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
.\" OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
.\" BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
.\" WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
.\" OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
.\" EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH XF86Config __filemansuffix__ __vendorversion__
.SH NAME
XF86Config - Configuration File for XFree86
.SH INTRODUCTION
.B XFree86
supports several mechanisms for supplying/obtaining configuration and
run-time parameters: command line options, environment variables, the
XF86Config configuration file, auto-detection, and fallback defaults.
When the same information is supplied in more than one way, the highest
precedence mechanism is used.  The list of mechanisms is ordered from
highest precedence to lowest.  Note that not all parameters can be
supplied via all methods.  The available command line options and
environment variables (and some defaults) are described in the Xserver(1)
and XFree86(1) manual pages.  Most configuration file parameters, with
their defaults, are described below.  Driver and module specific
configuration parameters are described in the relevant driver or module
manual page.
.PP
Starting with version 4.4,
.B XFree86
has support for generating a usable configuration at run-time when no
.B XF86Config
file is provided.  The initial version of this automatic configuration
support is targeted at the most popular hardware and software platforms
supported by XFree86.  Some details about how this works can be found
in the XFree86(1) and getconfig(1) manual pages.
.PP
Starting with version 4.5, it is possible for this automatically generated
configuration to supplement a partial static configuration.  The partial
static configuration can be used to provide non-default configuration
details for things that are not currently handled by the automatic
configuration mechanism.
.SH DESCRIPTION
.B XFree86
uses a configuration file called
.B XF86Config
for its initial setup.  This configuration file is searched for in the
following places when the server is started as a normal user:
.PP
.RS 4
.nf
.IR /etc/X11/ <cmdline>
.IR __projectroot__/etc/X11/ <cmdline>
.IB /etc/X11/ $XF86CONFIG
.IB __projectroot__/etc/X11/ $XF86CONFIG
.I /etc/X11/XF86Config-4
.I /etc/X11/XF86Config
.I /etc/XF86Config
.IR __projectroot__/etc/X11/XF86Config. <hostname>
.I __projectroot__/etc/X11/XF86Config-4
.I __projectroot__/etc/X11/XF86Config
.IR __projectroot__/lib/X11/XF86Config. <hostname>
.I __projectroot__/lib/X11/XF86Config-4
.I __projectroot__/lib/X11/XF86Config
.fi
.RE
.PP
where
.I <cmdline>
is a relative path (with no ".." components) specified with the
.B \-xf86config
command line option,
.B $XF86CONFIG
is the relative path (with no ".." components) specified by that
environment variable, and
.I <hostname>
is the machine's hostname as reported by gethostname(3).
.PP
When the XFree86 server is started by the "root" user, the config file
search locations are as follows:
.PP
.RS 4
.nf
<cmdline>
.IR /etc/X11/ <cmdline>
.IR __projectroot__/etc/X11/ <cmdline>
.B $XF86CONFIG
.IB /etc/X11/ $XF86CONFIG
.IB __projectroot__/etc/X11/ $XF86CONFIG
.BI $HOME /XF86Config
.I /etc/X11/XF86Config-4
.I /etc/X11/XF86Config
.I /etc/XF86Config
.IR __projectroot__/etc/X11/XF86Config. <hostname>
.I __projectroot__/etc/X11/XF86Config-4
.I __projectroot__/etc/X11/XF86Config
.IR __projectroot__/lib/X11/XF86Config. <hostname>
.I __projectroot__/lib/X11/XF86Config-4
.I __projectroot__/lib/X11/XF86Config
.fi
.RE
.PP
where
.I <cmdline>
is the path specified with the
.B \-xf86config
command line option (which may be absolute or relative),
.B $XF86CONFIG
is the path specified by that
environment variable (absolute or relative),
.B $HOME
is the path specified by that environment variable (usually the home
directory), and
.I <hostname>
is the machine's hostname as reported by gethostname(3).
.PP
The
.B XF86Config
file is composed of a number of sections which may be present in any
order.  Each section has
the form:
.PP
.RS 4
.nf
.BI "Section  \*q" SectionName \*q
.RI "    " SectionEntry
    ...
.B EndSection
.fi
.RE
.PP
The section names are:
.PP
.RS 4
.nf
.BR "Files          " "File pathnames"
.BR "ServerFlags    " "Server flags"
.BR "Module         " "Dynamic module loading"
.BR "InputDevice    " "Input device description"
.BR "Device         " "Graphics device description"
.BR "VideoAdaptor   " "Xv video adaptor description"
.BR "Monitor        " "Monitor description"
.BR "Modes          " "Video modes descriptions"
.BR "Screen         " "Screen configuration"
.BR "ServerLayout   " "Overall layout"
.BR "DRI            " "DRI-specific configuration"
.BR "Vendor         " "Vendor-specific configuration"
.fi
.RE
.PP
The following obsolete section names are still recognised for compatibility
purposes.  In new config files, the
.B InputDevice
section should be used instead.
.PP
.RS 4
.nf
.BR "Keyboard       " "Keyboard configuration"
.BR "Pointer        " "Pointer/mouse configuration"
.fi
.RE
.PP
The old
.B XInput
section is no longer recognised.
.PP
The
.B ServerLayout
sections are at the highest level.  They bind together the input and
output devices that will be used in a session.  The input devices
are described in the
.B InputDevice
sections.  Output devices usually consist of multiple independent
components (e.g., and graphics board and a monitor).  These multiple
components are bound together in the
.B Screen
sections, and it is these that are referenced by the
.B ServerLayout
section.  Each
.B Screen
section binds together a graphics board and a monitor.  The graphics
boards are described in the
.B Device
sections, and the monitors are described in the
.B Monitor
sections.
.PP
Config file keywords are case-insensitive, and "_" characters are
ignored.  Most strings (including
.B Option
names) are also case-insensitive, and insensitive to white space and
"_" characters.
.PP
Each config file entry usually takes up a single line in the file.
They consist of a keyword, which is possibly followed by one or
more arguments, with the number and types of the arguments depending
on the keyword.  The argument types are:
.PP
.RS 4
.nf
.BR "Integer     " "an integer number in decimal, hex or octal"
.BR "Real        " "a floating point number"
.BR "String      " "a string enclosed in double quote marks (\*q)"
.fi
.RE
.PP
Note: hex integer values must be prefixed with "0x", and octal values
with "0".
.PP
A special keyword called
.B Option
may be used to provide free-form data to various components of the server.
The
.B Option
keyword takes either one or two string arguments.  The first is the option
name, and the optional second argument is the option value.  Some commonly
used option value types include:
.PP
.RS 4
.nf
.BR "Integer     " "an integer number in decimal, hex or octal"
.BR "Real        " "a floating point number"
.BR "String      " "a sequence of characters"
.BR "Boolean     " "a boolean value (see below)"
.BR "Frequency   " "a frequency value (see below)"
.fi
.RE
.PP
Note that
.I all
.B Option
values, not just strings, must be enclosed in quotes.
.PP
Boolean options may optionally have a value specified.  When no value
is specified, the option's value is
.BR TRUE .
The following boolean option values are recognised as
.BR TRUE :
.PP
.RS 4
.BR 1 ,
.BR on ,
.BR true ,
.B yes
.RE
.PP
and the following boolean option values are recognised as
.BR FALSE :
.PP
.RS 4
.BR 0 ,
.BR off ,
.BR false ,
.B no
.RE
.PP
If an option name is prefixed with
.RB \*q No \*q,
then the option value is negated.
.PP
Example: the following option entries are equivalent:
.PP
.RS 4
.nf
.B "Option \*qAccel\*q   \*qOff\*q"
.B "Option \*qNoAccel\*q"
.B "Option \*qNoAccel\*q \*qOn\*q"
.B "Option \*qAccel\*q   \*qfalse\*q"
.B "Option \*qAccel\*q   \*qno\*q"
.fi
.RE
.PP
Frequency option values consist of a real number that is optionally
followed by one of the following frequency units:
.PP
.RS 4
.BR Hz ,
.BR k ,
.BR kHz ,
.BR M ,
.B MHz
.RE
.PP
When the unit name is omitted, the correct units will be determined from
the value and the expectations of the appropriate range of the value.
It is recommended that the units always be specified when using frequency
option values to avoid any errors in determining the value.
.SH FILES SECTION
The config file may have multiple
.B Files
sections.  These are used to specify some path names required by the
server.  Earlier
.B Files
sections have priority over later sections.  This means that a path name
specified in a
.B Files
section cannot be overridden by a later
.B Files
section (this behaviour may change in the future).  Some of these paths
can also be set from the command line (see Xserver(1) and XFree86(1)).
The command line settings override the values specified in the config
file.  The
.B Files
section is optional, as are all of the entries that may appear in it.
.PP
The entries that can appear in this section are:
.TP 7
.BI "Identifier \*q" name \*q
specifies an optional identifying name for the
.B Files
section.
.TP 7
.BI "FontPath \*q" path \*q
sets the search path for fonts.  This path is a comma separated list of
font path elements which the XFree86 server searches for font databases.
Multiple
.B FontPath
entries may be specified, and they will be concatenated to build up the
fontpath used by the server.  Font path elements may be either absolute
directory paths, or a font server identifier.  Font server identifiers
have the form:
.PP
.RS 11
.IR <trans> / <hostname> : <port-number>
.RE
.PP
.RS 7
where
.I <trans>
is the transport type to use to connect to the font server (e.g.,
.B unix
for UNIX-domain sockets or
.B tcp
for a TCP/IP connection),
.I <hostname>
is the hostname of the machine running the font server, and
.I <port-number>
is the port number that the font server is listening on (usually 7100).
.PP
When this entry is not specified in the config file, the server falls back
to the compiled-in default font path, which contains the following
font path elements:
.PP
.RS 4
.nf
.I __projectroot__/lib/X11/fonts/misc/
.I __projectroot__/lib/X11/fonts/Speedo/
.I __projectroot__/lib/X11/fonts/Type1/
.I __projectroot__/lib/X11/fonts/CID/
.I __projectroot__/lib/X11/fonts/75dpi/
.I __projectroot__/lib/X11/fonts/100dpi/
.fi
.RE
.PP
The recommended font path contains the following font path elements:
.PP
.RS 4
.nf
.I __projectroot__/lib/X11/fonts/local/
.I __projectroot__/lib/X11/fonts/misc/
.I __projectroot__/lib/X11/fonts/75dpi/:unscaled
.I __projectroot__/lib/X11/fonts/100dpi/:unscaled
.I __projectroot__/lib/X11/fonts/Type1/
.I __projectroot__/lib/X11/fonts/CID/
.I __projectroot__/lib/X11/fonts/Speedo/
.I __projectroot__/lib/X11/fonts/75dpi/
.I __projectroot__/lib/X11/fonts/100dpi/
.fi
.RE
.PP
Font path elements that are found to be invalid are removed from the
font path when the server starts up.
.RE
.TP 7
.BI "RGBPath \*q" path \*q
sets the path name for the RGB color database.
When this entry is not specified in the config file, the server falls back
to the compiled-in default RGB path, which is:
.PP
.RS 11
.I __projectroot__/lib/X11/rgb
.RE
.PP
Note that an implicit
.I .txt
is added to this path if the server was compiled to use text rather than
binary format RGB color databases.
.TP 7
.BI "ModulePath \*q" path \*q
sets the search path for loadable XFree86 server modules.  This path is
a comma separated list of directories which the XFree86 server searches
for loadable modules loading in the order specified.  Multiple
.B ModulePath
entries may be specified, and they will be concatenated to build the
module search path used by the server.
.\" The LogFile keyword is not currently implemented
.ig
.TP 7
.BI "LogFile \*q" path \*q
sets the name of the XFree86 server log file.  The default log file name
is
.PP
.RS 11
.RI __logdir__/XFree86. <n> .log
.RE
.PP
.RS 7
where
.I <n>
is the display number for the XFree86 server.
..
.TP 7
.B Options
Option flags may be specified in
.B Files
sections.
.SH SERVERFLAGS SECTION
The config file may have multiple
.B ServerFlags
sections.  These are used to specify some global XFree86 server options.
Earlier
.B ServerFlags
sections have priority over later sections.  This means that an option
specified in a
.B ServerFlags
section cannot be overridden by a later
.B ServerFlags
section.  Except for the
.B Identifier
entry, all of the entries in this section are
.BR Options ,
although for compatibility purposes some of the old style entries are
still recognised.  Those old style entries are not documented here, and
using them is discouraged.  The
.B ServerFlags
section is optional, as are the entries that may be specified in it.
.PP
.B Options
specified in this section (with the exception of the
.B \*qDefaultServerLayout\*q
.BR Option )
may be overridden by
.B Options
specified in the active
.B ServerLayout
section.  Options with command line equivalents are overridden when their
command line equivalent is used.  Entries recognised by this section
are:
.TP 7
.BI "Identifier \*q" name \*q
specifies an optional identifying name for the
.B ServerFlags
section.
.TP 7
.BI "Option \*qDefaultServerLayout\*q  \*q" layout-id \*q
This specifies the default
.B ServerLayout
section to use in the absence of the
.B \-layout
command line option.
.TP 7
.BI "Option \*qNoTrapSignals\*q  \*q" boolean \*q
This prevents the XFree86 server from trapping a range of unexpected
fatal signals and exiting cleanly.  Instead, the XFree86 server will die
and drop core where the fault occurred.  The default behaviour is
for the XFree86 server to exit cleanly, but still drop a core file.  In
general you never want to use this option unless you are debugging
an XFree86 server problem and know how to deal with the consequences.
.TP 7
.BI "Option \*qDontVTSwitch\*q  \*q" boolean \*q
This disallows the use of the
.BI Ctrl+Alt+F n
sequence (where
.RI F n
refers to one of the numbered function keys).  That sequence is normally
used to switch to another \*qvirtual terminal\*q on operating systems
that have this feature.  When this option is enabled, that key sequence has
no special meaning and is passed to clients.  Default: off.
.TP 7
.BI "Option \*qDontZap\*q  \*q" boolean \*q
This disallows the use of the
.B Ctrl+Alt+Backspace
sequence.  That sequence is normally used to terminate the XFree86 server.
When this option is enabled, that key sequence has no special meaning
and is passed to clients.  Default: off.
.TP 7
.BI "Option \*qDontZoom\*q  \*q" boolean \*q
This disallows the use of the
.B Ctrl+Alt+Keypad-Plus
and
.B Ctrl+Alt+Keypad-Minus
sequences.  These sequences allows you to switch between video modes.
When this option is enabled, those key sequences have no special meaning
and are passed to clients.  Default: off.
.TP 7
.BI "Option \*qDisableVidModeExtension\*q  \*q" boolean \*q
This disables the parts of the VidMode extension used by the xvidtune client
that can be used to change the video modes.  Default: the VidMode extension
is enabled.
.TP 7
.BI "Option \*qAllowNonLocalXvidtune\*q  \*q" boolean \*q
This allows the xvidtune client (and other clients that use the VidMode
extension) to connect from another host.  Default: off.
.TP 7
.BI "Option \*qDisableModInDev\*q  \*q" boolean \*q
This disables the parts of the XFree86-Misc extension that can be used to
modify the input device settings dynamically.  Default: that functionality
is enabled.
.TP 7
.BI "Option \*qAllowNonLocalModInDev\*q  \*q" boolean \*q
This allows a client to connect from another host and change keyboard
and mouse settings in the running server.  Default: off.
.TP 7
.BI "Option \*qAllowMouseOpenFail\*q  \*q" boolean \*q
This allows the server to start up even if the mouse device can't be
opened/initialised.  Default: false.
.TP 7
.BI "Option \*qVTInit\*q  \*q" command \*q
Runs
.I command
after the VT used by the server has been opened.
The command string is passed to "/bin/sh -c", and is run with the
real user's id with stdin and stdout set to the VT.  The purpose
of this option is to allow system dependent VT initialisation
commands to be run.  This option should rarely be needed.  Default: not set.
.TP 7
.BI "Option \*qVTSysReq\*q  \*q" boolean \*q
enables the SYSV-style VT switch sequence for non-SYSV systems
which support VT switching.  This sequence is
.B Alt-SysRq
followed
by a function key
.RB ( Fn ).
This prevents the XFree86 server trapping the
keys used for the default VT switch sequence, which means that clients can
access them.  Default: off.
.TP 7
.BI "Option \*qXkbDisable\*q \*q" boolean \*q
disable/enable the XKEYBOARD extension.  The \-kb command line
option overrides this config file option.  Default: XKB is enabled.
.\" The following four options are "undocumented".
.ig
.TP 7
.BI "Option \*qPciProbe1\*q"
Use PCI probe method 1.  Default: set.
.TP 7
.BI "Option \*qPciProbe2\*q"
Use PCI probe method 2.  Default: not set.
.TP 7
.BI "Option \*qPciForceConfig1\*q"
Force the use PCI config type 1.  Default: not set.
.TP 7
.BI "Option \*qPciForceConfig2\*q"
Force the use PCI config type 2.  Default: not set.
..
.TP 7
.BI "Option \*qBlankTime\*q  \*q" time \*q
sets the inactivity timeout for the blanking phase of the screensaver.
.I time
is in minutes.  This is equivalent to the XFree86 server's `-s' flag,
and the value can be changed at run-time with xset(1).  Default: 10
minutes.
.TP 7
.BI "Option \*qStandbyTime\*q  \*q" time \*q
sets the inactivity timeout for the "standby" phase of DPMS mode.
.I time
is in minutes, and the value can be changed at run-time with xset(1).
Default: 20 minutes.  This is only suitable for VESA DPMS compatible
monitors, and may not be supported by all video drivers.  It is only
enabled for screens that have the
.B \*qDPMS\*q
option set (see the MONITOR section below).
.TP 7
.BI "Option \*qSuspendTime\*q  \*q" time \*q
sets the inactivity timeout for the "suspend" phase of DPMS mode.
.I time
is in minutes, and the value can be changed at run-time with xset(1).
Default: 30 minutes.  This is only suitable for VESA DPMS compatible
monitors, and may not be supported by all video drivers.  It is only
enabled for screens that have the
.B \*qDPMS\*q
option set (see the MONITOR section below).
.TP 7
.BI "Option \*qOffTime\*q  \*q" time \*q
sets the inactivity timeout for the "off" phase of DPMS mode.
.I time
is in minutes, and the value can be changed at run-time with xset(1).
Default: 40 minutes.  This is only suitable for VESA DPMS compatible
monitors, and may not be supported by all video drivers.  It is only
enabled for screens that have the
.B \*qDPMS\*q
option set (see the MONITOR section below).
.TP 7
.BI "Option \*qPixmap\*q  \*q" bpp \*q
This sets the pixmap format to use for depth 24.  Allowed values for
.I bpp
are 24 and 32.  Default: 32 unless driver constraints don't allow this
(which is rare).  Note: some clients don't behave well when this value
is set to 24.
.TP 7
.BI "Option \*qPC98\*q  \*q" boolean \*q
Specify that the machine is a Japanese PC-98 machine.  This should not
be enabled for anything other than the Japanese-specific PC-98
architecture.  Default: auto-detected.
.\" Doubt this should be documented.
.ig
.TP 7
.BI "Option \*qEstimateSizesAggressively\*q  \*q" value \*q
This option affects the way that bus resource sizes are estimated.
Default: 0.
..
.TP 7
.BI "Option \*qLog\*q  \*q" logflag \*q
This option enables special handling for log files that may be useful when
debugging certain types of problems.  The values for
.I logflag
are
.B Flush
and
.BR Sync .
.B Flush
causes the log file buffer to be flushed after each write.
.B Sync
causes the log file buffer to be flushed and the file data to be written
to the disk after each write.  The default is for neither of these flags to
be enabled.  Enabling these flags during normal operation may degrade
performance and/or lengthen startup time.
.TP 7
.BI "Option \*qNoPM\*q  \*q" boolean \*q
Disables something to do with power management events.  Default: PM
enabled on platforms that support it.
.TP 7
.BI "Option \*qXinerama\*q  \*q" boolean \*q
enable or disable XINERAMA extension. Default is disabled.
.TP 7
.BI "Option \*qAllowDeactivateGrabs\*q \*q" boolean \*q
This option enables the use of the
.B Ctrl+Alt+Keypad-Divide
key sequence to deactivate any active keyboard and mouse grabs.  Default:
off.
.TP 7
.BI "Option \*qAllowClosedownGrabs\*q \*q" boolean \*q
This option enables the use of the
.B Ctrl+Alt+Keypad-Multiply
key sequence to kill clients with an active keyboard or mouse grab as
well as killing any application that may have locked the server, normally
using the XGrabServer(__libmansuffix__) Xlib function.  Default: off.
.br
Note that the options
.BI AllowDeactivateGrabs
and
.BI AllowClosedownGrabs
will allow users to remove the grab used by screen saver/locker programs.
An API was written to such cases. If you enable this option, make sure
your screen saver/locker is updated.
.TP 7
.BI "Option \*qHandleSpecialKeys\*q \*q" when \*q
This option controls when the server uses the builtin handler to process
special key combinations (such as
.BR Ctrl+Alt+Backspace ).
Normally the XKEYBOARD extension keymaps will provide mappings for each
of the special key combinations, so the builtin handler is not needed
unless the XKEYBOARD extension is disabled.  The value of
.I when
can be
.BR Always ,
.BR Never ,
or
.BR WhenNeeded .
Default: Use the builtin handler only if needed.  The server will scan
the keymap for a mapping to the
.B Terminate
action and, if found, use XKEYBOARD for processing actions, otherwise
the builtin handler will be used.
.SH MODULE SECTION
The config file may have multiple
.B Module
section.  They are used to specify additional XFree86 server modules to
be loaded.  This section is ignored when the XFree86 server is built in
static form.  The types of modules normally loaded in this section are
XFree86 server extension modules, and font rasteriser modules.  Most
other module types are loaded automatically when they are needed via
other mechanisms.  The
.B Module
section is optional, as are all of the entries that may be specified in
it.
.PP
.TP 7
.BI "Identifier \*q" name \*q
specifies an optional identifying name for the
.B Module
section.
.TP 7
.B Options
Option flags may be specified in
.B Module
sections.
.PP
Entries that identify which modules to pre-load may be in two forms.
The first and most commonly used form is an entry that uses the
.B Load
keyword, as described here:
.TP 7
.BI "Load  \*q" modulename \*q
This instructs the server to load the module called
.IR modulename .
The module name given should be the module's standard name, not the
module file name.  The standard name is case-sensitive, and does not
include the "lib" prefix, or the ".a", ".o", or ".so" suffixes.
.PP
.RS 7
Example: the Type 1 font rasteriser can be loaded with the following entry:
.PP
.RS 4
.B "Load \*qtype1\*q"
.RE
.RE
.PP
The second form of entry is a
.BR SubSection,
with the subsection name being the module name, and the contents of the
.B SubSection
being
.B Options
that are passed to the module when it is loaded.
.PP
Example: the extmod module (which contains a miscellaneous group of
server extensions) can be loaded, with the XFree86-DGA extension
disabled by using the following entry:
.PP
.RS 4
.nf
.B "SubSection \*qextmod\*q"
.B "   Option  \*qomit XFree86-DGA\*q"
.B EndSubSection
.fi
.RE
.PP
Modules are searched for in each directory specified in the
.B ModulePath
search path, and in the drivers, input, extensions, fonts, and
internal subdirectories of each of those directories.
In addition to this, operating system specific subdirectories of all
the above are searched first if they exist.
.PP
To see what font and extension modules are available, check the contents
of the following directories:
.PP
.RS 4
.nf
__projectroot__/lib/modules/fonts
__projectroot__/lib/modules/extensions
.fi
.RE
.PP
The "bitmap" font modules is loaded automatically.  It is recommended
that at very least the "extmod" extension module be loaded.  If it isn't
some commonly used server extensions (like the SHAPE extension) will not be
available.
.SH INPUTDEVICE SECTION
The config file may have multiple
.B InputDevice
sections.  There will normally be at least two: one for the core (primary)
keyboard, and one of the core pointer.  If either of these two is missing,
a default configuration for the missing ones will be used.  Currently the
default configuration may not work as expected on all platforms.
.PP
.B InputDevice
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qInputDevice\*q"
.BI "    Identifier \*q" name \*q
.BI "    Driver     \*q" inputdriver \*q
.I  "    options"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
and
.B Driver
entries are required in all
.B InputDevice
sections.  All other entries are optional.
.PP
The
.B Identifier
entry specifies the unique name for this input device.  The
.B Driver
entry specifies the name of the driver to use for this input device.
When using the loadable server, the input driver module
.RI \*q inputdriver \*q
will be loaded for each active
.B InputDevice
section.  An
.B InputDevice
section is considered active if it is referenced by an active
.B ServerLayout
section, if it is referenced by the
.B \-keyboard
or
.B \-pointer
command line options, or if it is selected implicitly as the core pointer
or keyboard device in the absence of such explicit references.
The most commonly used input drivers are "keyboard" and "mouse".
.PP
In the absence of an explicitly specified core input device, the first
.B InputDevice
marked as
.B CorePointer
(or
.BR CoreKeyboard )
is used.  If there is no match there, the first
.B InputDevice
that uses the "mouse" (or "keyboard" or "kbd") driver is used.  The final
fallback is to use built-in default configurations.
.PP
.B InputDevice
sections recognise some driver-independent
.BR Options ,
which are described here.  See the individual input driver manual pages
for a description of the device-specific options.
.TP 7
.B "Option \*qCorePointer\*q"
When this is set, the input device is installed as the core (primary)
pointer device.  There must be exactly one core pointer.  If this option
is not set here, or in the
.B ServerLayout
section, or from the
.B \-pointer
command line option, then the first input device that is capable of
being used as a core pointer will be selected as the core pointer.
This option is implicitly set when the obsolete
.B Pointer
section is used.
.TP 7
.B "Option \*qCoreKeyboard\*q"
When this is set, the input device is to be installed as the core
(primary) keyboard device.  There must be exactly one core keyboard.  If
this option is not set here, in the
.B ServerLayout
section, or from the
.B \-keyboard
command line option, then the first input device that is capable of
being used as a core keyboard will be selected as the core keyboard.
This option is implicitly set when the obsolete
.B Keyboard
section is used.
.TP 7
.BI "Option \*qAlwaysCore\*q  \*q" boolean \*q
.TP 7
.BI "Option \*qSendCoreEvents\*q  \*q" boolean \*q
Both of these options are equivalent, and when enabled cause the
input device to always report core events.  This can be used, for
example, to allow an additional pointer device to generate core
pointer events (like moving the cursor, etc).
.TP 4
.BI "Option \*qHistorySize\*q  \*q" number \*q
Sets the motion history size.  Default: 0.
.TP 7
.BI "Option \*qSendDragEvents\*q  \*q" boolean \*q
???
.SH DEVICE SECTION
The config file may have multiple
.B Device
sections.  There must be at least one, for the video card being used.
.PP
.B Device
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qDevice\*q"
.BI "    Identifier \*q" name \*q
.BI "    Driver     \*q" driver \*q
.I  "    entries"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
and
.B Driver
entries are required in all
.B Device
sections.  All other entries are optional.
.PP
The
.B Identifier
entry specifies the unique name for this graphics device.  The
.B Driver
entry specifies the name of the driver to use for this graphics device.
When using the loadable server, the driver module
.RI \*q driver \*q
will be loaded for each active
.B Device
section.  A
.B Device
section is considered active if it is referenced by an active
.B Screen
section.
.PP
.B Device
sections recognise some driver-independent entries and
.BR Options ,
which are described here.  Not all drivers make use of these
driver-independent entries, and many of those that do don't require them
to be specified because the information is auto-detected.  See the
individual graphics driver manual pages for further information about
this, and for a description of the device-specific options.
Note that most of the
.B Options
listed here (but not the other entries) may be specified in the
.B Screen
section instead of here in the
.B Device
section.
.TP 7
.BI "BusID  \*q" bus-id \*q
This specifies the bus location of the graphics card.  For PCI/AGP cards,
the
.I bus-id
string has the form
.BI PCI: bus : device : function
(e.g., "PCI:1:0:0" might be appropriate for an AGP card).
This field is usually optional in single-head configurations when using
the primary graphics card.  In multi-head configurations, or when using
a secondary graphics card in a single-head configuration, this entry is
mandatory.  Its main purpose is to make an unambiguous connection between
the device section and the hardware it is representing.  This information
can usually be found by running the XFree86 server with the
.B \-scanpci
command line option.
.TP 7
.BI "Screen  " number
This option is mandatory for cards where a single PCI entity can drive more
than one display (i.e., multiple CRTCs sharing a single graphics accelerator
and video memory).  One
.B Device
section is required for each head, and this
parameter determines which head each of the
.B Device
sections applies to.  The legal values of
.I number
range from 0 to one less than the total number of heads per entity.
Most drivers require that the primary screen (0) be present.
.TP 7
.BI "Chipset  \*q" chipset \*q
This usually optional entry specifies the chipset used on the graphics
board.  In most cases this entry is not required because the drivers
will probe the hardware to determine the chipset type.  Don't
specify it unless the driver-specific documentation recommends that you
do.
.TP 7
.BI "Ramdac  \*q" ramdac-type \*q
This optional entry specifies the type of RAMDAC used on the graphics
board.  This is only used by a few of the drivers, and in most cases it
is not required because the drivers will probe the hardware to determine
the RAMDAC type where possible.  Don't specify it unless the
driver-specific documentation recommends that you do.
.TP 7
.BI "DacSpeed  " speed
.TP 7
.BI "DacSpeed  " "speed-8 speed-16 speed-24 speed-32"
This optional entry specifies the RAMDAC speed rating (which is usually
printed on the RAMDAC chip).  The speed is in MHz.  When one value is
given, it applies to all framebuffer pixel sizes.  When multiple values
are give, they apply to the framebuffer pixel sizes 8, 16, 24 and 32
respectively.  This is not used by many drivers, and only needs to be
specified when the speed rating of the RAMDAC is different from the
defaults built in to driver, or when the driver can't auto-detect the
correct defaults.  Don't specify it unless the driver-specific
documentation recommends that you do.
.TP 7
.BI "Clocks  " "clock ..."
specifies the pixel that are on your graphics board.  The clocks are in
MHz, and may be specified as a floating point number.  The value is
stored internally to the nearest kHz.  The ordering of the clocks is
important.  It must match the order in which they are selected on the
graphics board.  Multiple
.B Clocks
lines may be specified, and each is concatenated to form the list.  Most
drivers do not use this entry, and it is only required for some older
boards with non-programmable clocks.  Don't specify this entry unless
the driver-specific documentation explicitly recommends that you do.
.TP
.BI "ClockChip  \*q" clockchip-type \*q
This optional entry is used to specify the clock chip type on graphics
boards which have a programmable clock generator.  Only a few XFree86
drivers support programmable clock chips.  For details, see the appropriate
driver manual page.
.TP 7
.BI "VideoRam  " "mem"
This optional entry specifies the amount of video ram that is installed
on the graphics board. This is measured in kBytes.  In most cases this
is not required because the XFree86 server probes the graphics board to
determine this quantity.  The driver-specific documentation should
indicate when it might be needed.
.TP 7
.BI "BiosBase  " "baseaddress"
This optional entry specifies the base address of the video BIOS for
the VGA board.  This address is normally auto-detected, and should only
be specified if the driver-specific documentation recommends it.
.TP 7
.BI "MemBase  " "baseaddress"
This optional entry specifies the memory base address of a graphics
board's linear frame buffer.  This entry is not used by many drivers,
and it should only be specified if the driver-specific documentation
recommends it.
.TP 7
.BI "IOBase  " "baseaddress"
This optional entry specifies the IO base address.  This entry is not
used by many drivers, and it should only be specified if the
driver-specific documentation recommends it.
.TP 7
.BI "ChipID  " "id"
This optional entry specifies a numerical ID representing the chip type.
For PCI cards, it is usually the device ID.  This can be used to override
the auto-detection, but that should only be done when the driver-specific
documentation recommends it.
.TP 7
.BI "ChipRev  " "rev"
This optional entry specifies the chip revision number.  This can be
used to override the auto-detection, but that should only be done when
the driver-specific documentation recommends it.
.TP 7
.BI "TextClockFreq  " "freq"
This optional entry specifies the pixel clock frequency that is used
for the regular text mode.  The frequency is specified in MHz.  This is
rarely used.
.TP 7
.BI "IRQ " "interrupt-number"
This optional entry allows an interrupt number to be specified.
.TP 7
.B Options
Option flags may be specified in the
.B Device
sections.  These include driver-specific options and driver-independent
options.  The former are described in the driver-specific documentation.
Some of the latter are described below in the section about the
.B Screen
section, and they may also be included here.

.SH VIDEOADAPTOR SECTION
The config file may have multiple
.B VideoAdaptor
sections, which may be referenced from
.B Screen
sections.
.PP
.B VideoAdaptor
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qVideoAdaptor\*q"
.BI "    Identifier \*q" name \*q
.I  "    entries"
.I  "    ..."
.BI "    SubSection \*qPort\*q"
.I  "       entries"
.I  "       ...
.B  "    EndSubSection"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The only mandatory entry in a
.B VideoAdaptor
section is the
.BR Identifier .
Other entries include:
.TP 7
.BI "VendorName  \*q" vendor \*q
This optional entry specifies the video adaptor's manufacturer.
.TP 7
.BI "BoardName  \*q" model \*q
This optional entry specifies the video adaptor's model name.
.TP 7
.B Options
may be specified in the
.B VideoAdaptor
section.
.PP
The
.B Port
.B SubSections
provide information about video adaptor ports.  Each of these may contain
an
.B Identifier
entry and
.BR Options .
.SH MONITOR SECTION
The config file may have multiple
.B Monitor
sections.  There should normally be at least one, for the monitor being used,
but a default configuration will be created when one isn't specified.
.PP
.B Monitor
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qMonitor\*q"
.BI "    Identifier \*q" name \*q
.I  "    entries"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The only mandatory entry in a
.B Monitor
section is the
.B Identifier
entry.
.PP
The
.B Identifier
entry specifies the unique name for this monitor.  The
.B Monitor
section provides information about the specifications of the monitor,
monitor-specific
.BR Options ,
and information about the video modes to use with the monitor.  Specifying
video modes is optional because the server now has a built-in list of
VESA standard modes.  When modes are specified explicitly in the
.B Monitor
section (with the
.BR Modes ,
.BR ModeLine ,
or
.B UseModes
keywords), built-in modes with the same names are not included.  Built-in
modes with different names are, however, still implicitly included.
.PP
The entries that may be used in
.B Monitor
sections are described below.
.TP 7
.BI "VendorName  \*q" vendor \*q
This optional entry specifies the monitor's manufacturer.
.TP 7
.BI "ModelName  \*q" model \*q
This optional entry specifies the monitor's model.
.TP 7
.BI "HorizSync  " "horizsync-range"
gives the range(s) of horizontal sync frequencies supported by the
monitor.
.I horizsync-range
may be a comma separated list of either discrete values or ranges of
values.  A range of values is two values separated by a dash.  By default
the values are in units of kHz.  They may be specified in MHz or Hz if
.B MHz
or
.B Hz
is added to the end of the line.  The data given here is used by the
XFree86 server to determine if video modes are within the specifications
of the monitor.  This information should be available in the monitor's
handbook.  If this entry is omitted, a default range of 28\-33kHz is
used.
.TP 7
.BI "VertRefresh  " "vertrefresh-range"
gives the range(s) of vertical refresh frequencies supported by the
monitor.
.I vertrefresh-range
may be a comma separated list of either discrete values or ranges of
values.  A range of values is two values separated by a dash.  By default
the values are in units of Hz.  They may be specified in MHz or kHz if
.B MHz
or
.B kHz
is added to the end of the line.  The data given here is used by the
XFree86 server to determine if video modes are within the specifications
of the monitor.  This information should be available in the monitor's
handbook.  If this entry is omitted, a default range of 43-72Hz is used.
.TP 7
.BI "DisplaySize  " "width height"
This optional entry gives the width and height, in millimetres, of the
picture area of the monitor. If given this is used to calculate the
horizontal and vertical pitch (DPI) of the screen.
.TP 7
.BI "Gamma  " "gamma-value"
.TP 7
.BI "Gamma  " "red-gamma green-gamma blue-gamma"
This is an optional entry that can be used to specify the gamma correction
for the monitor.  It may be specified as either a single value or as
three separate RGB values.  The values should be in the range 0.1 to
10.0, and the default is 1.0.  Not all drivers are capable of using this
information.
.TP 7
.BI "UseModes  \*q" modesection-id \*q
Include the set of modes listed in the
.B Modes
section called
.IR modesection-id.
This make all of the modes defined in that section available for use by
this monitor.
.TP 7
.BI "Mode  \*q" name \*q
This is an optional multi-line entry that can be used to provide
definitions for video modes for the monitor.  In most cases this isn't
necessary because the built-in set of VESA standard modes will be
sufficient.  The
.B Mode
keyword indicates the start of a multi-line video mode description.
The mode description is terminated with the
.B EndMode
keyword.  The mode description consists of the following entries:
.RS 7
.TP 4
.BI "DotClock  " clock
is the dot (pixel) clock rate to be used for the mode.
.TP 4
.BI "HTimings  " "hdisp hsyncstart hsyncend htotal"
specifies the horizontal timings for the mode.
.TP 4
.BI "VTimings  " "vdisp vsyncstart vsyncend vtotal"
specifies the vertical timings for the mode.
.TP 4
.BI "Flags  \*q" flag \*q " ..."
specifies an optional set of mode flags, each of which is a separate
string in double quotes.
.B \*qInterlace\*q
indicates that the mode is interlaced.
.B \*qDoubleScan\*q
indicates a mode where each scanline is doubled.
.B \*q+HSync\*q
and
.B \*q\-HSync\*q
can be used to select the polarity of the HSync signal.
.B \*q+VSync\*q
and
.B \*q\-VSync\*q
can be used to select the polarity of the VSync signal.
.B \*qComposite\*q
can be used to specify composite sync on hardware where this is supported.
Additionally, on some hardware,
.B \*q+CSync\*q
and
.B \*q\-CSync\*q
may be used to select the composite sync polarity.
.TP 4
.BI "HSkew  " hskew
specifies the number of pixels (towards the right edge of the screen)
by which the display enable signal is to be skewed.  Not all drivers
use this information.  This option might become necessary to override
the default value supplied by the server (if any).  "Roving" horizontal
lines indicate this value needs to be increased.  If the last few pixels
on a scan line appear on the left of the screen, this value should be
decreased.
.TP 4
.BI "VScan  " vscan
specifies the number of times each scanline is painted on the screen.
Not all drivers use this information.  Values less than 1 are treated
as 1, which is the default.  Generally, the
.B \*qDoubleScan\*q
.B Flag
mentioned above doubles this value.
.RE
.TP 7
.BI "ModeLine  \*q" name \*q " mode-description"
This entry is a more compact version of the
.B Mode
entry, and it also can be used to specify video modes for the monitor.
is a single line format for specifying video modes.  In most cases this
isn't necessary because the built-in set of VESA standard modes will be
sufficient.
.PP
.RS 7
The
.I mode-description
is in four sections, the first three of which are mandatory.  The first
is the dot (pixel) clock.  This is a single number specifying the pixel
clock rate for the mode in MHz.  The second section is a list of four
numbers specifying the horizontal timings.  These numbers are the
.IR hdisp ,
.IR hsyncstart ,
.IR hsyncend ,
and
.I htotal
values.  The third section is a list of four numbers specifying the
vertical timings.  These numbers are the
.IR vdisp ,
.IR vsyncstart ,
.IR vsyncend ,
and
.I vtotal
values.  The final section is a list of flags specifying other
characteristics of the mode.
.B Interlace
indicates that the mode is interlaced.
.B DoubleScan
indicates a mode where each scanline is doubled.
.B +HSync
and
.B \-HSync
can be used to select the polarity of the HSync signal.
.B +VSync
and
.B \-VSync
can be used to select the polarity of the VSync signal.
.B Composite
can be used to specify composite sync on hardware where this is supported.
Additionally, on some hardware,
.B +CSync
and
.B \-CSync
may be used to select the composite sync polarity.  The
.B HSkew
and
.B VScan
options mentioned above in the
.B Modes
entry description can also be used here.
.RE
.TP 7
.BI "Option \*qDPMS\*q \*q" boolean \*q
Set whether DPMS is enabled for the monitor.  The default is taken from
the monitor's DDC/EDID information if available, or false if not.
.TP 7
.BI "Option \*qTargetRefresh\*q \*q" refresh \*q
Sets a target refresh rate to use for the monitor.  If the monitor has
valid modes with a refresh rate greater or equal to this value, those with
a lower refresh rate will not be considered when determining the default
resolution to use.  This is improves the default resolution selection when
none is specified explicitly.  Default:
.B TargetRefresh
not used.
.TP 7
.BI "Option \*qSyncOnGreen\*q \*q" boolean \*q
Set whether sync-on-green should be enabled.  The availability of this
option is driver-specific.  Default: false.
.TP 7
.BI "Option \*qPreferredMode\*q \*q" Xres x Yres \*q
Sets a preferred resolution to use for the default mode.  By default
the preferred mode resolution is taken from the DDC/EDID data if it is
available and if it is provides a default mode preference.  This is typically
true for flat panel displays, which have a native/preferred resolution.
This option is not used of the
.B UsePreferredMode
option is false.
.TP 7
.BI "Option \*qUsePreferredMode\*q \*q" boolean \*q
Controls whether or not a preferred mode, either detected from the
monitor's DDC/EDID data or provided explicitly with the
.B PreferredMode
option, is used.  Default: true.
.TP 7
.B Options
Additional
.B Option
flags, including driver-specific options, may be included in
.B Monitor
sections.

.SH MODES SECTION
The config file may have multiple
.B Modes
sections, or none.  These sections provide a way of defining sets of
video modes independently of the
.B Monitor
sections.
.B Monitor
sections may include the definitions provided in these sections by
using the
.B UseModes
keyword.  In most cases the
.B Modes
sections are not necessary because the built-in set of VESA standard modes
will be sufficient.
.PP
.B Modes
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qModes\*q"
.BI "    Identifier \*q" name \*q
.I  "    entries"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
entry specifies the unique name for this set of mode descriptions.
The other entries permitted in
.B Modes
sections are the
.B Mode
and
.B ModeLine
entries that are described above in the
.B Monitor
section, as well as
.BR Options .
.SH SCREEN SECTION
The config file may have multiple
.B Screen
sections.  There must be at least one, for the "screen" being used.
A "screen" represents the binding of a graphics device
.RB ( Device
section) and one or more monitors
.RB ( Monitor
sections).  A
.B Screen
section is considered "active" if it is referenced by an active
.B ServerLayout
section or by the
.B \-screen
command line option.  If neither of those is present, the first
.B Screen
section found in the config file is considered the active one.
.PP
.B Screen
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qScreen\*q"
.BI "    Identifier \*q" name \*q
.BI "    Device     \*q" devid \*q
.BI "    Monitor    \*q" monid \*q
.I  "    entries"
.I  "    ..."
.BI "    SubSection \*qDisplay\*q"
.I  "       entries"
.I  "       ...
.B  "    EndSubSection"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
and
.B Device
entries are mandatory.  All others are optional.
.PP
The
.B Identifier
entry specifies the unique name for this screen.  The
.B Screen
section provides information specific to the whole screen, including
screen-specific
.BR Options .
In multi-head configurations, there will be multiple active
.B Screen
sections, one for each head.
The entries available
for this section are:
.TP 7
.BI "Device  \*q" device-id \*q
This mandatory entry specifies the
.B Device
section to be used for this screen.  This is what ties a specific
graphics card to a screen.  The
.I device-id
must match the
.B Identifier
of a
.B Device
section in the config file.
.TP 7
.BI "Monitor  " "monitor-num" " \*q" "monitor-id" \*q
One of these entries may be given for each monitor associated with this
screen.  In the absence of these entries, at least one default monitor
will be created for the screen.
The
.I monitor-id
field is mandatory, and specifies the
.B Monitor
section being referenced.  The
.I monitor-num
field is required when more than one monitor is being associated with
the screen.  Each referenced monitor should be given a unique monitor
number.  This monitor number may be given special significance by the
driver, and it is also used to identify which
.B Display
subsection(s) are associated with the screen/monitor.  If this field is
omitted in a multiple-monitor configuration, default values will be
assigned.  This is not recommended, and this behaviour may change in
future revisions.
.PP
.RS 7
If a
.B Monitor
name is not specified, a default configuration is used.  Currently the default
configuration may not function as expected on all platforms.
.RE
.TP 7
.BI "VideoAdaptor  \*q" xv-id \*q
specifies an optional Xv video adaptor description to be used with this
screen.
.TP 7
.BI "DefaultDepth  " depth
specifies which color depth the server should use by default.  The
.B \-depth
command line option can be used to override this.  If neither is specified,
the default depth is driver-specific, but in most cases is 8.
.TP 7
.BI "DefaultFbBpp  " bpp
specifies which framebuffer layout to use by default.  The
.B \-fbbpp
command line option can be used to override this.  In most cases the
driver will chose the best default value for this.  The only case where
there is even a choice in this value is for depth 24, where some hardware
supports both a packed 24 bit framebuffer layout and a sparse 32 bit
framebuffer layout.
.TP 7
.B Options
Various
.B Option
flags may be specified in the
.B Screen
section.  Some are driver-specific and are described in the driver
documentation.  Others are driver-independent, and will eventually be
described here.
.\" XXX These should really be in an xaa man page.
.TP 7
.BI "Option \*qAccel\*q"
Enables XAA (X Acceleration Architecture), a mechanism that makes video
cards' 2D hardware acceleration available to the XFree86 server.  This
option is on by default, but it may be necessary to turn it off if there
are bugs in the driver.  There are many options to disable specific
accelerated operations, listed below.  Note that disabling an operation
will have no effect if the operation is not accelerated (whether due to
lack of support in the hardware or in the driver).
.TP 7
.BI "Option \*qBiosLocation\*q \*q" address \*q
Set the location of the BIOS for the Int10 module. One may select a BIOS
of another card for posting or the legacy V_BIOS range located at 0xc0000
or an alternative address (BUS_ISA).  This is only useful under very
special circumstances and should be used with extreme care.
.TP 7
.BI "Option \*qInitPrimary\*q \*q" boolean \*q
Use the Int10 module to initialize the primary graphics card. Normally,
only secondary cards are soft-booted using the Int10 module, as the
primary card has already been initialized by the BIOS at boot time.
Default: false.
.TP 7
.BI "Option \*qNoInt10\*q \*q" boolean \*q
Disables the Int10 module, a module that uses the int10 call to the BIOS
of the graphics card to initialize it. Default: false.
.TP 7
.BI "Option \*qNoMTRR\*q"
Disables MTRR (Memory Type Range Register) support, a feature of modern
processors which can improve video performance by a factor of up to 2.5.
Some hardware has buggy MTRR support, and some video drivers have been
known to exhibit problems when MTRR's are used.
.TP 7
.BI "Option \*qXaaNoCPUToScreenColorExpandFill\*q"
Disables accelerated rectangular expansion blits from source patterns
stored in system memory (using a memory-mapped aperture).
.TP 7
.BI "Option \*qXaaNoColor8x8PatternFillRect\*q"
Disables accelerated fills of a rectangular region with a full-color
pattern.
.TP 7
.BI "Option \*qXaaNoColor8x8PatternFillTrap\*q"
Disables accelerated fills of a trapezoidal region with a full-color
pattern.
.TP 7
.BI "Option \*qXaaNoDashedBresenhamLine\*q"
Disables accelerated dashed Bresenham line draws.
.TP 7
.BI "Option \*qXaaNoDashedTwoPointLine\*q"
Disables accelerated dashed line draws between two arbitrary points.
.TP 7
.BI "Option \*qXaaNoImageWriteRect\*q"
Disables accelerated transfers of full-color rectangular patterns from
system memory to video memory (using a memory-mapped aperture).
.TP 7
.BI "Option \*qXaaNoMono8x8PatternFillRect\*q"
Disables accelerated fills of a rectangular region with a monochrome
pattern.
.TP 7
.BI "Option \*qXaaNoMono8x8PatternFillTrap\*q"
Disables accelerated fills of a trapezoidal region with a monochrome
pattern.
.TP 7
.BI "Option \*qXaaNoOffscreenPixmaps\*q"
Disables accelerated draws into pixmaps stored in offscreen video memory.
.TP 7
.BI "Option \*qXaaNoPixmapCache\*q"
Disables caching of patterns in offscreen video memory.
.TP 7
.BI "Option \*qXaaNoScanlineCPUToScreenColorExpandFill\*q"
Disables accelerated rectangular expansion blits from source patterns
stored in system memory (one scan line at a time).
.TP 7
.BI "Option \*qXaaNoScanlineImageWriteRect\*q"
Disables accelerated transfers of full-color rectangular patterns from
system memory to video memory (one scan line at a time).
.TP 7
.BI "Option \*qXaaNoScreenToScreenColorExpandFill\*q"
Disables accelerated rectangular expansion blits from source patterns
stored in offscreen video memory.
.TP 7
.BI "Option \*qXaaNoScreenToScreenCopy\*q"
Disables accelerated copies of rectangular regions from one part of
video memory to another part of video memory.
.TP 7
.BI "Option \*qXaaNoSolidBresenhamLine\*q"
Disables accelerated solid Bresenham line draws.
.TP 7
.BI "Option \*qXaaNoSolidFillRect\*q"
Disables accelerated solid-color fills of rectangles.
.TP 7
.BI "Option \*qXaaNoSolidFillTrap\*q"
Disables accelerated solid-color fills of Bresenham trapezoids.
.TP 7
.BI "Option \*qXaaNoSolidHorVertLine\*q"
Disables accelerated solid horizontal and vertical line draws.
.TP 7
.BI "Option \*qXaaNoSolidTwoPointLine\*q"
Disables accelerated solid line draws between two arbitrary points.
.PP
Each
.B Screen
section may optionally contain one or more
.B Display
subsections.  Those subsections provide depth, fbbpp and monitor specific
configuration information, and the ones chosen depend on the depth and/or
fbbpp that is being used for the screen, as well as the monitor number(s)
in multi-monitor configurations.  The
.B Display
subsection format is described in the section below.

.SH DISPLAY SUBSECTION
Each
.B Screen
section may have multiple
.B Display
subsections.  
The "active"
.B Display
subsections are the first for each monitor number that match the depth
and/or fbbpp values being used, or failing that, the first for each
monitor number that has neither a depth or fbbpp value specified.  Display
subsections with no monitor number specified are used for single monitor
per screen configurations.  The
.B Display
subsections are optional.  When there isn't one that matches the monitor
number and/or depth and/or fbbpp values being used, all the parameters
that can be specified here fall back to their defaults.
.PP
.B Display
subsections have the following format:
.PP
.RS 4
.nf
.B  "    SubSection \*qDisplay\*q"
.BI "        Monitor  " monitor-num
.BI "        Depth  " depth
.I  "        entries"
.I  "        ..."
.B  "    EndSubSection"
.fi
.RE
.PP
None of the entries in a
.B Display
subsection are mandatory.
.TP 7
.BI "Monitor  " monitor-num
This entry specifies which
.B Monitor
entry of the
.B Screen
section that this
.B Display
subsection applies to.  This number should match the monitor number of one of
the
.B Monitor
references in the
.B Screen
screen.  If it doesn't match, then this
.B Display
subsection will be ignored.  If this entry is omitted, it is applied to
single-monitor configurations.  For multi-monitor configurations, the
driver may also use information in this subsection for screen-wide
parameters.  Not all of the parameters in this subsection make sense on
a per-monitor basis.  Which get used and how they get used is currently
up to the driver.  Entries that are relevant to multi-monitor configurations
include
.BR Modes ,
.BR Virtual ,
.BR ViewPort ,
and
.BR Options .
.TP 7
.BI "Depth  " depth
This entry specifies what colour depth the
.B Display
subsection is to be used for.  This entry is usually specified, but it
may be omitted to create a match-all
.B Display
subsection or when wishing to match only against the
.B FbBpp
parameter.  The range of
.I depth
values that are allowed depends on the driver.  Most driver support 8,
15, 16 and 24.  Some also support 1 and/or 4, and some may support other
values (like 30).  Note:
.I depth
means the number of bits in a pixel that are actually used to determine
the pixel colour.  32 is not a valid
.I depth
value.  Most hardware that uses 32 bits per pixel only uses 24 of them
to hold the colour information, which means that the colour depth is 24,
not 32.
.TP 7
.BI "FbBpp  " bpp
This entry specifies the framebuffer format this
.B Display
subsection is to be used for.  This entry is only needed when providing
depth 24 configurations that allow a choice between a 24 bpp packed
framebuffer format and a 32bpp sparse framebuffer format.  In most cases
this entry should not be used.
.TP 7
.BI "Weight  " "red-weight green-weight blue-weight"
This optional entry specifies the relative RGB weighting to be used for
a screen is being used at depth 16 for drivers that allow multiple
formats.  This may also be specified from the command line with the
.B \-weight
option (see XFree86(1)).
.TP 7
.BI "Virtual  " "xdim ydim"
This optional entry specifies the virtual screen resolution to be used.
.I xdim
must be a multiple of either 8 or 16 for most drivers, and a multiple
of 32 when running in monochrome mode.  The given value will be rounded
down if this is not the case.  Video modes which are too large for the
specified virtual size will be rejected.  If this entry is not present,
the virtual screen resolution will be set to accommodate all the valid
video modes given in the
.B Modes
entry.  Some drivers/hardware combinations do not support virtual screens.
Refer to the appropriate driver-specific documentation for details.
.TP 7
.BI "ViewPort  " "x0 y0"
This optional entry sets the upper left corner of the initial display.
This is only relevant when the virtual screen resolution is different
from the resolution of the initial video mode.  If this entry is not
given, then the initial display will be centered in the virtual display
area.
.TP 7
.BI "Modes  \*q" mode-name \*q " ..."
This optional entry specifies the list of video modes to use.  Each
.I mode-name
specified must be in double quotes.  They must correspond to those
specified or referenced in the appropriate
.B Monitor
section (including implicitly referenced built-in VESA standard modes).
The server will delete modes from this list which don't satisfy various
requirements.  The first valid mode in this list will be the default
display mode for startup.  The list of valid modes is converted internally
into a circular list.  It is possible to switch to the next mode with
.B Ctrl+Alt+Keypad-Plus
and to the previous mode with
.BR Ctrl+Alt+Keypad-Minus .
When this entry is omitted, the valid modes referenced by the appropriate
.B Monitor
section will be used.  If the
.B Monitor
section contains no modes, then the selection will be taken from the
built-in VESA standard modes.
.TP 7
.BI "Visual  \*q" visual-name \*q
This optional entry sets the default root visual type.  This may also
be specified from the command line (see the Xserver(1) man page).  The
visual types available for depth 8 are (default is
.BR PseudoColor ):
.PP
.RS 11
.nf
.B StaticGray
.B GrayScale
.B StaticColor
.B PseudoColor
.B TrueColor
.B DirectColor
.fi
.RE
.PP
.RS 7
The visual type available for the depths 15, 16 and 24 are (default is
.BR TrueColor ):
.PP
.RS 4
.nf
.B TrueColor
.B DirectColor
.fi
.RE
.PP
Not all drivers support
.B DirectColor
at these depths.
.PP
The visual types available for the depth 4 are (default is
.BR StaticColor ):
.PP
.RS 4
.nf
.B StaticGray
.B GrayScale
.B StaticColor
.B PseudoColor
.fi
.RE
.PP
The visual type available for the depth 1 (monochrome) is
.BR StaticGray .
.RE
.TP 7
.BI "Black  " "red green blue"
This optional entry allows the "black" colour to be specified.  This
is only supported at depth 1.  The default is black.
.TP 7
.BI "White  " "red green blue"
This optional entry allows the "white" colour to be specified.  This
is only supported at depth 1.  The default is white.
.TP 7
.B Options
Option flags may be specified in the
.B Display
subsections.  These may include driver-specific options and
driver-independent options.  The former are described in the
driver-specific documentation.  Some of the latter are described above
in the section about the
.B Screen
section, and they may also be included here.
.SH SERVERLAYOUT SECTION
The config file may have multiple
.B ServerLayout
sections.  
A "server layout" represents the binding of one or more screens
.RB ( Screen
sections) and one or more input devices
.RB ( InputDevice
sections) to form a complete configuration.  In multi-head configurations,
it also specifies the relative layout of the heads.  A
.B ServerLayout
section is considered "active" if it is referenced by the
.B \-layout
command line option or by an
.B "Option \*qDefaultServerLayout\*q"
entry in the
.B ServerFlags
section (the former takes precedence over the latter).  If those options are
not used, the first
.B ServerLayout
section found in the config file is considered the active one.  If no
.B ServerLayout
sections are present, the single active screen and two active (core)
input devices are selected as described in the relevant sections above.
.PP
.B ServerLayout
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qServerLayout\*q"
.BI "    Identifier   \*q" name \*q
.BI "    Screen       \*q" screen-id \*q
.I  "    ..."
.BI "    InputDevice  \*q" idev-id \*q
.I  "    ..."
.I  "    options"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
Each
.B ServerLayout
section must have an
.B Identifier
entry and at least one
.B Screen
entry.
.PP
The
.B Identifier
entry specifies the unique name for this server layout.  The
.B ServerLayout
section provides information specific to the whole session, including
session-specific
.BR Options .
The
.B ServerFlags
options (described above) may be specified here, and ones given here
override those given in the
.B ServerFlags
section.
.PP
The entries that may be used in this section are described here.
.TP 7
.BI "Screen  " "screen-num" " \*q" "screen-id" "\*q " "position-information"
One of these entries must be given for each screen being used in
a session.  The
.I screen-id
field is mandatory, and specifies the
.B Screen
section being referenced.  The
.I screen-num
field is optional, and may be used to specify the screen number
in multi-head configurations.  When this field is omitted, the
screens will be numbered in the order that they are listed in.
The numbering starts from 0, and must be consecutive.  The optional
.I position-information
field describes the way multiple screens are positioned.  When this
information is not provided, the positioning of the screen defaults to
.B Absolute
.IR "0 0" .
There are a number of different ways that this information can be provided:
.RS 7
.TP 4
.I  "x y"
.TP 4
.BI "Absolute  " "x y"
These both specify that the upper left corner's coordinates are
.RI ( x , y ).
The
.B Absolute
keyword is optional.  Some older versions of XFree86 (4.2 and earlier)
don't recognise the
.B Absolute
keyword, so it's safest to just specify the coordinates without it.
.TP 4
.BI "RightOf   \*q" screen-id \*q
.TP 4
.BI "LeftOf    \*q" screen-id \*q
.TP 4
.BI "Above     \*q" screen-id \*q
.TP 4
.BI "Below     \*q" screen-id \*q
.TP 4
.BI "Relative  \*q" screen-id \*q " x y"
These give the screen's location relative to another screen.  The first
four position the screen immediately to the right, left, above or below
the other screen.  When positioning to the right or left, the top edges
are aligned.  When positioning above or below, the left edges are aligned.
The
.B Relative
form specifies the offset of the screen's origin (upper left corner)
relative to the origin of another screen.
.RE
.TP 7
.BI "InputDevice  \*q" idev-id "\*q \*q" option \*q " ..."
One of these entries should be given for each input device being used
in a session.  Normally at least two are required, one each for the core
pointer and keyboard devices.  If either of those is missing, suitable
.B InputDevice
entries are searched for using the method described above in the
.B INPUTDEVICE
section.  The
.I idev-id
field is mandatory, and specifies the name of the
.B InputDevice
section being referenced.  Multiple
.I option
fields may be specified, each in double quotes.  The options permitted
here are any that may also be given in the
.B InputDevice
sections.  Normally only session-specific input device options would be
used here.  The most commonly used options are:
.PP
.RS 11
.nf
.B \*qCorePointer\*q
.B \*qCoreKeyboard\*q
.B \*qSendCoreEvents\*q
.fi
.RE
.PP
.RS 7
and the first two should normally be used to indicate the core pointer
and core keyboard devices respectively.
.RE
.TP 7
.B Options
Any option permitted in the
.B ServerFlags
section may also be specified here.  When the same option appears in both
places, the value given here overrides the one given in the
.B ServerFlags
section.
.PP
Here is an example of a
.B ServerLayout
section for a dual headed configuration with two mice:
.PP
.RS 4
.nf
.B "Section \*qServerLayout\*q"
.B "    Identifier  \*qLayout 1\*q"
.B "    Screen      \*qMGA 1\*q"
.B "    Screen      \*qMGA 2\*q RightOf \*qMGA 1\*q"
.B "    InputDevice \*qKeyboard 1\*q \*qCoreKeyboard\*q"
.B "    InputDevice \*qMouse 1\*q    \*qCorePointer\*q"
.B "    InputDevice \*qMouse 2\*q    \*qSendCoreEvents\*q"
.B "    Option      \*qBlankTime\*q  \*q5\*q"
.B "EndSection"
.fi
.RE
.SH DRI SECTION
This optional section is used to provide some information for the
Direct Rendering Infrastructure.
.TP 7
.BI "Identifier \*q" name \*q
specifies an optional identifying name for the
.B DRI
section.
.TP 7
.BI "Group \*q" group-name \*q
.TP 7
.BI "Group " group-id
specifies the group ownership for the DRI device nodes.  It may be specified
as a group name or as a numerical group ID.
.TP 7
.BI "Mode " mode
specifies the numerical permissions for the DRI device nodes.
.TP 7
.BI "Buffers " "count size"
specifies buffers.
.TP 7
.B Options
Option flags may be specified in
.B DRI
sections.
.SH VENDOR SECTION
The optional
.B Vendor
section may be used to provide vendor-specific configuration information.
Multiple
.B Vendor
sections may be present, and they may contain the following entries:
.TP 7
.BI "Identifier \*q" name \*q
specifies an identifying name for the
.B Vendor
section.
.TP 7
.BI "VendorName \*q" vendor-name \*q
specifies the vendor name.
.TP 7
.B Options
may be specified in the
.B Vendor
sections.
.PP
In addition to these entries, there may be named
.BR SubSections ,
each of which may contain an
.B Identifier
entry and
.B Option
entries.
.PP
.SH FILES
For an example of an XF86Config file, see the file installed as
__projectroot__/lib/X11/XF86Config.eg.
.fi
.SH "SEE ALSO"
X(__miscmansuffix__),
Xserver(1),
XFree86(1),
apm(__drivermansuffix__),
.\" .IR ati(__drivermansuffix__),
chips(__drivermansuffix__),
cirrus(__drivermansuffix__),
cyrix(__drivermansuffix__),
fbdev(__drivermansuffix__),
glide(__drivermansuffix__),
glint(__drivermansuffix__),
i128(__drivermansuffix__),
i740(__drivermansuffix__),
i810(__drivermansuffix__),
imstt(__drivermansuffix__),
mga(__drivermansuffix__),
neomagic(__drivermansuffix__),
nv(__drivermansuffix__),
r128(__drivermansuffix__),
rendition(__drivermansuffix__),
savage(__drivermansuffix__),
s3virge(__drivermansuffix__),
.\" .IR shadowfb(__drivermansuffix__),
siliconmotion(__drivermansuffix__),
sis(__drivermansuffix__),
sunbw2(__drivermansuffix__),
suncg14(__drivermansuffix__),
suncg3(__drivermansuffix__),
suncg6(__drivermansuffix__),
sunffb(__drivermansuffix__),
sunleo(__drivermansuffix__),
suntcx(__drivermansuffix__),
tdfx(__drivermansuffix__),
tga(__drivermansuffix__),
trident(__drivermansuffix__),
tseng(__drivermansuffix__),
v4l(__drivermansuffix__),
vesa(__drivermansuffix__),
vga(__drivermansuffix__),
vmware(__drivermansuffix__),
.br
README
.IR <http://www.xfree86.org/current/README.html> ,
.br
RELNOTES
.IR <http://www.xfree86.org/current/RELNOTES.html> ,
.br
README.mouse
.IR <http://www.xfree86.org/current/mouse.html> ,
.br
README.DRI
.IR <http://www.xfree86.org/current/DRI.html> ,
.br
Install
.IR <http://www.xfree86.org/current/Install.html> .
.SH AUTHORS
This manual page was largely rewritten for XFree86 4.0 by David Dawes
.IR <dawes@xfree86.org> .
