/**********************************************************************
*
*  chaninfo.h
*
*  Descripion  - Header file used for the common structures for the
*  channel information and waveformats
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _CHANINFO_H_
#define _CHANINFO_H_

#define ENABLE_SPDIF
//#define NV_DEBUG_SRC
//#define NV_DEBUG_REC
//#define NV_DEBUG_NORMAL
//#define NV_DEBUG_PLAY
//#define NV_DEBUG_SP
//#define DEBUG_INTERRUPTS
//#define DEBUG_MMAP


#define ADC_RUNNING    1
#define DAC_RUNNING    2
#define SPDIF_RUNNING  3


#define NVAUDIO_FMT_16BIT   1
#define NVAUDIO_FMT_STEREO  2
#define NVAUDIO_FMT_MASK    3

#define SPDIF_ON        0x0004
#define SURR_ON         0x0010
#define CENTER_LFE_ON   0x0020
#define VOL_MUTED       0x8000

#define SG_LEN     32

/* interrupts for a dma engine */
#define DMA_INT_FIFO        (1<<4)  /* fifo under/over flow */
#define DMA_INT_COMPLETE    (1<<3)  /* buffer read/write complete and ioc set */
#define DMA_INT_LVI         (1<<2)  /* last valid done */
#define DMA_INT_CELV        (1<<1)  /* last valid is current */
#define DMA_INT_DCH         (1)     /* DMA Controller Halted (happens on LVI interrupts) */
#define DMA_INT_MASK (DMA_INT_FIFO|DMA_INT_COMPLETE|DMA_INT_LVI)

/* interrupts for the whole chip */
#define INT_RCOM    (1<<15)
#define INT_SEC     (1<<11)
#define INT_PRI     (1<<10)
#define INT_MC      (1<<7)
#define INT_PO      (1<<6)
#define INT_PI      (1<<5)
#define INT_SP      (1<<4)
#define INT_MO      (1<<2)
#define INT_NI      (1<<1)
#define INT_GPI     (1<<0)
#define INT_MASK (INT_RCOM|INT_SEC|INT_PRI|INT_MC|INT_PO|INT_PI|INT_SP|INT_MO|INT_NI|INT_GPI)

/* AC97 registers */
enum {
    GLOB_CNT =  0x2c,       /* Global Control */
    GLOB_STA =  0x30,       /* Global Status */
    CAS      =  0x34        /* Codec Write Semaphore Register */
};

enum {
    OFF_BDBAR =   0x0,     /* Buffer Descriptor list Base Address */
    OFF_CIV   =   0x4,     /* Current Index Value */
    OFF_LVI   =   0x5,     /* Last Valid Index */
    OFF_SR    =   0x6,     /* Status Register */
    OFF_PICB  =   0x8,     /* Position In Current Buffer */
    OFF_PIV   =   0xa,     /* Prefetched Index Value */
    OFF_CR    =   0xb      /* Control Register */
};

struct sg_item {
#define BUSADDR_MASK    0xFFFFFFFE
    u32 busaddr;
#define CON_IOC         0x80000000 /* interrupt on completion */
#define CON_BUFPAD      0x40000000 /* pad underrun with last sample, else 0 */
#define CON_BUFLEN_MASK 0x0000ffff /* buffer length in samples */
    u32 control;
};

#endif /* _CHANINFO_H_ */

