/***************************************************************************
 *                       Config.h  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _c_config_
#define _c_config_

#include <qstring.h>
#include <qcolor.h>

#define FORMAT_AUTO 0
#define FORMAT_TXT  1
#define FORMAT_HTML 2
#define FORMAT_XML  3
#define FORMAT_PALM_PLUCKER  128
#define FORMAT_PALM_DOC 129
#define FORMAT_PALM_HTML    130
#define FORMAT_PALM_TXT 131
#define FORMAT_PALM_MOBIPOCKET 132

#define MAX_FONT_SIZE 36

struct c_display {
    int scrollDelay;
    bool barVisible;
    bool barPercent;
    int defaultAlign;
    int align;
    QString fontName;
    int fontSize;
    bool fontBold;
    bool fakeBold;
    bool fontItalic;
    double rotation;
    int spacing;
    int margin;
    int indentPoints;
    int imageScaling;
    bool imageAsWord;
    unsigned char overlap;
    int intervalSuspend;
    int intervalLightOff;
    int intervalDim;
};

struct c_format {
    QString encoding;
    unsigned char docFormat;
    unsigned char palmFormat;
    bool reparagraph;
    bool stripCR;
    bool separateParagraphs;
    bool reorderPlucker;
    bool removeSpacePads;
    bool htmlReparagraph;
};

struct c_misc {
    bool intDict;
    QString dictionary;
};

struct c_colors {
    QColor bgColor;
    QColor normalColor;
    QColor linkColor;
    QColor barFgColor;
    QColor barBgColor;
    QColor barTextColor;
    QColor highlightColor;
};

struct c_keys {
    int scroll;
    int bar;
    int fullScreen;
    int rotate;
    int settings;
    int fileopen;
    int bookmark;
    int find;
    int back;
    int up;
    int down;
    int left;
    int right;
    bool joypad;
};

struct c_config {
    c_display display;
    c_format format;
    c_misc misc;
    c_colors colors;
    c_keys keys;
};
#endif
