/*
 * (c) sasha, sash@pdaXrom.org, 2003-2004
 * http://www.pdaXrom.org
 *
 * AtiCore framebuffer 2d accel HOWTO
 * arm-linux-gcc atitest.c -o atitest -lqte
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <unistd.h>
#include <signal.h>
#include "aticore.h"

#define MAX_XSCR	640
#define MAX_YSCR	480

static int VRAMoffset;

/*
 * Init FrameBuffer for 2D operations
 */

int initScreen(int scr_w, int scr_h)
{
    uint32_t		extm, intm;
    int			ret;
    ATI_GRAPHICWINDOW	win;
    ATI_CLIPRECT 	clip;
    uint16_t		overlay;

    if (AtiCore_ProcessAttach()) {
    
	GetAvailableVideoMem(&intm, &extm);
	printf( "internal memory = %d\n"
		"external memory = %d\n",
		intm, extm);

	ret = AtiCore_ProcessAttachSpecialMode((scr_w == 480)?0xaaab:0xaaaa);
	
	ret = AtiCore_CursorOnOff(1, 0);
	ret = AtiCore_CursorOnOff(2, 0);
	ret = AtiCore_CursorOnOff(3, 0);
	
	win.dummy1 = 0;
	win.Size.XCoord = 0; //160;
	win.Size.YCoord = 0;
	win.Size.Width  = scr_w;
	win.Size.Height = scr_h;
	win.Width       = 480; //scr_w;
	win.Height      = 640; //scr_h;
	win.Flag        = 5; // DSTTYPE_16BPP_444

	ret = AtiCore_SetupGraphicWindow(&win);
	
	ret = AtiCore_SetGraphicWindowPos(0, 0);

	/*
	 * 320x240 (240x320) use only internal Imageon RAM, offset = 0
	 * 640x480 (480x640) use external RAM, offset = 0xf000000
	 * for get pointer for direct access to video memory use next trick:
	 *	AtiCore_SetupMemoryTransfer(VRAMoffset, &fbmem);
	 *	AtiCore_TerminateMemoryTransfer();
	 */

	VRAMoffset = (scr_w == 320)?0:0xf000000;
	
	ret = AtiCore_SetFrontBuffer(VRAMoffset, 0, 0);

	ret = AtiCore_SetDstPitchOffset(scr_w, VRAMoffset);
	
	ret = AtiCore_SetDstType(5);
	
	ret = AtiCore_SetSrcPitchOffset(scr_w, VRAMoffset);
	
	ret = AtiCore_SetSrcType(4);
	
	clip.X_Top_Left = 0;
	clip.Y_Top_Left = 0;
	clip.X_Bottom_Right = scr_w;
	clip.Y_Bottom_Right = scr_h;
	
	ret = AtiCore_SetDstClippingRect(&clip);
	
	clip.X_Top_Left = 57344;
	clip.Y_Top_Left = 57344;
	clip.X_Bottom_Right = 8191;
	clip.Y_Bottom_Right = 8191;
	
	ret = AtiCore_SetSrcClippingRect(&clip);
	
	ret = AtiCore_SetRopOperation(ROP3_SRCCOPY);
	
	ret = AtiCore_SetGraphicWindowOnOff(1);
	
	ret = AtiCore_AllocOverlay(&overlay);
	
	ret = AtiCore_SetOverlayOnOff(overlay, 0);
	
	ret = AtiCore_ReleaseOverlay(overlay);

	AtiCore_SetDstPitchOffset(scr_w, VRAMoffset);
	AtiCore_SetDstClippingRect(NULL);

    } else return 0;
    
    return 1;
}

int finishScreen()
{
    AtiCore_ProcessDetach();
    return 1;
}

int fillRect(unsigned int x, unsigned int y, unsigned int w, unsigned int h, unsigned int c)
{
	ATI_RECT	rect;
	ATI_CLIPRECT 	clip;

	clip.X_Top_Left = x;
	clip.Y_Top_Left = y;
	clip.X_Bottom_Right = x+w;
	clip.Y_Bottom_Right = y+h;
	AtiCore_SetDstClippingRect(&clip);

	AtiCore_SetFrgColour(c);
	AtiCore_BrushType(6, 0);
	AtiCore_SetRopOperation(ROP3_PATCOPY);
	rect.XCoord = x;
	rect.YCoord = y;
	rect.Width = w;
	rect.Height = h;
	AtiCore_PaintRect(1, &rect);
	AtiCore_WaitComplete(-1);

	return 1;
}

int drawLine(unsigned int x, unsigned int y, unsigned int x1, unsigned int y1, unsigned int c)
{
	ATI_CLIPRECT 	clip;

	AtiCore_SetFrgColour(c);
	AtiCore_BrushType(6, 0);
	AtiCore_SetRopOperation(ROP3_PATCOPY);

	/* 
	 * probably polyline func draw lines on aligned coordinatez
	 * good idea setup destination clip
	 */
	 
	clip.X_Top_Left = (x>0)?x-1:x;
	clip.Y_Top_Left = (x>0)?y-1:y;
	clip.X_Bottom_Right = (x1<MAX_XSCR)?(x1+1):x1;
	clip.Y_Bottom_Right = (y1<MAX_YSCR)?(y1+1):y1;
	AtiCore_SetDstClippingRect(&clip);

	clip.X_Top_Left = x;
	clip.Y_Top_Left = y;
	clip.X_Bottom_Right = x1;
	clip.Y_Bottom_Right = y1;
	AtiCore_Polyline(2, &clip);
	AtiCore_WaitComplete(-1);

	return 1;
}

int bitBlt(unsigned int dstx, unsigned int dsty, unsigned int srcx, unsigned int srcy, unsigned int srcw, unsigned int srch)
{
	ATI_RECT	rect;
	ATI_RECT	rect1;
	ATI_CLIPRECT 	clip;

	AtiCore_SetRopOperation(ROP3_SRCCOPY);
	AtiCore_SetDstType(5); //??
	AtiCore_SetSrcType(7); //??
//	AtiCore_SetSrcType(SRCTYPE_EQU_DST);

	clip.X_Top_Left = dstx;
	clip.Y_Top_Left = dsty;
	clip.X_Bottom_Right = dstx+srcw;
	clip.Y_Bottom_Right = dsty+srch;
	AtiCore_SetDstClippingRect(&clip);

	/* destination */
	rect.XCoord = dstx;
	rect.YCoord = dsty;
	rect.Width  = srcw;
	rect.Height = srch;
	/* source */
	rect1.XCoord = srcx;
	rect1.YCoord = srcy;
	rect1.Width  = srcw;
	rect1.Height = srch;
	AtiCore_BitBlt(1, &rect, &rect1);
	AtiCore_WaitComplete(-1);

	return 1;
}

void catch_cont(int sig_num)
{
    signal(SIGCONT, catch_cont);
    printf("Cont!\n");
    finishScreen();
    if (!initScreen(MAX_XSCR, MAX_YSCR)) {
	printf("Problem with AtiCore wake up!\n");
    }
    fflush(stdout);
}

int main(int argc, char *argv[])
{
    if (initScreen(MAX_XSCR, MAX_YSCR)) {
	int x, y;
	unsigned short *fbmem;

	signal(SIGCONT, catch_cont);

	/*
	 * Fill screen with colour 0xaa00
	 */
	
//	fillRect(0,0,MAX_XSCR,MAX_YSCR, 0xaa00);

	/*
	 * Draw lines
	 */

	drawLine(10,10,10,320, 0xffff);

	drawLine(10,320,50,320, 0xffff);

	/*
	 * Draw rectangle
	 */

	fillRect(100,100,150,200,0xff);

	/*
	 * Draw line over rectangle
	 */

	drawLine(10,10,240,320, 0x0ff0);

	/*
	 * BitBlitting
	 */

	bitBlt(405,405,100,100,50,50);

	sleep(3);

	for (y=0; y<MAX_YSCR; y+=3) {
	    drawLine(0,0,MAX_XSCR-1,y,0xabcd);
	}

	/*
	 * Direct Access to framebuffer
	 */

	AtiCore_SetupMemoryTransfer(VRAMoffset, (uint32_t *)&fbmem);
	AtiCore_TerminateMemoryTransfer();

	for (y=0; y<10; y+=2) {
	    for (x=0; x<MAX_XSCR; x++) {
		fbmem[y*MAX_XSCR + x] = 0x03f0;
	    }
	}

	/*
	 * finish AtiCore
	 */
	finishScreen();
    } else {
	printf("Error: AtiCore_ProcessAttach!\n");
    }
    
    return 0;
}

/*
 * AtiCore OVERLAY
 * to be continue ... :-)
 */
