/*
 * Copyright (c) 2003 Lineo uSolutions, Inc.
 *
 *  linux/include/asm-arm/arch-db1mx1/memory.h
 *
 * Based on:
 *  linux/include/asm-arm/arch-mx1ads/memory.h
 *
 *  Copyright (C) 1999 ARM Limited
 *  Copyright (C) 2002 Shane Nay (shane@minirl.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_MMU_H
#define __ASM_ARCH_MMU_H

/*
 * Task size: 3GB
 */
#define TASK_SIZE	(0xc0000000UL)
#define TASK_SIZE_26	(0x04000000UL)

/*
 * This decides where the kernel will search for a free chunk of vm
 * space during mmap's.
 */
#define TASK_UNMAPPED_BASE (TASK_SIZE / 3)

/*
 * Page offset: 3GB
 */
/* Note
 * This should be hot-swapable with a CONFIG_DBMX1_SDRAM
 * or something similar, so we can swap between SRAM and
 * SDRAM running kernel.
 */

#ifdef CONFIG_ARCH_DBMX1_SRAM
#define PAGE_OFFSET	(0xc0000000UL)
#define PHYS_OFFSET	(0x12000000UL)
#else
#define PAGE_OFFSET	(0xc0000000UL)
#define PHYS_OFFSET	(0x08000000UL)
#endif

/*
 * On mx1, the sdram/sram is contiguous
 */
#define __virt_to_phys__is_a_macro
#define __virt_to_phys(vpage) ((vpage) - PAGE_OFFSET + PHYS_OFFSET)
#define __phys_to_virt__is_a_macro
#define __phys_to_virt(ppage) ((ppage) + PAGE_OFFSET - PHYS_OFFSET)

/*
 * Virtual view <-> DMA view memory address translations
 * virt_to_bus: Used to translate the virtual address to an
 *              address suitable to be passed to set_dma_addr
 * bus_to_virt: Used to convert an address for DMA operations
 *              to an address that the kernel can use.
 */
#define __virt_to_bus__is_a_macro
#define __virt_to_bus(x)	(x - PAGE_OFFSET +  PHYS_OFFSET)
#define __bus_to_virt__is_a_macro
#define __bus_to_virt(x)	(x -  PHYS_OFFSET + PAGE_OFFSET)

#endif
