* Reserve room on stack and float return
* PWITTE 1995
* V0.03i - Combined resri and cv_lin2flt

        section code

        xdef l2frtr

        include dev8_keys_sbasic
        include dev8_keys_qlv

*
l2frtr
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* input :
*       d1.l = long integer value to convert
*       stack must be in a tidy ("empty") state prior to this call
*
* return: cc = set
*       errors: returns directly to BASIC with d0 = 0 (or OM)
*
        move.l  d1,d6           save value
        moveq   #6,d1           reserve 6 bytes on stack for float

        move.l  sb_arthp(a6),a1
        move.w  qa.resri,a2
        jsr     (a2)

        subq.l #6,sb_arthp(a6)
        movea.l sb_arthp(a6),a1

        moveq   #ar.float,d4    return code = float

*
lin2flt
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Convert a long integer in d1 to a floating point number on a stack
*
* input :
*        d6.l = long integer to convert
*        a1  -> six free bytes on stack
*
* return :   cc set
*        a1  -> floating point number on stack
*        d6   = ???
*        errors: always 0
*
        moveq   #0,d0
        tst.l   d6              if 0 skip all this
        beq.s   l2f_ret

        move.w  #$81F,d0        exponent bias
*
lin_loop
        add.l   d6,d6           normalise: loop until
        dbvs    d0,lin_loop       sign changes (fiddling exp all the while)

        roxr.l  #1,d6           back one restoring last bit shifted out

l2f_ret
        move.w  d0,0(a6,a1.l)   that's exponent done
        move.l  d6,2(a6,a1.l)   that's the mantissa done
        moveq   #0,d0           never fails
        rts

*
        end
