* Sprite Address routines - WMAN2 compatible only!
* pjwitte 2oo4 March 19th 2004
*
* V0.01

        section code

        xdef get_fspra
        xdef get_sspra

        xref l2frtr

        include dev8_keys_con
        include dev8_keys_sys
        include dev8_keys_qdos_sms
        include dev8_keys_sbasic
        include dev8_keys_qlv

*
get_fspra
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Given the address of a (possible) chain of sprites, return the address of
* a fitting sprite for the display mode
*
* faddress = GET_FSPRA(address)
*
* where faddress is the address of the fitting sprite or 0 ( => none found)
*       address  is the address of the first sprite in the chain


        move.w sb.gtlin,a2      get long integer
        bsr.s common             or die

        moveq #0,d1             get address of ssprite #0 for comparison
        bsr.s sspra

        movea.l sb_arthp(a6),a1 restore stack pointer

        move.l 0(a6,a1.l),a1    sprite address
        addq.l #4,sb_arthp(a6)

        jsr pv_fspr(a0)         do it

        sub.l a1,d1             fitting sprite found?
        beq.s ret                no, return 0

        move.l a1,d1             yes, return address
        bra.s ret

*
common
        jsr (a2)
        bne.s err_ret

        subq.w #1,d3
        bne.s err_bp

*
gtvec
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* get CON driver vector (as described by Marcel Kilgus)
*
* returns:
*       a0 -> vector table
*       a3 -> CON linkage
*
*       d0-d2 smashed

        moveq #sms.info,d0
        trap #do.smsq           get ptr to system variables in a0

        move.l sys_clnk(a0),a3  ptr to CON linkage
        move.l pt_vecs(a3),a0   vector table
        rts

*
get_sspra
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Get the address of a system sprite, given the number
*
* address = GET_SSPRA(no%)
*
* where address is the address of the sprite, or error code
*       no% is the system sprite number


        move.w sb.gtint,a2      get integer
        bsr.s common             or die

        move.w 0(a6,a1.l),d1    sprite number
        addq.l #2,sb_arthp(a6)

        bsr.s sspra

ret
        bra l2frtr

*
err_bp
        moveq #-15,d0

*
err_ret
        lea.l 4(a7),a7
        rts

*
sspra
        suba.l a1,a1            get
        jsr pv_sspr(a0)         do it

        move.l d0,d1            error?
        bne.s rts                yes

        move.l a1,d1             no, return address

rts
        rts

*
        end
