# 1 "ppp.c"

# 30 "types.h"
typedef unsigned long UDWORD;
typedef unsigned short UWORD;
typedef unsigned char UBYTE;
typedef signed short WORD;
typedef unsigned char BOOL;
# 12 "ppp.h"
struct sipcp_header {
UBYTE type;
UBYTE length;
union uipcp_header_data {
UWORD compression_protocol;
UDWORD addr;
} u;
};

typedef struct sipcp_header mipcp_header;

int ppp_init(void);
int ppp_open(void);
int ppp_close(void);
int ppp_send(UWORD len);
UBYTE *ppp_poll(void);
UBYTE *ppp_prep(void);
# 17 "hldc.h"
extern int hldc_init(void);
extern int hldc_open(void);
extern int hldc_close(void);
extern UBYTE *hldc_prep(void);
extern int hldc_send(UWORD len, BOOL can_compress);
extern UBYTE *hldc_poll(UWORD *len);


extern UBYTE hldc_set_options(UBYTE new_options);
extern UBYTE hldc_get_options(void);
# 14 "lcp_options.h"
struct slcp_option {
UBYTE type;
UBYTE length;
# 23
UWORD data;
};

typedef struct slcp_option mlcp_option;

struct slcp_header {
UBYTE code;
UBYTE ident;
UWORD length;
};

typedef struct slcp_header mlcp_header;

struct slcp_options {
mlcp_header *header;
UBYTE *packet;
UBYTE *scan;
UWORD left;
UBYTE reject[60];
UBYTE accept[60];
int reject_end;
int accept_end;
};

typedef struct slcp_options mlcp_options;


extern int lcp_options_init(mlcp_options *options, UBYTE *packet);

extern mlcp_option *lcp_options_next(mlcp_options *options);

extern int lcp_options_reject(mlcp_options *options, mlcp_option *rejected);

extern int lcp_options_accept(mlcp_options *options, mlcp_option *accepted);

extern int lcp_options_reply(mlcp_options *options, UWORD dll_type);
# 9 "/home/dom/z88dk/include/stdlib.h"
extern __LIB__ abs(int);
extern long __LIB__ labs(long);
extern __LIB__ atexit();
extern __LIB__ __FASTCALL__ exit(int);


extern long __LIB__ strtol(char *,char **,int);
extern unsigned long __LIB__ strtoul(char *,char **,int);


extern int __LIB__ atoi(char *);
# 36
extern int __LIB__ rand(void);
extern void __LIB__ srand(int);

extern __LIB__ sleep(int);



extern __LIB__ mkdir(char *, int mode);
extern char __LIB__ *getcwd(char *buf, int maxlen);

extern __LIB__ csleep(int);
# 27 "/home/dom/z88dk/include/malloc.h"
extern void __LIB__ *calloc(int,int);
extern void __LIB__ *malloc(int);
extern void __LIB__ free(void *);
extern int __LIB__ getfree();
extern int __LIB__ getlarge();
extern void __LIB__ heapinit(int);
# 13 "/home/dom/z88dk/include/sys/types.h"
typedef unsigned int size_t;




typedef signed int ssize_t;




typedef unsigned long clock_t;




typedef signed int pid_t;




typedef unsigned char bool_t;




typedef long time_t;




typedef short wild_t;




typedef unsigned long fpos_t;



typedef unsigned char u8_t;
typedef unsigned short u16_t;
typedef unsigned long u32_t;

typedef char i8_t;
typedef short i16_t;
typedef long i32_t;
# 17 "/home/dom/z88dk/include/net/inet.h"
typedef unsigned long ipaddr_t;
typedef unsigned int tcpport_t;
# 35
struct ip_header {
u8_t version;
u8_t tos;
u16_t length;
u16_t ident;
u16_t frag;
u8_t ttl;
u8_t protocol;
u16_t cksum;
ipaddr_t source;
ipaddr_t dest;
};
# 60
struct tcp_header {
tcpport_t srcport;
tcpport_t dstport;
u32_t seqnum;
u32_t acknum;
u8_t offset;
u8_t flags;
u16_t window;
u16_t cksum;
u16_t urgptr;
};
# 86
struct icmp_header {
u8_t type;
u8_t code;
u16_t cksum;
u32_t unused;
char data[28];
};



struct udp_header {
tcpport_t srcport;
tcpport_t dstport;
u16_t length;
u16_t cksum;
};


typedef struct tcp_header tcp_header_t;
typedef struct ip_header ip_header_t;
typedef struct udp_header udp_header_t;
typedef struct icmp_header icmp_header_t;
# 20 "/home/dom/z88dk/include/net/hton.h"
extern unsigned long __LIB__ __FASTCALL__ htonl(unsigned long);

extern unsigned int __LIB__ __FASTCALL__ htons(unsigned int);
# 28 "/home/dom/z88dk/include/fcntl.h"
typedef int mode_t;


extern int __LIB__ open(far char *name, int flags, mode_t mode);
extern int __LIB__ creat(far char *name, mode_t mode);
extern int __LIB__ close(int fd);
extern size_t __LIB__ read(int fd, void *ptr, size_t len);
extern size_t __LIB__ write(int fd, void *ptr, size_t len);
extern long __LIB__ lseek(int fd,long posn, int whence);

extern int __LIB__ __FASTCALL__ readbyte(int fd);
extern int __LIB__ writebyte(int fd, int c);



extern int __LIB__ open_z88(far char *name, int flags, mode_t mode, char *explicit, size_t len);



extern int __LIB__ nropen(char *name, int flags, mode_t mode, char *explicit, size_t len);
# 36 "/home/dom/z88dk/include/z88stdio.h"
extern int *_sgoioblk[3];
# 58
extern int __LIB__ *zfdopen(far char *name, char *mode);

extern int __LIB__ *zfdopen_z88(far char *name, char *mode, char *explicit, size_t len);
# 66
extern char __LIB__ *fdfgets(char *, int, int *);

extern __LIB__ fdfputc(int , int *);

extern int __LIB__ fdfgetc(int *);

extern __LIB__ fdfputs(unsigned char *, int *);

extern __LIB__ fdfeof(int *);

extern long __LIB__ fdtell(int *);

extern int __LIB__ fdgetpos(int *,fpos_t *);



extern int __LIB__ fdfread(void *, int, int, int *);

extern int __LIB__ fdfwrite(void *, int, int, int *);
# 111
extern __LIB__ fdprintn(int number, int radix,int *file);


extern int __LIB__ remove(far char *);
extern int __LIB__ rename(char *, char *);


extern void __LIB__ printk(char *fmt,...);




extern char __LIB__ getk(void);



extern char __LIB__ fgetc_cons(void);




extern __LIB__ fputc_cons(char);

extern __LIB__ putn(int);

extern __LIB__ fdputs(char *);
extern __LIB__ settxy(int, int);
# 145
extern int __LIB__ getarg(void);
# 151
extern int __LIB__ fchkhdl(int *);
#asm
#endasm
# 26 "/home/dom/z88dk/include/time.h"
extern time_t __LIB__ time(time_t *);
# 32
extern time_t __LIB__ get1970();
extern time_t __LIB__ doepoch(long day, long sec);
extern long __LIB__ gtoy();

struct tm {
int tm_sec;
int tm_min;
int tm_hour;
int tm_mday;
int tm_mon;
int tm_year;
int tm_wday;
int tm_yday;
int tm_isdst;
};
# 56
extern struct tm __LIB__ *gmtime(time_t *t);
extern struct tm __LIB__ *localtime(time_t *t);
# 65
extern clock_t __LIB__ clock(void);
# 17 "ppp.c"
UBYTE ppp_state;
# 30
const UBYTE ppp_lcp_default_options[] = {
0xC0, 0x21,
1,
0x01,
0, 20,
2,
6,
0, 0, 0, 0,
5,
6,
0x12, 0x34, 0x56, 0x78,
7,
2,
8,
2
};



const UBYTE ppp_ipcp_default_options[] = {
0x80, 0x21,
1,
0x01,
0, 10,
3,
6
};

UBYTE ppp_ipcp_ip_address[] = {
0, 0, 0, 0
};


UBYTE ppp_magic[] = {
0x12, 0x34, 0x56, 0x78
};

const char *ppp_lcp_options_names[] = {
"00", "MRU", "asyncmap", "auth", "quality", "magic", "06", "pcomp", "acomp"};

const char *ppp_ipcp_options_names[] = {
"00", "01", "02", "03", "04", "05", "06"};

void lcp_reply(UWORD dll_type, UBYTE ident, UBYTE *data, UBYTE data_length)
{
UBYTE *into;
mlcp_header *lcp;

into = hldc_prep();

*(into++) = 0xC021>>8;
*(into++) = 0xC021&0xff;

lcp = (mlcp_header *)into;
lcp->code = dll_type;
lcp->ident = ident;
lcp->length = htons(sizeof(mlcp_header) + data_length);


into += sizeof(mlcp_header);

memcpy(into, data, data_length);

hldc_send(2 + sizeof(mlcp_header) + data_length, 0);
}

int ppp_init(void)
{
ppp_state = 1;
return 0;
}

int ppp_state_machine(UBYTE *packet, UWORD len)
{
UBYTE *into;
UWORD dll;
mlcp_header *lcp;
mlcp_option *option;
mlcp_options options;


if (ppp_state == 0)
return -1;

if (len!=0) {

dll = *(packet++);
len--;
if (!(dll&1)) {
dll = dll << 8 | *(packet++);
len--;
}
# 125
switch (dll) {
case 0xC021:
lcp = (mlcp_header *)packet;
switch (lcp->code) {

case 9:
# 135
lcp_reply(10, lcp->ident, ppp_magic, 4);
break;
case 5:
# 142
lcp_reply(6, lcp->ident, ((void *)0), 0);
ppp_state = 40;
break;
case 1:
# 150
lcp_options_init(&options, packet);
while ((option = lcp_options_next(&options))) {
# 155
switch (option->type) {
case 2:

lcp_options_accept(&options, option);
break;
case 5:

lcp_options_accept(&options, option);
break;
case 7:

lcp_options_accept(&options, option);
hldc_set_options(hldc_get_options() | 8);
break;
case 8:

lcp_options_accept(&options, option);
hldc_set_options(hldc_get_options() | 4);
break;
default:

lcp_options_reject(&options, option);
break;
}
}

hldc_send(lcp_options_reply(&options, 0xC021), 0);


if (ppp_state == 1) {
into = hldc_prep();
memcpy(into, ppp_lcp_default_options, 22);
hldc_send(22, 0);
ppp_state = 2;
}
break;
case 2:
# 196
hldc_set_options(hldc_get_options() | 2 | 1);


if (ppp_state == 2)
ppp_state = 10;
break;
case 4:
case 3:

printk("ppp_state_machine: panic - peer rejected some options.\n");

break;
}
break;
case 0x8021:


lcp_options_init(&options, packet);
switch (options.header->code) {
case 1:
# 219
while ((option = lcp_options_next(&options))) {
# 223
switch (option->type) {
case 3:

lcp_options_accept(&options, option);
break;
default:

lcp_options_reject(&options, option);
}
}
hldc_send(lcp_options_reply(&options, 0x8021), 0);


if (ppp_state == 10) {
into = hldc_prep();
memcpy(into, ppp_ipcp_default_options, 8);
memcpy(into + 8, ppp_ipcp_ip_address, 4);
hldc_send(8 + 4, 0);
ppp_state = 11;
}
break;
case 2:
# 248
ppp_state = 20;
break;
case 3:

while ((option = lcp_options_next(&options))) {
# 256
switch (option->type) {
case 3:

memcpy(ppp_ipcp_ip_address, &(option->data), 4);
break;
default:

printk("ppp_state_machine: panic: other options NAKED!\n");

break;
}
}

into = hldc_prep();
memcpy(into, ppp_ipcp_default_options, 8);
memcpy(into + 8, ppp_ipcp_ip_address, 4);
hldc_send(8 + 4, 0);
ppp_state = 11;
break;
}
break;
default:
# 283
dll = htons(dll);
lcp_reply(8, 1, (UBYTE *)&dll, 2);
}
}
return 0;
}

int ppp_open(void)
{
UBYTE *packet;
UWORD len;
time_t timeout;

timeout = time(((void *)0))+30;


while ((time(((void *)0))<timeout)&&(ppp_state!=20)) {
while (((packet=hldc_poll(&len))==((void *)0))&&(time(((void *)0))<timeout));

if (packet)
ppp_state_machine(packet, len);
}
if (ppp_state==20)
return 0;
return -1;
}

int ppp_close(void)
{

BOOL ack_received;
UBYTE *packet;
UWORD len;
UWORD dll;
time_t timeout;

timeout = time(((void *)0))+30;

ack_received = 0;


while ((time(((void *)0))<timeout)&&(!ack_received)) {

lcp_reply(5, 1, ((void *)0), 0);

while (((packet=hldc_poll(&len))==((void *)0))&&(time(((void *)0))<timeout));

if (packet) {


dll = *(packet++);
len--;
if (!(dll&1)) {
dll = dll << 8 | *(packet++);
len--;
}
if (dll == 0xC021) {
if ((*packet) == 6) {
ack_received = 1;
}
}
else {

lcp_reply(5, 1, ((void *)0), 0);
}
}
}

hldc_close();

return 0;
}

UBYTE *ppp_prep(void)
{
UBYTE *into;
into = hldc_prep();
*(into++) = (0x0021>>8);
*(into++) = (0x0021&0xff);

return into;
}

UBYTE *ppp_poll(void)
{
UBYTE *ret, *packet;
UWORD dll, len;
if ((packet=hldc_poll(&len))!=((void *)0)) {
ret = packet;
dll = *(ret++);
if (!(dll&1)) {
dll = dll << 8 | *(ret++);
}
# 379
if (dll==0x0021) {
return ret;
}
else
ppp_state_machine(packet, len);
}
return ((void *)0);
}

int ppp_send(UWORD len)
{
return hldc_send(len+2, 1);
}
