#include "pvr350osd.h"
#include <errno.h>
#include <assert.h>
#include <sys/ioctl.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

extern "C" {
#include "videodev.h"
#include "videodev2.h"

#include "ivtv-ext-api.h"
}
cPvr350Osd::cPvr350Osd(int fbfd, unsigned char *osdbuf, int X, int Y)
    :cOsdBase(X, Y) 
{
    memset(m_ShownWindows, 0, sizeof(m_ShownWindows));
    fd = fbfd;
    osd = osdbuf;  
}

cPvr350Osd::~cPvr350Osd()
{  
    for (int i = 0; i < NumWindows(); i++)
          CloseWindow(GetWindowNr(i));
}

bool cPvr350Osd::OpenWindow(cWindow *Window)
{
    m_ShownWindows[Window->Handle()] = true;
    if (Window->ClearWithBackground()) {
        for ( int yp = 0; yp < Window->Height(); yp++ ) {
            for ( int xp = 0; xp < Window->Width(); xp++ ) {
                eDvbColor c = clrBackground;

                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) ] = ( c >> 16 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 1] = ( c >> 8 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 2] = ( c >> 0 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 3] = ( c >> 24 ) & 0xFF;              
            }
        }
        struct ivtvfb_ioctl_dma_host_to_ivtv_args prep;
        memset(&prep, 0, sizeof(prep));

        prep.source = osd;
        prep.dest_offset = 0;
        prep.count = 720 * 576 * 4;
        
        ioctl(fd, IVTVFB_IOCTL_PREP_FRAME, &prep);
    }

    return true;
}

void cPvr350Osd::CommitWindow(cWindow *Window)
{
	int x1 = 0, y1 = 0, x2 = 0, y2 = 0;
    int ret;

    if (!m_ShownWindows[Window->Handle()])
        return;


    if (Window->Dirty(x1, y1, x2, y2)) {

        for ( int yp = y1; yp <= y2; yp++ ) {
            for ( int xp = x1; xp <= x2; xp++  ) {
                eDvbColor c = Window->GetColor(*Window->Data(xp,yp));

                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) ] = ( c >> 16 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 * 4) + ((xp +  Window->X0() + X0()) * 4) + 1] = ( c >> 8 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 2] = ( c >> 0 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 3] = ( c >> 24 ) & 0xFF;              

            }
        }
        struct ivtvfb_ioctl_dma_host_to_ivtv_args prep;
        memset(&prep, 0, sizeof(prep));

        prep.source = osd;
        prep.dest_offset = 0;
        prep.count = 720 * 576 * 4;
        
        ioctl(fd, IVTVFB_IOCTL_PREP_FRAME, &prep);

    }
}

void cPvr350Osd::ShowWindow(cWindow *Window)
{
    for ( int yp = 0; yp < Window->Height(); yp++ ) {
        for ( int xp = 0; xp < Window->Width(); xp++ ) {
            eDvbColor c = Window->GetColor(*Window->Data(xp,yp));

            //  printf("%d %d %d\n",yp,xp,((yp + Y0() + Window->Y0()) * 720 * 4) + ((xp +  Window->X0() + X0()) * 4));
            //    printf("%d %d %d %d\n",X0(),Window->X0(),Y0(),Window->Y0());
            osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) ] = ( c >> 16 ) & 0xFF;
            osd[((yp + Y0() + Window->Y0()) * 720 * 4) + ((xp +  Window->X0() + X0()) * 4) + 1] = ( c >> 8 ) & 0xFF;
            osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 2] = ( c >> 0 ) & 0xFF;
            osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 3] = ( c >> 24 ) & 0xFF;              
        }
    }
    struct ivtvfb_ioctl_dma_host_to_ivtv_args prep;
    memset(&prep, 0, sizeof(prep));

    prep.source = osd;
    prep.dest_offset = 0;
    prep.count = 720 * 576 * 4;
        
    ioctl(fd, IVTVFB_IOCTL_PREP_FRAME, &prep);
}

void cPvr350Osd::HideWindow(cWindow *Window, bool Hide)
{ 
    m_ShownWindows[Window->Handle()] = !Hide;

    if ( Hide ) {
        for ( int yp = 0; yp < Window->Height(); yp++ ) {
            for ( int xp = 0; xp < Window->Width(); xp++ ) {
                uint32_t c = 0;
            
            //  printf("%d %d %d\n",yp,xp,((yp + Y0() + Window->Y0()) * 720 * 4) + ((xp +  Window->X0() + X0()) * 4));
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) ] = ( c >> 16 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 * 4) + ((xp +  Window->X0() + X0()) * 4) + 1] = ( c >> 8 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 2] = ( c >> 0 ) & 0xFF;
                osd[((yp + Y0() + Window->Y0()) * 720 *4) + ((xp +  Window->X0() + X0()) * 4) + 3] = ( c >> 24 ) & 0xFF;              
            }
        }
        struct ivtvfb_ioctl_dma_host_to_ivtv_args prep;
        memset(&prep, 0, sizeof(prep));
        
        prep.source = osd;
        prep.dest_offset = 0;
        prep.count = 720 * 576 * 4;
        
        ioctl(fd, IVTVFB_IOCTL_PREP_FRAME, &prep);
    }   
}


void cPvr350Osd::MoveWindow(cWindow *Window, int X, int Y)
{    


}

void cPvr350Osd::CloseWindow(cWindow *Window)
{
    HideWindow(Window, true);
    m_ShownWindows[Window->Handle()] = false;
}
